/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cloud.objectstorage.http.apache.client.impl;

import com.ibm.cloud.objectstorage.SDKGlobalConfiguration;
import com.ibm.cloud.objectstorage.http.AmazonHttpClient;
import com.ibm.cloud.objectstorage.http.DelegatingDnsResolver;
import com.ibm.cloud.objectstorage.http.client.ConnectionManagerFactory;
import com.ibm.cloud.objectstorage.http.conn.ssl.SdkTLSSocketFactory;
import com.ibm.cloud.objectstorage.http.settings.HttpClientSettings;
import com.ibm.cloud.objectstorage.internal.SdkSSLContext;
import com.ibm.cloud.objectstorage.thirdparty.apache.http.HttpHost;
import com.ibm.cloud.objectstorage.thirdparty.apache.http.config.ConnectionConfig;
import com.ibm.cloud.objectstorage.thirdparty.apache.http.config.Registry;
import com.ibm.cloud.objectstorage.thirdparty.apache.http.config.RegistryBuilder;
import com.ibm.cloud.objectstorage.thirdparty.apache.http.config.SocketConfig;
import com.ibm.cloud.objectstorage.thirdparty.apache.http.conn.HttpClientConnectionManager;
import com.ibm.cloud.objectstorage.thirdparty.apache.http.conn.socket.ConnectionSocketFactory;
import com.ibm.cloud.objectstorage.thirdparty.apache.http.conn.socket.LayeredConnectionSocketFactory;
import com.ibm.cloud.objectstorage.thirdparty.apache.http.conn.socket.PlainConnectionSocketFactory;
import com.ibm.cloud.objectstorage.thirdparty.apache.http.conn.ssl.SSLConnectionSocketFactory;
import com.ibm.cloud.objectstorage.thirdparty.apache.http.impl.conn.DefaultSchemePortResolver;
import com.ibm.cloud.objectstorage.thirdparty.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import com.ibm.cloud.objectstorage.thirdparty.apache.http.protocol.HttpContext;
import com.ibm.cloud.objectstorage.thirdparty.apache.logging.Log;
import com.ibm.cloud.objectstorage.thirdparty.apache.logging.LogFactory;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;

public class ApacheConnectionManagerFactory
implements ConnectionManagerFactory<HttpClientConnectionManager> {
    private final Log LOG = LogFactory.getLog(AmazonHttpClient.class);

    @Override
    public HttpClientConnectionManager create(HttpClientSettings settings) {
        ConnectionSocketFactory sslsf = this.getPreferredSocketFactory(settings);
        PoolingHttpClientConnectionManager cm = new PoolingHttpClientConnectionManager(this.createSocketFactoryRegistry(sslsf), null, DefaultSchemePortResolver.INSTANCE, new DelegatingDnsResolver(settings.getDnsResolver()), settings.getConnectionPoolTTL(), TimeUnit.MILLISECONDS);
        cm.setValidateAfterInactivity(settings.getValidateAfterInactivityMillis());
        cm.setDefaultMaxPerRoute(settings.getMaxConnections());
        cm.setMaxTotal(settings.getMaxConnections());
        cm.setDefaultSocketConfig(this.buildSocketConfig(settings));
        cm.setDefaultConnectionConfig(this.buildConnectionConfig(settings));
        return cm;
    }

    private ConnectionSocketFactory getPreferredSocketFactory(HttpClientSettings settings) {
        ConnectionSocketFactory sslsf = settings.getApacheHttpClientConfig().getSslSocketFactory();
        return sslsf != null ? sslsf : new SdkTLSSocketFactory(SdkSSLContext.getPreferredSSLContext(settings.getSecureRandom()), this.getHostNameVerifier(settings));
    }

    private SocketConfig buildSocketConfig(HttpClientSettings settings) {
        return SocketConfig.custom().setSoKeepAlive(settings.useTcpKeepAlive()).setSoTimeout(settings.getSocketTimeout()).setTcpNoDelay(true).build();
    }

    private ConnectionConfig buildConnectionConfig(HttpClientSettings settings) {
        int socketBufferSize = Math.max(settings.getSocketBufferSize()[0], settings.getSocketBufferSize()[1]);
        return socketBufferSize <= 0 ? null : ConnectionConfig.custom().setBufferSize(socketBufferSize).build();
    }

    private HostnameVerifier getHostNameVerifier(HttpClientSettings options) {
        return options.useBrowserCompatibleHostNameVerifier() ? SSLConnectionSocketFactory.BROWSER_COMPATIBLE_HOSTNAME_VERIFIER : SSLConnectionSocketFactory.STRICT_HOSTNAME_VERIFIER;
    }

    private Registry<ConnectionSocketFactory> createSocketFactoryRegistry(ConnectionSocketFactory sslSocketFactory) {
        if (SDKGlobalConfiguration.isCertCheckingDisabled()) {
            if (this.LOG.isWarnEnabled()) {
                this.LOG.warn("SSL Certificate checking for endpoints has been explicitly disabled.");
            }
            sslSocketFactory = new TrustingSocketFactory();
        }
        return RegistryBuilder.create().register("http", PlainConnectionSocketFactory.getSocketFactory()).register("https", (PlainConnectionSocketFactory)sslSocketFactory).build();
    }

    public static class TrustingX509TrustManager
    implements X509TrustManager {
        private static final X509Certificate[] X509_CERTIFICATES = new X509Certificate[0];

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return X509_CERTIFICATES;
        }

        @Override
        public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        }

        @Override
        public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        }
    }

    private static class TrustingSocketFactory
    implements LayeredConnectionSocketFactory {
        private SSLContext sslcontext = null;

        private TrustingSocketFactory() {
        }

        private static SSLContext createSSLContext() throws IOException {
            try {
                SSLContext context = SSLContext.getInstance("TLS");
                context.init(null, new TrustManager[]{new TrustingX509TrustManager()}, null);
                return context;
            }
            catch (Exception e) {
                throw new IOException(e.getMessage(), e);
            }
        }

        @Override
        public Socket createLayeredSocket(Socket socket, String target, int port, HttpContext context) throws IOException, UnknownHostException {
            return this.getSSLContext().getSocketFactory().createSocket(socket, target, port, true);
        }

        @Override
        public Socket createSocket(HttpContext context) throws IOException {
            return this.getSSLContext().getSocketFactory().createSocket();
        }

        @Override
        public Socket connectSocket(int connectTimeout, Socket sock, HttpHost host, InetSocketAddress remoteAddress, InetSocketAddress localAddress, HttpContext context) throws IOException {
            SSLSocket sslsock = (SSLSocket)(sock != null ? sock : this.createSocket(context));
            if (localAddress != null) {
                sslsock.bind(localAddress);
            }
            sslsock.connect(remoteAddress, connectTimeout);
            return sslsock;
        }

        private SSLContext getSSLContext() throws IOException {
            if (this.sslcontext == null) {
                this.sslcontext = TrustingSocketFactory.createSSLContext();
            }
            return this.sslcontext;
        }
    }
}

