/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cloud.objectstorage;

import com.ibm.cloud.objectstorage.AmazonWebServiceRequest;
import com.ibm.cloud.objectstorage.ClientConfiguration;
import com.ibm.cloud.objectstorage.Request;
import com.ibm.cloud.objectstorage.Response;
import com.ibm.cloud.objectstorage.ServiceNameFactory;
import com.ibm.cloud.objectstorage.annotation.SdkInternalApi;
import com.ibm.cloud.objectstorage.annotation.SdkProtectedApi;
import com.ibm.cloud.objectstorage.auth.RegionAwareSigner;
import com.ibm.cloud.objectstorage.auth.Signer;
import com.ibm.cloud.objectstorage.auth.SignerFactory;
import com.ibm.cloud.objectstorage.client.AwsSyncClientParams;
import com.ibm.cloud.objectstorage.handlers.RequestHandler;
import com.ibm.cloud.objectstorage.handlers.RequestHandler2;
import com.ibm.cloud.objectstorage.http.AmazonHttpClient;
import com.ibm.cloud.objectstorage.http.ExecutionContext;
import com.ibm.cloud.objectstorage.internal.DefaultServiceEndpointBuilder;
import com.ibm.cloud.objectstorage.internal.auth.DefaultSignerProvider;
import com.ibm.cloud.objectstorage.internal.auth.SignerProvider;
import com.ibm.cloud.objectstorage.internal.auth.SignerProviderContext;
import com.ibm.cloud.objectstorage.log.CommonsLogFactory;
import com.ibm.cloud.objectstorage.log.InternalLogFactory;
import com.ibm.cloud.objectstorage.metrics.AwsSdkMetrics;
import com.ibm.cloud.objectstorage.metrics.RequestMetricCollector;
import com.ibm.cloud.objectstorage.regions.Region;
import com.ibm.cloud.objectstorage.regions.Regions;
import com.ibm.cloud.objectstorage.thirdparty.apache.logging.Log;
import com.ibm.cloud.objectstorage.thirdparty.apache.logging.LogFactory;
import com.ibm.cloud.objectstorage.util.AWSRequestMetrics;
import com.ibm.cloud.objectstorage.util.AwsHostNameUtils;
import com.ibm.cloud.objectstorage.util.Classes;
import com.ibm.cloud.objectstorage.util.RuntimeHttpUtils;
import com.ibm.cloud.objectstorage.util.StringUtils;
import java.net.URI;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;

public abstract class AmazonWebServiceClient {
    @Deprecated
    public static final boolean LOGGING_AWS_REQUEST_METRIC = true;
    private static final String AMAZON = "Amazon";
    private static final String AWS = "AWS";
    private static final Log log = LogFactory.getLog(AmazonWebServiceClient.class);
    private volatile boolean isImmutable = false;
    protected volatile URI endpoint;
    private volatile String signerRegionOverride;
    protected ClientConfiguration clientConfiguration;
    protected AmazonHttpClient client;
    protected final List<RequestHandler2> requestHandler2s;
    protected int timeOffset;
    private volatile SignerProvider signerProvider;
    private volatile String serviceName;
    private volatile String endpointPrefix;

    public AmazonWebServiceClient(ClientConfiguration clientConfiguration) {
        this(clientConfiguration, null);
    }

    public AmazonWebServiceClient(ClientConfiguration clientConfiguration, RequestMetricCollector requestMetricCollector) {
        this(clientConfiguration, requestMetricCollector, false);
    }

    @SdkProtectedApi
    protected AmazonWebServiceClient(ClientConfiguration clientConfiguration, RequestMetricCollector requestMetricCollector, boolean disableStrictHostNameVerification) {
        this.clientConfiguration = clientConfiguration;
        this.requestHandler2s = new CopyOnWriteArrayList<RequestHandler2>();
        this.client = new AmazonHttpClient(clientConfiguration, requestMetricCollector, disableStrictHostNameVerification, this.calculateCRC32FromCompressedData());
    }

    protected AmazonWebServiceClient(AwsSyncClientParams clientParams) {
        this.clientConfiguration = clientParams.getClientConfiguration();
        this.requestHandler2s = clientParams.getRequestHandlers();
        this.client = new AmazonHttpClient(this.clientConfiguration, clientParams.getRequestMetricCollector(), !this.useStrictHostNameVerification(), this.calculateCRC32FromCompressedData());
    }

    @Deprecated
    protected Signer getSigner() {
        return this.signerProvider.getSigner(SignerProviderContext.builder().build());
    }

    @SdkProtectedApi
    protected SignerProvider getSignerProvider() {
        return this.signerProvider;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public void setEndpoint(String endpoint) throws IllegalArgumentException {
        this.checkMutability();
        URI uri = this.toURI(endpoint);
        Signer signer = this.computeSignerByURI(uri, this.signerRegionOverride, false);
        AmazonWebServiceClient amazonWebServiceClient = this;
        synchronized (amazonWebServiceClient) {
            this.endpoint = uri;
            this.signerProvider = this.createSignerProvider(signer);
        }
    }

    private URI toURI(String endpoint) throws IllegalArgumentException {
        return RuntimeHttpUtils.toUri(endpoint, this.clientConfiguration);
    }

    public Signer getSignerByURI(URI uri) {
        return this.computeSignerByURI(uri, this.signerRegionOverride, true);
    }

    private Signer computeSignerByURI(URI uri, String signerRegionOverride, boolean isRegionIdAsSignerParam) {
        if (uri == null) {
            throw new IllegalArgumentException("Endpoint is not set. Use setEndpoint to set an endpoint before performing any request.");
        }
        String service = this.getServiceNameIntern();
        String region = AwsHostNameUtils.parseRegionName(uri.getHost(), service);
        return this.computeSignerByServiceRegion(service, region, signerRegionOverride, isRegionIdAsSignerParam);
    }

    private Signer computeSignerByServiceRegion(String serviceName, String regionId, String signerRegionOverride, boolean isRegionIdAsSignerParam) {
        Signer signer;
        String signerType = this.clientConfiguration.getSignerOverride();
        Signer signer2 = signer = signerType == null ? SignerFactory.getSigner(serviceName, regionId) : SignerFactory.getSignerByTypeAndService(signerType, serviceName);
        if (signer instanceof RegionAwareSigner) {
            RegionAwareSigner regionAwareSigner = (RegionAwareSigner)signer;
            if (signerRegionOverride != null) {
                regionAwareSigner.setRegionName(signerRegionOverride);
            } else if (regionId != null && isRegionIdAsSignerParam) {
                regionAwareSigner.setRegionName(regionId);
            }
        }
        return signer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public void setRegion(Region region) throws IllegalArgumentException {
        this.checkMutability();
        if (region == null) {
            throw new IllegalArgumentException("No region provided");
        }
        String serviceNameForEndpoint = this.getEndpointPrefix();
        String serviceNameForSigner = this.getServiceNameIntern();
        URI uri = new DefaultServiceEndpointBuilder(serviceNameForEndpoint, this.clientConfiguration.getProtocol().toString()).withRegion(region).getServiceEndpoint();
        Signer signer = this.computeSignerByServiceRegion(serviceNameForSigner, region.getName(), this.signerRegionOverride, false);
        AmazonWebServiceClient amazonWebServiceClient = this;
        synchronized (amazonWebServiceClient) {
            this.endpoint = uri;
            this.signerProvider = this.createSignerProvider(signer);
        }
    }

    @Deprecated
    public final void configureRegion(Regions region) {
        this.checkMutability();
        if (region == null) {
            throw new IllegalArgumentException("No region provided");
        }
        this.setRegion(Region.getRegion(region));
    }

    public void shutdown() {
        this.client.shutdown();
    }

    @Deprecated
    public void addRequestHandler(RequestHandler requestHandler) {
        this.checkMutability();
        this.requestHandler2s.add(RequestHandler2.adapt(requestHandler));
    }

    @Deprecated
    public void addRequestHandler(RequestHandler2 requestHandler2) {
        this.checkMutability();
        this.requestHandler2s.add(requestHandler2);
    }

    @Deprecated
    public void removeRequestHandler(RequestHandler requestHandler) {
        this.checkMutability();
        this.requestHandler2s.remove(RequestHandler2.adapt(requestHandler));
    }

    @Deprecated
    public void removeRequestHandler(RequestHandler2 requestHandler2) {
        this.checkMutability();
        this.requestHandler2s.remove(requestHandler2);
    }

    protected final <T extends AmazonWebServiceRequest> T beforeMarshalling(T request) {
        Object local = request;
        for (RequestHandler2 handler : this.requestHandler2s) {
            local = handler.beforeMarshalling((AmazonWebServiceRequest)local);
        }
        return local;
    }

    protected ExecutionContext createExecutionContext(AmazonWebServiceRequest req) {
        return this.createExecutionContext(req, this.signerProvider);
    }

    protected ExecutionContext createExecutionContext(AmazonWebServiceRequest req, SignerProvider signerProvider) {
        boolean isMetricsEnabled = this.isRequestMetricsEnabled(req) || AmazonWebServiceClient.isProfilingEnabled();
        return ExecutionContext.builder().withRequestHandler2s(this.requestHandler2s).withUseRequestMetrics(isMetricsEnabled).withAwsClient(this).withSignerProvider(signerProvider).build();
    }

    protected final ExecutionContext createExecutionContext(Request<?> req) {
        return this.createExecutionContext(req.getOriginalRequest());
    }

    protected SignerProvider createSignerProvider(Signer signer) {
        return new DefaultSignerProvider(this, signer);
    }

    protected static boolean isProfilingEnabled() {
        return System.getProperty("com.amazonaws.sdk.enableRuntimeProfiling") != null;
    }

    protected final boolean isRequestMetricsEnabled(AmazonWebServiceRequest req) {
        RequestMetricCollector c = req.getRequestMetricCollector();
        if (c != null && c.isEnabled()) {
            return true;
        }
        return this.isRMCEnabledAtClientOrSdkLevel();
    }

    private boolean isRMCEnabledAtClientOrSdkLevel() {
        RequestMetricCollector c = this.requestMetricCollector();
        return c != null && c.isEnabled();
    }

    public void setTimeOffset(int timeOffset) {
        this.checkMutability();
        this.timeOffset = timeOffset;
    }

    public AmazonWebServiceClient withTimeOffset(int timeOffset) {
        this.checkMutability();
        this.setTimeOffset(timeOffset);
        return this;
    }

    public int getTimeOffset() {
        return this.timeOffset;
    }

    public RequestMetricCollector getRequestMetricsCollector() {
        return this.client.getRequestMetricCollector();
    }

    protected RequestMetricCollector requestMetricCollector() {
        RequestMetricCollector mc = this.client.getRequestMetricCollector();
        return mc == null ? AwsSdkMetrics.getRequestMetricCollector() : mc;
    }

    private final RequestMetricCollector findRequestMetricCollector(RequestMetricCollector reqLevelMetricsCollector) {
        if (reqLevelMetricsCollector != null) {
            return reqLevelMetricsCollector;
        }
        if (this.getRequestMetricsCollector() != null) {
            return this.getRequestMetricsCollector();
        }
        return AwsSdkMetrics.getRequestMetricCollector();
    }

    protected final <T extends AmazonWebServiceRequest> T beforeClientExecution(T request) {
        Object local = request;
        for (RequestHandler2 handler : this.requestHandler2s) {
            local = handler.beforeExecution((AmazonWebServiceRequest)local);
        }
        return local;
    }

    protected final void endClientExecution(AWSRequestMetrics awsRequestMetrics, Request<?> request, Response<?> response) {
        this.endClientExecution(awsRequestMetrics, request, response, false);
    }

    protected final void endClientExecution(AWSRequestMetrics awsRequestMetrics, Request<?> request, Response<?> response, @Deprecated boolean loggingAwsRequestMetrics) {
        if (request != null) {
            awsRequestMetrics.endEvent(AWSRequestMetrics.Field.ClientExecuteTime);
            awsRequestMetrics.getTimingInfo().endTiming();
            RequestMetricCollector c = this.findRequestMetricCollector(request.getOriginalRequest().getRequestMetricCollector());
            c.collectMetrics(request, response);
            awsRequestMetrics.log();
        }
    }

    @Deprecated
    protected String getServiceAbbreviation() {
        return this.getServiceNameIntern();
    }

    public String getServiceName() {
        return this.getServiceNameIntern();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getEndpointPrefix() {
        if (this.endpointPrefix != null) {
            return this.endpointPrefix;
        }
        String httpClientName = this.getHttpClientName();
        String serviceNameInRegionMetadata = ServiceNameFactory.getServiceNameInRegionMetadata(httpClientName);
        AmazonWebServiceClient amazonWebServiceClient = this;
        synchronized (amazonWebServiceClient) {
            if (this.endpointPrefix != null) {
                return this.endpointPrefix;
            }
            if (serviceNameInRegionMetadata != null) {
                this.endpointPrefix = serviceNameInRegionMetadata;
                return this.endpointPrefix;
            }
            this.endpointPrefix = this.getServiceNameIntern();
            return this.endpointPrefix;
        }
    }

    protected void setEndpointPrefix(String endpointPrefix) {
        if (endpointPrefix == null) {
            throw new IllegalArgumentException("The parameter endpointPrefix must be specified!");
        }
        this.endpointPrefix = endpointPrefix;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String getServiceNameIntern() {
        if (this.serviceName == null) {
            AmazonWebServiceClient amazonWebServiceClient = this;
            synchronized (amazonWebServiceClient) {
                if (this.serviceName == null) {
                    this.serviceName = this.computeServiceName();
                    return this.serviceName;
                }
            }
        }
        return this.serviceName;
    }

    public final void setServiceNameIntern(String serviceName) {
        if (serviceName == null) {
            throw new IllegalArgumentException("The parameter serviceName must be specified!");
        }
        this.serviceName = serviceName;
    }

    private String computeServiceName() {
        int len;
        String httpClientName = this.getHttpClientName();
        String service = ServiceNameFactory.getServiceName(httpClientName);
        if (service != null) {
            return service;
        }
        int j = httpClientName.indexOf("JavaClient");
        if (j == -1 && (j = httpClientName.indexOf("Client")) == -1) {
            throw new IllegalStateException("Unrecognized suffix for the AWS http client class name " + httpClientName);
        }
        int i = httpClientName.indexOf(AMAZON);
        if (i == -1) {
            i = httpClientName.indexOf(AWS);
            if (i == -1) {
                throw new IllegalStateException("Unrecognized prefix for the AWS http client class name " + httpClientName);
            }
            len = AWS.length();
        } else {
            len = AMAZON.length();
        }
        if (i >= j) {
            throw new IllegalStateException("Unrecognized AWS http client class name " + httpClientName);
        }
        String serviceName = httpClientName.substring(i + len, j);
        return StringUtils.lowerCase(serviceName);
    }

    private String getHttpClientName() {
        Class<?> httpClientClass = Classes.childClassOf(AmazonWebServiceClient.class, this);
        return httpClientClass.getSimpleName();
    }

    public final String getSignerRegionOverride() {
        return this.signerRegionOverride;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setSignerRegionOverride(String signerRegionOverride) {
        this.checkMutability();
        Signer signer = this.computeSignerByURI(this.endpoint, signerRegionOverride, true);
        AmazonWebServiceClient amazonWebServiceClient = this;
        synchronized (amazonWebServiceClient) {
            this.signerRegionOverride = signerRegionOverride;
            this.signerProvider = this.createSignerProvider(signer);
        }
    }

    @Deprecated
    public <T extends AmazonWebServiceClient> T withRegion(Region region) {
        this.setRegion(region);
        AmazonWebServiceClient t = this;
        return (T)t;
    }

    @Deprecated
    public <T extends AmazonWebServiceClient> T withRegion(Regions region) {
        this.configureRegion(region);
        AmazonWebServiceClient t = this;
        return (T)t;
    }

    @Deprecated
    public <T extends AmazonWebServiceClient> T withEndpoint(String endpoint) {
        this.setEndpoint(endpoint);
        AmazonWebServiceClient t = this;
        return (T)t;
    }

    @Deprecated
    @SdkInternalApi
    public final void makeImmutable() {
        this.isImmutable = true;
    }

    @SdkProtectedApi
    protected final void checkMutability() {
        if (this.isImmutable) {
            throw new UnsupportedOperationException("Client is immutable when created with the builder.");
        }
    }

    protected boolean useStrictHostNameVerification() {
        return true;
    }

    protected boolean calculateCRC32FromCompressedData() {
        return false;
    }

    public String getSignerOverride() {
        return this.clientConfiguration.getSignerOverride();
    }

    static {
        boolean success = InternalLogFactory.configureFactory(new CommonsLogFactory());
        if (log.isDebugEnabled()) {
            log.debug("Internal logging successfully configured to commons logger: " + success);
        }
    }
}

