/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cloud.objectstorage.config.resource_configuration.v1.model;

import com.google.gson.annotations.SerializedName;
import com.ibm.cloud.sdk.core.service.model.GenericModel;
import com.ibm.cloud.sdk.core.util.Validator;
import java.util.ArrayList;
import java.util.List;

public class Firewall
extends GenericModel {
    @SerializedName(value="allowed_ip")
    protected List<String> allowedIp;
    @SerializedName(value="denied_ip")
    protected List<String> deniedIp;
    @SerializedName(value="allowed_network_type")
    protected List<String> allowedNetworkType;

    protected Firewall() {
    }

    protected Firewall(Builder builder) {
        this.allowedIp = builder.allowedIp;
        this.deniedIp = builder.deniedIp;
        this.allowedNetworkType = builder.allowedNetworkType;
    }

    public Builder newBuilder() {
        return new Builder(this);
    }

    public List<String> allowedIp() {
        return this.allowedIp;
    }

    public List<String> deniedIp() {
        return this.deniedIp;
    }

    public List<String> allowedNetworkType() {
        return this.allowedNetworkType;
    }

    public static class Builder {
        private List<String> allowedIp;
        private List<String> deniedIp;
        private List<String> allowedNetworkType;

        private Builder(Firewall firewall) {
            this.allowedIp = firewall.allowedIp;
            this.deniedIp = firewall.deniedIp;
            this.allowedNetworkType = firewall.allowedNetworkType;
        }

        public Builder() {
        }

        public Firewall build() {
            return new Firewall(this);
        }

        public Builder addAllowedIp(String allowedIp) {
            Validator.notNull((Object)allowedIp, (String)"allowedIp cannot be null");
            if (this.allowedIp == null) {
                this.allowedIp = new ArrayList<String>();
            }
            this.allowedIp.add(allowedIp);
            return this;
        }

        public Builder addDeniedIp(String deniedIp) {
            Validator.notNull((Object)deniedIp, (String)"deniedIp cannot be null");
            if (this.deniedIp == null) {
                this.deniedIp = new ArrayList<String>();
            }
            this.deniedIp.add(deniedIp);
            return this;
        }

        public Builder addAllowedNetworkType(String allowedNetworkType) {
            Validator.notNull((Object)allowedNetworkType, (String)"allowedNetworkType cannot be null");
            if (this.allowedNetworkType == null) {
                this.allowedNetworkType = new ArrayList<String>();
            }
            this.allowedNetworkType.add(allowedNetworkType);
            return this;
        }

        public Builder allowedIp(List<String> allowedIp) {
            this.allowedIp = allowedIp;
            return this;
        }

        public Builder deniedIp(List<String> deniedIp) {
            this.deniedIp = deniedIp;
            return this;
        }

        public Builder allowedNetworkType(List<String> allowedNetworkType) {
            this.allowedNetworkType = allowedNetworkType;
            return this;
        }
    }

    public static interface AllowedNetworkType {
        public static final String X_PUBLIC = "public";
        public static final String X_PRIVATE = "private";
        public static final String DIRECT = "direct";
    }
}

