/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cloud.objectstorage.config.resource_configuration.v1;

import com.google.gson.reflect.TypeToken;
import com.ibm.cloud.objectstorage.common.SdkCommon;
import com.ibm.cloud.objectstorage.config.resource_configuration.v1.model.Bucket;
import com.ibm.cloud.objectstorage.config.resource_configuration.v1.model.GetBucketConfigOptions;
import com.ibm.cloud.objectstorage.config.resource_configuration.v1.model.UpdateBucketConfigOptions;
import com.ibm.cloud.sdk.core.http.RequestBuilder;
import com.ibm.cloud.sdk.core.http.ResponseConverter;
import com.ibm.cloud.sdk.core.http.ServiceCall;
import com.ibm.cloud.sdk.core.security.Authenticator;
import com.ibm.cloud.sdk.core.security.ConfigBasedAuthenticatorFactory;
import com.ibm.cloud.sdk.core.service.BaseService;
import com.ibm.cloud.sdk.core.util.GsonSingleton;
import com.ibm.cloud.sdk.core.util.ResponseConverterUtils;
import com.ibm.cloud.sdk.core.util.Validator;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;
import okhttp3.HttpUrl;

public class ResourceConfiguration
extends BaseService {
    public static final String DEFAULT_SERVICE_NAME = "resource_configuration";
    public static final String DEFAULT_SERVICE_URL = "https://config.cloud-object-storage.cloud.ibm.com/v1";

    public static ResourceConfiguration newInstance() {
        return ResourceConfiguration.newInstance(DEFAULT_SERVICE_NAME);
    }

    public static ResourceConfiguration newInstance(String serviceName) {
        Authenticator authenticator = ConfigBasedAuthenticatorFactory.getAuthenticator((String)serviceName);
        ResourceConfiguration service = new ResourceConfiguration(serviceName, authenticator);
        service.configureService(serviceName);
        return service;
    }

    public ResourceConfiguration(String serviceName, Authenticator authenticator) {
        super(serviceName, authenticator);
        this.setServiceUrl(DEFAULT_SERVICE_URL);
    }

    public ServiceCall<Bucket> getBucketConfig(GetBucketConfigOptions getBucketConfigOptions) {
        Validator.notNull((Object)((Object)getBucketConfigOptions), (String)"getBucketConfigOptions cannot be null");
        HashMap<String, String> pathParamsMap = new HashMap<String, String>();
        pathParamsMap.put("bucket", getBucketConfigOptions.bucket());
        RequestBuilder builder = RequestBuilder.get((HttpUrl)RequestBuilder.resolveRequestUrl((String)this.getServiceUrl(), (String)"/b/{bucket}", pathParamsMap));
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)DEFAULT_SERVICE_NAME, (String)"v1", (String)"getBucketConfig");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        builder.header(new Object[]{"Accept", "application/json"});
        ResponseConverter responseConverter = ResponseConverterUtils.getValue((Type)new TypeToken<Bucket>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<Void> updateBucketConfig(UpdateBucketConfigOptions updateBucketConfigOptions) {
        Validator.notNull((Object)((Object)updateBucketConfigOptions), (String)"updateBucketConfigOptions cannot be null");
        HashMap<String, String> pathParamsMap = new HashMap<String, String>();
        pathParamsMap.put("bucket", updateBucketConfigOptions.bucket());
        RequestBuilder builder = RequestBuilder.patch((HttpUrl)RequestBuilder.resolveRequestUrl((String)this.getServiceUrl(), (String)"/b/{bucket}", pathParamsMap));
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)DEFAULT_SERVICE_NAME, (String)"v1", (String)"updateBucketConfig");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        if (updateBucketConfigOptions.ifMatch() != null) {
            builder.header(new Object[]{"If-Match", updateBucketConfigOptions.ifMatch()});
        }
        if (updateBucketConfigOptions.bucketPatch() != null) {
            builder.bodyContent(GsonSingleton.getGsonWithoutPrettyPrinting().toJson(updateBucketConfigOptions.bucketPatch()), "application/merge-patch+json");
        }
        ResponseConverter responseConverter = ResponseConverterUtils.getVoid();
        return this.createServiceCall(builder.build(), responseConverter);
    }
}

