/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cloud.objectstorage.config.resource_configuration.v1;

import com.google.gson.JsonObject;
import com.ibm.cloud.objectstorage.config.common.SdkCommon;
import com.ibm.cloud.objectstorage.config.resource_configuration.v1.model.Bucket;
import com.ibm.cloud.objectstorage.config.resource_configuration.v1.model.GetBucketConfigOptions;
import com.ibm.cloud.objectstorage.config.resource_configuration.v1.model.UpdateBucketConfigOptions;
import com.ibm.cloud.sdk.core.http.RequestBuilder;
import com.ibm.cloud.sdk.core.http.ServiceCall;
import com.ibm.cloud.sdk.core.service.BaseService;
import com.ibm.cloud.sdk.core.service.security.IamOptions;
import com.ibm.cloud.sdk.core.util.GsonSingleton;
import com.ibm.cloud.sdk.core.util.ResponseConverterUtils;
import com.ibm.cloud.sdk.core.util.Validator;
import java.util.Map;
import okhttp3.HttpUrl;

public class ResourceConfiguration
extends BaseService {
    private static final String SERVICE_NAME = "resource_configuration";
    private static final String URL = "https://config.cloud-object-storage.cloud.ibm.com/v1";

    public ResourceConfiguration() {
        super(SERVICE_NAME);
        if (this.getEndPoint() == null || this.getEndPoint().isEmpty()) {
            this.setEndPoint(URL);
        }
    }

    public ResourceConfiguration(IamOptions iamOptions) {
        this();
        this.setIamCredentials(iamOptions);
    }

    public ServiceCall<Bucket> getBucketConfig(GetBucketConfigOptions getBucketConfigOptions) {
        Validator.notNull((Object)((Object)getBucketConfigOptions), (String)"getBucketConfigOptions cannot be null");
        String[] pathSegments = new String[]{"b"};
        String[] pathParameters = new String[]{getBucketConfigOptions.bucket()};
        RequestBuilder builder = RequestBuilder.get((HttpUrl)RequestBuilder.constructHttpUrl((String)this.getEndPoint(), (String[])pathSegments, (String[])pathParameters));
        Map<String, String> sdkHeaders = SdkCommon.getSdkHeaders(SERVICE_NAME, "v1", "getBucketConfig");
        for (Map.Entry<String, String> header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        builder.header(new Object[]{"Accept", "application/json"});
        return this.createServiceCall(builder.build(), ResponseConverterUtils.getObject(Bucket.class));
    }

    public ServiceCall<Void> updateBucketConfig(UpdateBucketConfigOptions updateBucketConfigOptions) {
        Validator.notNull((Object)((Object)updateBucketConfigOptions), (String)"updateBucketConfigOptions cannot be null");
        String[] pathSegments = new String[]{"b"};
        String[] pathParameters = new String[]{updateBucketConfigOptions.bucket()};
        RequestBuilder builder = RequestBuilder.patch((HttpUrl)RequestBuilder.constructHttpUrl((String)this.getEndPoint(), (String[])pathSegments, (String[])pathParameters));
        Map<String, String> sdkHeaders = SdkCommon.getSdkHeaders(SERVICE_NAME, "v1", "updateBucketConfig");
        for (Map.Entry<String, String> header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        if (updateBucketConfigOptions.ifMatch() != null) {
            builder.header(new Object[]{"if-match", updateBucketConfigOptions.ifMatch()});
        }
        JsonObject contentJson = new JsonObject();
        if (updateBucketConfigOptions.firewall() != null) {
            contentJson.add("firewall", GsonSingleton.getGson().toJsonTree((Object)updateBucketConfigOptions.firewall()));
        }
        if (updateBucketConfigOptions.activityTracking() != null) {
            contentJson.add("activity_tracking", GsonSingleton.getGson().toJsonTree((Object)updateBucketConfigOptions.activityTracking()));
        }
        if (updateBucketConfigOptions.metricsMonitoring() != null) {
            contentJson.add("metrics_monitoring", GsonSingleton.getGson().toJsonTree((Object)updateBucketConfigOptions.metricsMonitoring()));
        }
        if (updateBucketConfigOptions.hardQuota() != null) {
            contentJson.addProperty("hard_quota", (Number)updateBucketConfigOptions.hardQuota());
        }
        builder.bodyJson(contentJson);
        return this.createServiceCall(builder.build(), ResponseConverterUtils.getVoid());
    }
}

