/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cloud.objectstorage.config.common;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import java.util.logging.Logger;

public class VersionUtils {
    private static final Logger LOGGER = Logger.getLogger(VersionUtils.class.getName());
    static final String VERSION_INFO_FILE = "version.properties";
    private static volatile String version;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String getVersion() {
        if (version != null) return version;
        Class<VersionUtils> clazz = VersionUtils.class;
        synchronized (VersionUtils.class) {
            if (version != null) return version;
            VersionUtils.initializeVersion();
            // ** MonitorExit[var0] (shouldn't be in output)
            return version;
        }
    }

    private static void initializeVersion() {
        InputStream inputStream = VersionUtils.class.getClassLoader().getResourceAsStream(VERSION_INFO_FILE);
        Properties versionInfoProperties = new Properties();
        try {
            if (inputStream == null) {
                throw new IOException("version.properties not found on classpath");
            }
            versionInfoProperties.load(inputStream);
            version = versionInfoProperties.getProperty("version");
        }
        catch (IOException e) {
            LOGGER.info("Unable to load version information for the running SDK: " + e.getMessage());
            version = "unknown-version";
        }
        finally {
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            catch (IOException e) {
                LOGGER.info("Ignore failure in closing the Closeable");
            }
        }
    }
}

