/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cloud.objectstorage.config.resource_configuration.v1.model;

import com.ibm.cloud.objectstorage.config.resource_configuration.v1.model.Firewall;
import com.ibm.cloud.sdk.core.service.model.GenericModel;
import com.ibm.cloud.sdk.core.util.Validator;

public class UpdateBucketConfigOptions
extends GenericModel {
    private String bucket;
    private Firewall firewall;
    private String ifMatch;

    private UpdateBucketConfigOptions(Builder builder) {
        Validator.notEmpty((String)builder.bucket, (String)"bucket cannot be empty");
        this.bucket = builder.bucket;
        this.firewall = builder.firewall;
        this.ifMatch = builder.ifMatch;
    }

    public Builder newBuilder() {
        return new Builder(this);
    }

    public String bucket() {
        return this.bucket;
    }

    public Firewall firewall() {
        return this.firewall;
    }

    public String ifMatch() {
        return this.ifMatch;
    }

    public static class Builder {
        private String bucket;
        private Firewall firewall;
        private String ifMatch;

        private Builder(UpdateBucketConfigOptions updateBucketConfigOptions) {
            this.bucket = updateBucketConfigOptions.bucket;
            this.firewall = updateBucketConfigOptions.firewall;
            this.ifMatch = updateBucketConfigOptions.ifMatch;
        }

        public Builder() {
        }

        public Builder(String bucket) {
            this.bucket = bucket;
        }

        public UpdateBucketConfigOptions build() {
            return new UpdateBucketConfigOptions(this);
        }

        public Builder bucket(String bucket) {
            this.bucket = bucket;
            return this;
        }

        public Builder firewall(Firewall firewall) {
            this.firewall = firewall;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }
    }
}

