/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.boot.autoconfiguration.kafka;

import com.ibm.boot.autoconfiguration.kafka.IBMKafkaProperties;
import com.ibm.boot.autoconfiguration.kafka.JSONPropertiesMapper;
import java.util.HashMap;
import java.util.Map;
import org.apache.kafka.common.serialization.Deserializer;
import org.apache.kafka.common.serialization.Serializer;
import org.apache.kafka.common.serialization.StringDeserializer;
import org.apache.kafka.common.serialization.StringSerializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.kafka.core.DefaultKafkaConsumerFactory;
import org.springframework.kafka.core.DefaultKafkaProducerFactory;
import org.springframework.kafka.support.converter.DefaultJackson2JavaTypeMapper;
import org.springframework.kafka.support.converter.Jackson2JavaTypeMapper;
import org.springframework.kafka.support.serializer.JsonDeserializer;
import org.springframework.kafka.support.serializer.JsonSerializer;

public class JsonBeanPostProcessor
implements BeanPostProcessor {
    private static final Logger logger = LoggerFactory.getLogger(JsonBeanPostProcessor.class);
    private final JSONPropertiesMapper jsonPropertiesMapper;
    private final IBMKafkaProperties ibmKafkaProperties;

    public JsonBeanPostProcessor(JSONPropertiesMapper jsonPropertiesMapper, IBMKafkaProperties ibmKafkaProperties) {
        this.jsonPropertiesMapper = jsonPropertiesMapper;
        this.ibmKafkaProperties = ibmKafkaProperties;
    }

    public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
        return bean;
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        String[] trustedPackages = this.ibmKafkaProperties.getSubpackages();
        Map<String, Class<?>> mappings = this.jsonPropertiesMapper.getClassMapping();
        Object result = bean;
        if (trustedPackages.length > 0) {
            if (bean instanceof DefaultKafkaProducerFactory) {
                DefaultKafkaProducerFactory producerFactory = (DefaultKafkaProducerFactory)bean;
                HashMap configs = new HashMap(producerFactory.getConfigurationProperties());
                configs.remove("value.serializer");
                configs.remove("key.serializer");
                DefaultJackson2JavaTypeMapper typeMapper = new DefaultJackson2JavaTypeMapper();
                typeMapper.setTypePrecedence(Jackson2JavaTypeMapper.TypePrecedence.TYPE_ID);
                typeMapper.addTrustedPackages(trustedPackages);
                typeMapper.setIdClassMapping(mappings);
                JsonSerializer valueSerializer = new JsonSerializer();
                valueSerializer.setTypeMapper((Jackson2JavaTypeMapper)typeMapper);
                logger.info("Configuring a DefaultKafkaProducerFactory with configs = [{}]", configs);
                logger.info("trustedPackages = [{}] mappings = [{}]", (Object)trustedPackages, mappings);
                result = new DefaultKafkaProducerFactory(configs, (Serializer)new StringSerializer(), (Serializer)valueSerializer);
            } else if (bean instanceof DefaultKafkaConsumerFactory) {
                DefaultKafkaConsumerFactory consumerFactory = (DefaultKafkaConsumerFactory)bean;
                HashMap configs = new HashMap(consumerFactory.getConfigurationProperties());
                configs.remove("value.deserializer");
                configs.remove("key.deserializer");
                DefaultJackson2JavaTypeMapper typeMapper = new DefaultJackson2JavaTypeMapper();
                typeMapper.setTypePrecedence(Jackson2JavaTypeMapper.TypePrecedence.TYPE_ID);
                typeMapper.addTrustedPackages(trustedPackages);
                typeMapper.setIdClassMapping(mappings);
                JsonDeserializer valueDeserializer = new JsonDeserializer();
                valueDeserializer.addTrustedPackages(trustedPackages);
                valueDeserializer.setTypeMapper((Jackson2JavaTypeMapper)typeMapper);
                logger.info("Configuring a DefaultKafkaConsumerFactory with configs = [{}]", configs);
                logger.info("trustedPackages = [{}] mappings = [{}]", (Object)trustedPackages, mappings);
                result = new DefaultKafkaConsumerFactory(configs, (Deserializer)new StringDeserializer(), (Deserializer)valueDeserializer);
            }
        }
        return result;
    }
}

