/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.boot.autoconfiguration.kafka;

import com.ibm.boot.autoconfiguration.kafka.AvroBeanPostProcessor;
import com.ibm.boot.autoconfiguration.kafka.AvroDeserializer;
import com.ibm.boot.autoconfiguration.kafka.AvroRecordMessageConverter;
import com.ibm.boot.autoconfiguration.kafka.AvroSerializer;
import com.ibm.boot.autoconfiguration.kafka.IBMKafkaProperties;
import java.util.Map;
import org.apache.kafka.common.serialization.Deserializer;
import org.apache.kafka.common.serialization.Serializer;
import org.apache.kafka.common.serialization.StringDeserializer;
import org.apache.kafka.common.serialization.StringSerializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.kafka.KafkaProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.kafka.core.ConsumerFactory;
import org.springframework.kafka.core.DefaultKafkaConsumerFactory;
import org.springframework.kafka.core.DefaultKafkaProducerFactory;
import org.springframework.kafka.core.KafkaOperations;
import org.springframework.kafka.core.KafkaTemplate;
import org.springframework.kafka.core.ProducerFactory;
import org.springframework.kafka.support.LoggingProducerListener;
import org.springframework.kafka.support.ProducerListener;
import org.springframework.kafka.support.converter.RecordMessageConverter;

@Configuration
@Import(value={AvroBeanPostProcessor.class})
@EnableConfigurationProperties(value={IBMKafkaProperties.class, KafkaProperties.class})
public class AvroStreamsAutoConfiguration {
    private static final Logger logger = LoggerFactory.getLogger(AvroStreamsAutoConfiguration.class);
    private final KafkaProperties kafkaProperties;

    public AvroStreamsAutoConfiguration(KafkaProperties kafkaProperties) {
        this.kafkaProperties = kafkaProperties;
    }

    @Bean
    public AvroRecordMessageConverter avroRecordMessageConverter() {
        return new AvroRecordMessageConverter();
    }

    @Bean
    public ProducerListener<Object, Object> kafkaProducerListener() {
        return new LoggingProducerListener();
    }

    @Bean
    @ConditionalOnMissingBean(value={KafkaOperations.class})
    public KafkaTemplate<?, ?> kafkaTemplate(ProducerFactory<Object, Object> kafkaProducerFactory, ProducerListener<Object, Object> kafkaProducerListener, AvroRecordMessageConverter avroRecordMessageConverter) {
        KafkaTemplate kafkaTemplate = new KafkaTemplate(kafkaProducerFactory);
        kafkaTemplate.setMessageConverter((RecordMessageConverter)avroRecordMessageConverter);
        kafkaTemplate.setProducerListener(kafkaProducerListener);
        kafkaTemplate.setDefaultTopic(this.kafkaProperties.getTemplate().getDefaultTopic());
        return kafkaTemplate;
    }

    @Bean
    @ConditionalOnMissingBean(value={ConsumerFactory.class})
    public DefaultKafkaConsumerFactory<Object, Object> kafkaConsumerFactory() {
        Map consumerProperties = this.kafkaProperties.buildConsumerProperties();
        StringDeserializer keyDeserializer = new StringDeserializer();
        AvroDeserializer valueDerializer = new AvroDeserializer();
        DefaultKafkaConsumerFactory defaultKafkaConsumerFactory = new DefaultKafkaConsumerFactory(consumerProperties, (Deserializer)keyDeserializer, valueDerializer);
        return defaultKafkaConsumerFactory;
    }

    @Bean
    @ConditionalOnMissingBean(value={ProducerFactory.class})
    public DefaultKafkaProducerFactory<Object, Object> kafkaProducerFactory() {
        Map producerProperties = this.kafkaProperties.buildProducerProperties();
        StringSerializer keySerializer = new StringSerializer();
        AvroSerializer valueSerializer = new AvroSerializer();
        DefaultKafkaProducerFactory defaultKafkaProducerFactory = new DefaultKafkaProducerFactory(producerProperties, (Serializer)keySerializer, valueSerializer);
        return defaultKafkaProducerFactory;
    }
}

