/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.boot.autoconfiguration.kafka;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericDatumWriter;
import org.apache.avro.io.BinaryEncoder;
import org.apache.avro.io.Encoder;
import org.apache.avro.io.EncoderFactory;
import org.apache.avro.specific.SpecificRecordBase;
import org.apache.kafka.common.errors.SerializationException;
import org.apache.kafka.common.header.Headers;
import org.apache.kafka.common.serialization.Serializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AvroSerializer<T extends SpecificRecordBase>
implements Serializer<T> {
    private static final Logger logger = LoggerFactory.getLogger(AvroSerializer.class);
    private final Map<Schema, GenericDatumWriter> map = new HashMap<Schema, GenericDatumWriter>();

    public byte[] serialize(String topic, T data) {
        return this.serialize(topic, (Headers)null, data);
    }

    public byte[] serialize(String topic, Headers headers, T data) {
        if (data == null) {
            return null;
        }
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            BinaryEncoder binaryEncoder = EncoderFactory.get().binaryEncoder((OutputStream)byteArrayOutputStream, null);
            GenericDatumWriter datumWriter = this.map.computeIfAbsent(data.getSchema(), schema -> new GenericDatumWriter(schema));
            datumWriter.write(data, (Encoder)binaryEncoder);
            binaryEncoder.flush();
            byteArrayOutputStream.close();
            return byteArrayOutputStream.toByteArray();
        }
        catch (IOException e) {
            logger.error("Can't serialize data='" + data + "' for topic='" + topic, (Throwable)e);
            throw new SerializationException("Can't serialize data='" + data + "' for topic='" + topic);
        }
    }

    public void configure(Map<String, ?> configs, boolean isKey) {
    }

    public void close() {
    }
}

