/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.boot.autoconfiguration.kafka;

import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.common.header.Headers;
import org.apache.kafka.common.header.internals.RecordHeaders;
import org.springframework.kafka.support.Acknowledgment;
import org.springframework.kafka.support.SimpleKafkaHeaderMapper;
import org.springframework.kafka.support.converter.RecordMessageConverter;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageHeaders;
import org.springframework.messaging.support.MessageBuilder;
import org.springframework.util.Assert;

public class AvroRecordMessageConverter
implements RecordMessageConverter {
    private final SimpleKafkaHeaderMapper simpleKafkaHeaderMapper = new SimpleKafkaHeaderMapper();

    public Message<?> toMessage(ConsumerRecord<?, ?> record, Acknowledgment acknowledgment, Consumer<?, ?> consumer, Type payloadType) {
        MessageHeaders messageHeaders = new MessageHeaders(null);
        HashMap<String, String> rawHeaders = new HashMap<String, String>();
        rawHeaders.put("avro-classname", payloadType.getTypeName());
        String ttName = record.timestampType() != null ? record.timestampType().name() : null;
        this.commonHeaders(acknowledgment, consumer, rawHeaders, record.key(), record.topic(), record.partition(), record.offset(), ttName, record.timestamp());
        return MessageBuilder.withPayload((Object)record.value()).build();
    }

    public ProducerRecord fromMessage(Message<?> message, String defaultTopic) {
        MessageHeaders headers = message.getHeaders();
        Object topicHeader = headers.get((Object)"kafka_topic");
        String topic = defaultTopic;
        if (topicHeader instanceof byte[]) {
            topic = new String((byte[])topicHeader, StandardCharsets.UTF_8);
        } else if (topicHeader instanceof String) {
            topic = (String)topicHeader;
        } else if (topicHeader == null) {
            Assert.state((defaultTopic != null ? 1 : 0) != 0, (String)"With no topic header, a defaultTopic is required");
        } else {
            throw new IllegalStateException("kafka_topic must be a String or byte[], not " + topicHeader.getClass());
        }
        Integer partition = (Integer)headers.get((Object)"kafka_partitionId", Integer.class);
        Object key = headers.get((Object)"kafka_messageKey");
        Object payload = message.getPayload();
        Long timestamp = (Long)headers.get((Object)"kafka_timestamp", Long.class);
        RecordHeaders recordHeaders = new RecordHeaders();
        this.simpleKafkaHeaderMapper.fromHeaders(headers, (Headers)recordHeaders);
        return new ProducerRecord(topic, partition, timestamp, key, payload, (Iterable)recordHeaders);
    }
}

