/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.boot.autoconfiguration.kafka;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.avro.Schema;
import org.apache.avro.io.BinaryDecoder;
import org.apache.avro.io.Decoder;
import org.apache.avro.io.DecoderFactory;
import org.apache.avro.specific.SpecificDatumReader;
import org.apache.avro.specific.SpecificRecordBase;
import org.apache.kafka.common.errors.SerializationException;
import org.apache.kafka.common.header.Header;
import org.apache.kafka.common.header.Headers;
import org.apache.kafka.common.serialization.Deserializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.kafka.support.serializer.DeserializationException;

public class AvroDeserializer<T extends SpecificRecordBase>
implements Deserializer<T> {
    private static final Logger logger = LoggerFactory.getLogger(AvroDeserializer.class);
    private final List<Schema> schemas = new ArrayList<Schema>();

    public void configure(Map<String, ?> configs, boolean isKey) {
        List classes = (List)configs.get("classes");
        List stuff = classes.stream().map(recordBaseClass -> {
            try {
                return ((SpecificRecordBase)recordBaseClass.newInstance()).getSchema();
            }
            catch (Exception e) {
                throw new DeserializationException("Test", null, false, (Throwable)e);
            }
        }).collect(Collectors.toList());
        this.schemas.addAll(stuff);
    }

    public T deserialize(String topic, byte[] data) {
        Optional<SpecificRecordBase> optional = this.schemas.parallelStream().map(schema -> new SpecificDatumReader(schema)).map(specificDatumReader -> {
            try {
                BinaryDecoder decoder = DecoderFactory.get().binaryDecoder(data, null);
                return (SpecificRecordBase)specificDatumReader.read(null, (Decoder)decoder);
            }
            catch (Exception e) {
                logger.error("Can't deserialize for topic='" + topic, (Throwable)e);
                throw new DeserializationException("Can't deserialize for topic='" + topic, data, false, (Throwable)e);
            }
        }).filter(o -> o != null).findFirst();
        if (optional.isPresent()) {
            return (T)optional.get();
        }
        return null;
    }

    public T deserialize(String topic, Headers headers, byte[] data) {
        if (data == null) {
            return null;
        }
        Header header = (Header)headers.headers("avro-classname").iterator().next();
        SpecificDatumReader specificDatumReader = new SpecificDatumReader();
        if (specificDatumReader == null) {
            return null;
        }
        BinaryDecoder decoder = DecoderFactory.get().binaryDecoder(data, null);
        try {
            return (T)((SpecificRecordBase)specificDatumReader.read(null, (Decoder)decoder));
        }
        catch (IOException ex) {
            throw new SerializationException("Can't deserialize data '" + Arrays.toString(data) + "' from topic '" + topic + "'", (Throwable)ex);
        }
    }

    public void close() {
    }
}

