/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.boot.autoconfiguration.kafka;

import com.ibm.boot.autoconfiguration.kafka.AvroDeserializer;
import com.ibm.boot.autoconfiguration.kafka.AvroSerializer;
import java.util.HashMap;
import org.apache.kafka.common.serialization.StringSerializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.kafka.core.DefaultKafkaConsumerFactory;
import org.springframework.kafka.core.DefaultKafkaProducerFactory;

public class AvroBeanPostProcessor
implements BeanPostProcessor {
    private static final Logger logger = LoggerFactory.getLogger(AvroBeanPostProcessor.class);

    public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
        return bean;
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        if (bean instanceof DefaultKafkaProducerFactory) {
            logger.info("we have a DefaultKafkaProducerFactory");
            DefaultKafkaProducerFactory producerFactory = (DefaultKafkaProducerFactory)bean;
            HashMap<String, Class> configs = new HashMap<String, Class>(producerFactory.getConfigurationProperties());
            configs.put("value.serializer", AvroSerializer.class);
            configs.put("key.serializer", StringSerializer.class);
            return new DefaultKafkaProducerFactory(configs);
        }
        if (bean instanceof DefaultKafkaConsumerFactory) {
            logger.info("we have DefaultKafkaConsumerFactory");
            DefaultKafkaConsumerFactory producerFactory = (DefaultKafkaConsumerFactory)bean;
            HashMap<String, Class> configs = new HashMap<String, Class>(producerFactory.getConfigurationProperties());
            configs.put("value.serializer", AvroDeserializer.class);
            configs.put("key.serializer", StringSerializer.class);
            return new DefaultKafkaConsumerFactory(configs);
        }
        return bean;
    }
}

