/*
 * (C) Copyright IBM Corp. 2020.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License is distributed on
 * an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the License for the
 * specific language governing permissions and limitations under the License.
 */
package com.ibm.cloud.ibm_key_protect_api.v2.model;

import java.util.List;

import com.ibm.cloud.sdk.core.service.model.GenericModel;

/**
 * SetKeyPoliciesOneOf.
 *
 * Classes which extend this class:
 * - SetKeyPoliciesOneOfSetKeyPolicyDualAuthDelete
 * - SetKeyPoliciesOneOfSetKeyPolicyRotation
 * - SetKeyPoliciesOneOfSetMultipleKeyPolicies
 */
public class SetKeyPoliciesOneOf<T> extends GenericModel {

  protected CollectionMetadata metadata;
  protected List<T> resources;

  protected SetKeyPoliciesOneOf() {
  }

  /**
   * Gets the metadata.
   *
   * The metadata that describes the resource array.
   *
   * @return the metadata
   */
  public CollectionMetadata metadata() {
    return metadata;
  }

  /**
   * Gets the resources.
   *
   * A collection of resources.
   *
   * @return the resources
   */
  public List<T> resources() {
    return resources;
  }
}

