/*
 * (C) Copyright IBM Corp. 2020.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License is distributed on
 * an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the License for the
 * specific language governing permissions and limitations under the License.
 */
package com.ibm.cloud.ibm_key_protect_api.v2.model;

import java.util.Date;

import com.ibm.cloud.sdk.core.service.model.GenericModel;

/**
 * Properties associated with a specific key version.
 */
public class KeyVersion extends GenericModel {

  protected String id;
  protected Date creationDate;

  /**
   * Gets the id.
   *
   * The ID of the key version.
   *
   * @return the id
   */
  public String getId() {
    return id;
  }

  /**
   * Gets the creationDate.
   *
   * The date that the version of the key was created.
   *
   * @return the creationDate
   */
  public Date getCreationDate() {
    return creationDate;
  }
}

