/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cloud.sdk.core.util;

import com.ibm.cloud.sdk.core.http.HttpMediaType;
import com.ibm.cloud.sdk.core.http.InputStreamRequestBody;
import java.io.File;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import okhttp3.MediaType;
import okhttp3.RequestBody;

public final class RequestUtils {
    private static final Logger LOG = Logger.getLogger(RequestUtils.class.getName());
    private static final String[] properties = new String[]{"java.vendor", "java.version", "os.arch", "os.name", "os.version"};
    private static final String VERSION_PROPS_FILENAME = "sdk-core-version.properties";
    private static String userAgent;

    private RequestUtils() {
    }

    public static String encode(String content) {
        try {
            return URLEncoder.encode(content, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new AssertionError((Object)e);
        }
    }

    public static Map<String, Object> omit(Map<String, Object> params, String ... toOmit) {
        if (params == null) {
            return null;
        }
        HashMap<String, Object> ret = new HashMap<String, Object>(params);
        if (toOmit != null) {
            ret.keySet().removeAll(Arrays.asList(toOmit));
        }
        return ret;
    }

    public static Map<String, Object> pick(Map<String, Object> params, String ... toPick) {
        if (params == null) {
            return null;
        }
        HashMap<String, Object> ret = new HashMap<String, Object>(params);
        if (toPick != null && toPick.length > 0) {
            ret.keySet().retainAll(Arrays.asList(toPick));
        }
        return ret;
    }

    public static <T> String join(T[] array, String separator) {
        return RequestUtils.join(Arrays.asList(array), separator);
    }

    public static String join(Iterable<?> iterable, String separator) {
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (Object item : iterable) {
            if (first) {
                first = false;
            } else {
                sb.append(separator);
            }
            sb.append(item.toString());
        }
        return sb.toString();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String loadCoreVersion() {
        try (InputStream is = RequestUtils.class.getClassLoader().getResourceAsStream(VERSION_PROPS_FILENAME);){
            Properties properties = new Properties();
            properties.load(is);
            String string = properties.getProperty("version", "unknown-version");
            return string;
        }
        catch (Exception e) {
            LOG.log(Level.WARNING, "Could not load file: sdk-core-version.properties", e);
            return "unknown-version";
        }
    }

    private static String buildUserAgent() {
        ArrayList<String> details = new ArrayList<String>();
        for (String propertyName : properties) {
            details.add(propertyName + "=" + System.getProperty(propertyName));
        }
        return "ibm-java-sdk-core-" + RequestUtils.loadCoreVersion() + " " + RequestUtils.getSystemInfo();
    }

    public static String getSystemInfo() {
        ArrayList<String> details = new ArrayList<String>();
        for (String propertyName : properties) {
            details.add(propertyName + "=" + System.getProperty(propertyName));
        }
        return "(" + RequestUtils.join(details, "; ") + ")";
    }

    public static synchronized String getUserAgent() {
        if (userAgent == null) {
            userAgent = RequestUtils.buildUserAgent();
        }
        return userAgent;
    }

    public static RequestBody fileBody(File file, String contentType) {
        MediaType mediaType = contentType != null ? MediaType.parse(contentType) : HttpMediaType.BINARY_FILE;
        return RequestBody.create(mediaType, file);
    }

    public static RequestBody inputStreamBody(InputStream stream, String contentType) {
        MediaType mediaType = contentType != null ? MediaType.parse(contentType) : HttpMediaType.BINARY_FILE;
        return InputStreamRequestBody.create(mediaType, stream);
    }
}

