/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cloud.sdk.core.security;

import com.ibm.cloud.sdk.core.http.RequestBuilder;
import com.ibm.cloud.sdk.core.security.Authenticator;
import com.ibm.cloud.sdk.core.security.IamToken;
import com.ibm.cloud.sdk.core.security.TokenRequestBasedAuthenticator;
import org.apache.commons.lang3.StringUtils;

public abstract class IamRequestBasedAuthenticator
extends TokenRequestBasedAuthenticator<IamToken, IamToken>
implements Authenticator {
    private static final String DEFAULT_IAM_URL = "https://iam.cloud.ibm.com";
    private String url;
    private String scope;
    private String clientId;
    private String clientSecret;
    protected String cachedAuthorizationHeader = null;

    @Override
    public void validate() {
        if (!StringUtils.isEmpty(this.getClientId()) || !StringUtils.isEmpty(this.getClientSecret())) {
            if (StringUtils.isEmpty(this.getClientId())) {
                throw new IllegalArgumentException(String.format("The %s property is required but was not specified.", "clientId"));
            }
            if (StringUtils.isEmpty(this.getClientSecret())) {
                throw new IllegalArgumentException(String.format("The %s property is required but was not specified.", "clientSecret"));
            }
        }
        this.cachedAuthorizationHeader = IamRequestBasedAuthenticator.constructBasicAuthHeader(this.clientId, this.clientSecret);
    }

    public String getURL() {
        return this.url;
    }

    public void setURL(String url) {
        if (StringUtils.isEmpty(url)) {
            url = DEFAULT_IAM_URL;
        }
        this.url = url;
    }

    public String getClientId() {
        return this.clientId;
    }

    public String getClientSecret() {
        return this.clientSecret;
    }

    public void setClientIdAndSecret(String clientId, String clientSecret) {
        this.clientId = clientId;
        this.clientSecret = clientSecret;
        this.validate();
    }

    public String getScope() {
        return this.scope;
    }

    public void setScope(String value) {
        this.scope = value;
    }

    protected void addAuthorizationHeader(RequestBuilder builder) {
        if (StringUtils.isNotEmpty(this.cachedAuthorizationHeader)) {
            builder.header("Authorization", this.cachedAuthorizationHeader);
        }
    }
}

