/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cloud.iaesdk.ibm_analytics_engine_api.v3.model;

import com.ibm.cloud.sdk.core.service.model.GenericModel;
import com.ibm.cloud.sdk.core.util.Validator;
import java.util.ArrayList;
import java.util.List;

public class ReplaceLogForwardingConfigOptions
extends GenericModel {
    protected String instanceId;
    protected Boolean enabled;
    protected List<String> sources;
    protected List<String> tags;

    protected ReplaceLogForwardingConfigOptions() {
    }

    protected ReplaceLogForwardingConfigOptions(Builder builder) {
        Validator.notEmpty(builder.instanceId, "instanceId cannot be empty");
        this.instanceId = builder.instanceId;
        this.enabled = builder.enabled;
        this.sources = builder.sources;
        this.tags = builder.tags;
    }

    public Builder newBuilder() {
        return new Builder(this);
    }

    public String instanceId() {
        return this.instanceId;
    }

    public Boolean enabled() {
        return this.enabled;
    }

    public List<String> sources() {
        return this.sources;
    }

    public List<String> tags() {
        return this.tags;
    }

    public static class Builder {
        private String instanceId;
        private Boolean enabled;
        private List<String> sources;
        private List<String> tags;

        private Builder(ReplaceLogForwardingConfigOptions replaceLogForwardingConfigOptions) {
            this.instanceId = replaceLogForwardingConfigOptions.instanceId;
            this.enabled = replaceLogForwardingConfigOptions.enabled;
            this.sources = replaceLogForwardingConfigOptions.sources;
            this.tags = replaceLogForwardingConfigOptions.tags;
        }

        public Builder() {
        }

        public Builder(String instanceId) {
            this.instanceId = instanceId;
        }

        public ReplaceLogForwardingConfigOptions build() {
            return new ReplaceLogForwardingConfigOptions(this);
        }

        public Builder addSources(String sources) {
            Validator.notNull(sources, "sources cannot be null");
            if (this.sources == null) {
                this.sources = new ArrayList<String>();
            }
            this.sources.add(sources);
            return this;
        }

        public Builder addTags(String tags) {
            Validator.notNull(tags, "tags cannot be null");
            if (this.tags == null) {
                this.tags = new ArrayList<String>();
            }
            this.tags.add(tags);
            return this;
        }

        public Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public Builder enabled(Boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        public Builder sources(List<String> sources) {
            this.sources = sources;
            return this;
        }

        public Builder tags(List<String> tags) {
            this.tags = tags;
            return this;
        }
    }
}

