/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cloud.iaesdk.ibm_analytics_engine_api.v3.model;

import com.ibm.cloud.sdk.core.service.model.GenericModel;
import com.ibm.cloud.sdk.core.util.Validator;
import java.util.ArrayList;
import java.util.List;

public class ListApplicationsOptions
extends GenericModel {
    protected String instanceId;
    protected List<String> state;

    protected ListApplicationsOptions() {
    }

    protected ListApplicationsOptions(Builder builder) {
        Validator.notEmpty(builder.instanceId, "instanceId cannot be empty");
        this.instanceId = builder.instanceId;
        this.state = builder.state;
    }

    public Builder newBuilder() {
        return new Builder(this);
    }

    public String instanceId() {
        return this.instanceId;
    }

    public List<String> state() {
        return this.state;
    }

    public static class Builder {
        private String instanceId;
        private List<String> state;

        private Builder(ListApplicationsOptions listApplicationsOptions) {
            this.instanceId = listApplicationsOptions.instanceId;
            this.state = listApplicationsOptions.state;
        }

        public Builder() {
        }

        public Builder(String instanceId) {
            this.instanceId = instanceId;
        }

        public ListApplicationsOptions build() {
            return new ListApplicationsOptions(this);
        }

        public Builder addState(String state) {
            Validator.notNull(state, "state cannot be null");
            if (this.state == null) {
                this.state = new ArrayList<String>();
            }
            this.state.add(state);
            return this;
        }

        public Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public Builder state(List<String> state) {
            this.state = state;
            return this;
        }
    }

    public static interface State {
        public static final String FINISHED = "finished";
        public static final String RUNNING = "running";
        public static final String FAILED = "failed";
        public static final String ERROR = "error";
        public static final String ACCEPTED = "accepted";
        public static final String SUBMITTED = "submitted";
        public static final String WAITING = "waiting";
        public static final String UNKNOWN = "unknown";
        public static final String STOPPED = "stopped";
        public static final String AUTO_TERMINATED = "auto_terminated";
        public static final String OPS_TERMINATED = "ops_terminated";
    }
}

