/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cloud.iaesdk.ibm_analytics_engine_api.v3;

import com.ibm.cloud.iaesdk.ibm_analytics_engine_api.v3.IbmAnalyticsEngineApi;
import com.ibm.cloud.iaesdk.ibm_analytics_engine_api.v3.model.ApplicationCollection;
import com.ibm.cloud.iaesdk.ibm_analytics_engine_api.v3.model.ApplicationGetResponse;
import com.ibm.cloud.iaesdk.ibm_analytics_engine_api.v3.model.ApplicationGetStateResponse;
import com.ibm.cloud.iaesdk.ibm_analytics_engine_api.v3.model.ApplicationRequestApplicationDetails;
import com.ibm.cloud.iaesdk.ibm_analytics_engine_api.v3.model.ApplicationResponse;
import com.ibm.cloud.iaesdk.ibm_analytics_engine_api.v3.model.ConfigurePlatformLoggingOptions;
import com.ibm.cloud.iaesdk.ibm_analytics_engine_api.v3.model.CreateApplicationOptions;
import com.ibm.cloud.iaesdk.ibm_analytics_engine_api.v3.model.CurrentResourceConsumptionResponse;
import com.ibm.cloud.iaesdk.ibm_analytics_engine_api.v3.model.DeleteApplicationOptions;
import com.ibm.cloud.iaesdk.ibm_analytics_engine_api.v3.model.GetApplicationOptions;
import com.ibm.cloud.iaesdk.ibm_analytics_engine_api.v3.model.GetApplicationStateOptions;
import com.ibm.cloud.iaesdk.ibm_analytics_engine_api.v3.model.GetCurrentResourceConsumptionOptions;
import com.ibm.cloud.iaesdk.ibm_analytics_engine_api.v3.model.GetInstanceDefaultConfigsOptions;
import com.ibm.cloud.iaesdk.ibm_analytics_engine_api.v3.model.GetInstanceDefaultRuntimeOptions;
import com.ibm.cloud.iaesdk.ibm_analytics_engine_api.v3.model.GetInstanceOptions;
import com.ibm.cloud.iaesdk.ibm_analytics_engine_api.v3.model.GetInstanceStateOptions;
import com.ibm.cloud.iaesdk.ibm_analytics_engine_api.v3.model.GetLogForwardingConfigOptions;
import com.ibm.cloud.iaesdk.ibm_analytics_engine_api.v3.model.GetLoggingConfigurationOptions;
import com.ibm.cloud.iaesdk.ibm_analytics_engine_api.v3.model.GetResourceConsumptionLimitsOptions;
import com.ibm.cloud.iaesdk.ibm_analytics_engine_api.v3.model.Instance;
import com.ibm.cloud.iaesdk.ibm_analytics_engine_api.v3.model.InstanceGetStateResponse;
import com.ibm.cloud.iaesdk.ibm_analytics_engine_api.v3.model.InstanceHomeResponse;
import com.ibm.cloud.iaesdk.ibm_analytics_engine_api.v3.model.ListApplicationsOptions;
import com.ibm.cloud.iaesdk.ibm_analytics_engine_api.v3.model.LogForwardingConfigResponse;
import com.ibm.cloud.iaesdk.ibm_analytics_engine_api.v3.model.LoggingConfigurationResponse;
import com.ibm.cloud.iaesdk.ibm_analytics_engine_api.v3.model.ReplaceInstanceDefaultConfigsOptions;
import com.ibm.cloud.iaesdk.ibm_analytics_engine_api.v3.model.ReplaceInstanceDefaultRuntimeOptions;
import com.ibm.cloud.iaesdk.ibm_analytics_engine_api.v3.model.ReplaceLogForwardingConfigOptions;
import com.ibm.cloud.iaesdk.ibm_analytics_engine_api.v3.model.ResourceConsumptionLimitsResponse;
import com.ibm.cloud.iaesdk.ibm_analytics_engine_api.v3.model.Runtime;
import com.ibm.cloud.iaesdk.ibm_analytics_engine_api.v3.model.SetInstanceHomeOptions;
import com.ibm.cloud.iaesdk.ibm_analytics_engine_api.v3.model.UpdateInstanceDefaultConfigsOptions;
import com.ibm.cloud.sdk.core.http.Response;
import com.ibm.cloud.sdk.core.service.exception.ServiceResponseException;
import com.ibm.cloud.sdk.core.util.CredentialUtils;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IbmAnalyticsEngineApiExamples {
    private static final Logger logger = LoggerFactory.getLogger(IbmAnalyticsEngineApiExamples.class);

    protected IbmAnalyticsEngineApiExamples() {
    }

    public static void main(String[] args2) throws Exception {
        LoggingConfigurationResponse loggingConfigurationResponse;
        LogForwardingConfigResponse logForwardingConfigResponse;
        Runtime runtime;
        Map<String, String> instanceDefaultConfigs;
        Response<Object> response;
        Response<Object> response2;
        IbmAnalyticsEngineApi ibmAnalyticsEngineApiService = IbmAnalyticsEngineApi.newInstance();
        Map<String, String> testConfigProperties = CredentialUtils.getServiceProperties("ibm_analytics_engine_api");
        try {
            System.out.println("getInstance() result:");
            GetInstanceOptions getInstanceOptions = new GetInstanceOptions.Builder().instanceId("dc0e9889-eab2-4t9e-9441-566209499546").build();
            response2 = ibmAnalyticsEngineApiService.getInstance(getInstanceOptions).execute();
            Instance instance = response2.getResult();
            System.out.println(instance);
        }
        catch (ServiceResponseException e) {
            logger.error(String.format("Service returned status code %s: %s%nError details: %s", e.getStatusCode(), e.getMessage(), e.getDebuggingInfo()), e);
        }
        try {
            System.out.println("getInstanceState() result:");
            GetInstanceStateOptions getInstanceStateOptions = new GetInstanceStateOptions.Builder().instanceId("dc0e9889-eab2-4t9e-9441-566209499546").build();
            response2 = ibmAnalyticsEngineApiService.getInstanceState(getInstanceStateOptions).execute();
            InstanceGetStateResponse instanceGetStateResponse = (InstanceGetStateResponse)response2.getResult();
            System.out.println(instanceGetStateResponse);
        }
        catch (ServiceResponseException e) {
            logger.error(String.format("Service returned status code %s: %s%nError details: %s", e.getStatusCode(), e.getMessage(), e.getDebuggingInfo()), e);
        }
        try {
            System.out.println("setInstanceHome() result:");
            SetInstanceHomeOptions setInstanceHomeOptions = new SetInstanceHomeOptions.Builder().instanceId("dc0e9889-eab2-4t9e-9441-566209499546").newHmacAccessKey("b9****************************4b").newHmacSecretKey("fa********************************************8a").build();
            response2 = ibmAnalyticsEngineApiService.setInstanceHome(setInstanceHomeOptions).execute();
            InstanceHomeResponse instanceHomeResponse = (InstanceHomeResponse)response2.getResult();
            System.out.println(instanceHomeResponse);
        }
        catch (ServiceResponseException e) {
            logger.error(String.format("Service returned status code %s: %s%nError details: %s", e.getStatusCode(), e.getMessage(), e.getDebuggingInfo()), e);
        }
        try {
            System.out.println("getInstanceDefaultConfigs() result:");
            GetInstanceDefaultConfigsOptions getInstanceDefaultConfigsOptions = new GetInstanceDefaultConfigsOptions.Builder().instanceId("dc0e9889-eab2-4t9e-9441-566209499546").build();
            response2 = ibmAnalyticsEngineApiService.getInstanceDefaultConfigs(getInstanceDefaultConfigsOptions).execute();
            Map instanceDefaultConfigs2 = (Map)response2.getResult();
            System.out.println(instanceDefaultConfigs2);
        }
        catch (ServiceResponseException e) {
            logger.error(String.format("Service returned status code %s: %s%nError details: %s", e.getStatusCode(), e.getMessage(), e.getDebuggingInfo()), e);
        }
        try {
            System.out.println("replaceInstanceDefaultConfigs() result:");
            HashMap<String, String> newDefaultConfigs = new HashMap<String, String>();
            newDefaultConfigs.put("spark.driver.memory", "8G");
            newDefaultConfigs.put("spark.driver.cores", "2");
            ReplaceInstanceDefaultConfigsOptions replaceInstanceDefaultConfigsOptions = new ReplaceInstanceDefaultConfigsOptions.Builder().instanceId("dc0e9889-eab2-4t9e-9441-566209499546").body(newDefaultConfigs).build();
            response = ibmAnalyticsEngineApiService.replaceInstanceDefaultConfigs(replaceInstanceDefaultConfigsOptions).execute();
            instanceDefaultConfigs = response.getResult();
            System.out.println(instanceDefaultConfigs);
        }
        catch (ServiceResponseException e) {
            logger.error(String.format("Service returned status code %s: %s%nError details: %s", e.getStatusCode(), e.getMessage(), e.getDebuggingInfo()), e);
        }
        try {
            System.out.println("updateInstanceDefaultConfigs() result:");
            HashMap<String, Object> defaultConfigsUpdate = new HashMap<String, Object>();
            defaultConfigsUpdate.put("ae.spark.history-server.cores", "1");
            defaultConfigsUpdate.put("ae.spark.history-server.memory", "4G");
            UpdateInstanceDefaultConfigsOptions updateInstanceDefaultConfigsOptions = new UpdateInstanceDefaultConfigsOptions.Builder().instanceId("dc0e9889-eab2-4t9e-9441-566209499546").body(defaultConfigsUpdate).build();
            response = ibmAnalyticsEngineApiService.updateInstanceDefaultConfigs(updateInstanceDefaultConfigsOptions).execute();
            instanceDefaultConfigs = response.getResult();
            System.out.println(instanceDefaultConfigs);
        }
        catch (ServiceResponseException e) {
            logger.error(String.format("Service returned status code %s: %s%nError details: %s", e.getStatusCode(), e.getMessage(), e.getDebuggingInfo()), e);
        }
        try {
            System.out.println("getInstanceDefaultRuntime() result:");
            GetInstanceDefaultRuntimeOptions getInstanceDefaultRuntimeOptions = new GetInstanceDefaultRuntimeOptions.Builder().instanceId("dc0e9889-eab2-4t9e-9441-566209499546").build();
            response2 = ibmAnalyticsEngineApiService.getInstanceDefaultRuntime(getInstanceDefaultRuntimeOptions).execute();
            runtime = (Runtime)response2.getResult();
            System.out.println(runtime);
        }
        catch (ServiceResponseException e) {
            logger.error(String.format("Service returned status code %s: %s%nError details: %s", e.getStatusCode(), e.getMessage(), e.getDebuggingInfo()), e);
        }
        try {
            System.out.println("replaceInstanceDefaultRuntime() result:");
            ReplaceInstanceDefaultRuntimeOptions replaceInstanceDefaultRuntimeOptions = new ReplaceInstanceDefaultRuntimeOptions.Builder().instanceId("dc0e9889-eab2-4t9e-9441-566209499546").sparkVersion("3.3").build();
            response2 = ibmAnalyticsEngineApiService.replaceInstanceDefaultRuntime(replaceInstanceDefaultRuntimeOptions).execute();
            runtime = (Runtime)response2.getResult();
            System.out.println(runtime);
        }
        catch (ServiceResponseException e) {
            logger.error(String.format("Service returned status code %s: %s%nError details: %s", e.getStatusCode(), e.getMessage(), e.getDebuggingInfo()), e);
        }
        try {
            System.out.println("createApplication() result:");
            Runtime runtimeModel = new Runtime.Builder().sparkVersion("3.1").build();
            CreateApplicationOptions createApplicationOptions = new CreateApplicationOptions.Builder().instanceId("dc0e9889-eab2-4t9e-9441-566209499546").applicationDetails(new ApplicationRequestApplicationDetails.Builder().application("/opt/ibm/spark/examples/src/main/python/wordcount.py").addArguments("/opt/ibm/spark/examples/src/main/resources/people.txt").runtime(runtimeModel).build()).build();
            response = ibmAnalyticsEngineApiService.createApplication(createApplicationOptions).execute();
            ApplicationResponse applicationResponse = (ApplicationResponse)response.getResult();
            System.out.println(applicationResponse);
        }
        catch (ServiceResponseException e) {
            logger.error(String.format("Service returned status code %s: %s%nError details: %s", e.getStatusCode(), e.getMessage(), e.getDebuggingInfo()), e);
        }
        try {
            System.out.println("listApplications() result:");
            ListApplicationsOptions listApplicationsOptions = new ListApplicationsOptions.Builder().instanceId("dc0e9889-eab2-4t9e-9441-566209499546").addState("accepted").addState("submitted").addState("waiting").addState("running").addState("finished").addState("failed").build();
            response2 = ibmAnalyticsEngineApiService.listApplications(listApplicationsOptions).execute();
            ApplicationCollection applicationCollection = (ApplicationCollection)response2.getResult();
            System.out.println(applicationCollection);
        }
        catch (ServiceResponseException e) {
            logger.error(String.format("Service returned status code %s: %s%nError details: %s", e.getStatusCode(), e.getMessage(), e.getDebuggingInfo()), e);
        }
        try {
            System.out.println("getApplication() result:");
            GetApplicationOptions getApplicationOptions = new GetApplicationOptions.Builder().instanceId("dc0e9889-eab2-4t9e-9441-566209499546").applicationId("db933645-0b68-4dcb-80d8-7b71a6c8e542").build();
            response2 = ibmAnalyticsEngineApiService.getApplication(getApplicationOptions).execute();
            ApplicationGetResponse applicationGetResponse = (ApplicationGetResponse)response2.getResult();
            System.out.println(applicationGetResponse);
        }
        catch (ServiceResponseException e) {
            logger.error(String.format("Service returned status code %s: %s%nError details: %s", e.getStatusCode(), e.getMessage(), e.getDebuggingInfo()), e);
        }
        try {
            System.out.println("getApplicationState() result:");
            GetApplicationStateOptions getApplicationStateOptions = new GetApplicationStateOptions.Builder().instanceId("dc0e9889-eab2-4t9e-9441-566209499546").applicationId("db933645-0b68-4dcb-80d8-7b71a6c8e542").build();
            response2 = ibmAnalyticsEngineApiService.getApplicationState(getApplicationStateOptions).execute();
            ApplicationGetStateResponse applicationGetStateResponse = (ApplicationGetStateResponse)response2.getResult();
            System.out.println(applicationGetStateResponse);
        }
        catch (ServiceResponseException e) {
            logger.error(String.format("Service returned status code %s: %s%nError details: %s", e.getStatusCode(), e.getMessage(), e.getDebuggingInfo()), e);
        }
        try {
            System.out.println("getCurrentResourceConsumption() result:");
            GetCurrentResourceConsumptionOptions getCurrentResourceConsumptionOptions = new GetCurrentResourceConsumptionOptions.Builder().instanceId("dc0e9889-eab2-4t9e-9441-566209499546").build();
            response2 = ibmAnalyticsEngineApiService.getCurrentResourceConsumption(getCurrentResourceConsumptionOptions).execute();
            CurrentResourceConsumptionResponse currentResourceConsumptionResponse = (CurrentResourceConsumptionResponse)response2.getResult();
            System.out.println(currentResourceConsumptionResponse);
        }
        catch (ServiceResponseException e) {
            logger.error(String.format("Service returned status code %s: %s%nError details: %s", e.getStatusCode(), e.getMessage(), e.getDebuggingInfo()), e);
        }
        try {
            System.out.println("getResourceConsumptionLimits() result:");
            GetResourceConsumptionLimitsOptions getResourceConsumptionLimitsOptions = new GetResourceConsumptionLimitsOptions.Builder().instanceId("dc0e9889-eab2-4t9e-9441-566209499546").build();
            response2 = ibmAnalyticsEngineApiService.getResourceConsumptionLimits(getResourceConsumptionLimitsOptions).execute();
            ResourceConsumptionLimitsResponse resourceConsumptionLimitsResponse = (ResourceConsumptionLimitsResponse)response2.getResult();
            System.out.println(resourceConsumptionLimitsResponse);
        }
        catch (ServiceResponseException e) {
            logger.error(String.format("Service returned status code %s: %s%nError details: %s", e.getStatusCode(), e.getMessage(), e.getDebuggingInfo()), e);
        }
        try {
            System.out.println("replaceLogForwardingConfig() result:");
            ReplaceLogForwardingConfigOptions replaceLogForwardingConfigOptions = new ReplaceLogForwardingConfigOptions.Builder().instanceId("dc0e9889-eab2-4t9e-9441-566209499546").enabled(true).build();
            response2 = ibmAnalyticsEngineApiService.replaceLogForwardingConfig(replaceLogForwardingConfigOptions).execute();
            logForwardingConfigResponse = (LogForwardingConfigResponse)response2.getResult();
            System.out.println(logForwardingConfigResponse);
        }
        catch (ServiceResponseException e) {
            logger.error(String.format("Service returned status code %s: %s%nError details: %s", e.getStatusCode(), e.getMessage(), e.getDebuggingInfo()), e);
        }
        try {
            System.out.println("getLogForwardingConfig() result:");
            GetLogForwardingConfigOptions getLogForwardingConfigOptions = new GetLogForwardingConfigOptions.Builder().instanceId("dc0e9889-eab2-4t9e-9441-566209499546").build();
            response2 = ibmAnalyticsEngineApiService.getLogForwardingConfig(getLogForwardingConfigOptions).execute();
            logForwardingConfigResponse = (LogForwardingConfigResponse)response2.getResult();
            System.out.println(logForwardingConfigResponse);
        }
        catch (ServiceResponseException e) {
            logger.error(String.format("Service returned status code %s: %s%nError details: %s", e.getStatusCode(), e.getMessage(), e.getDebuggingInfo()), e);
        }
        try {
            System.out.println("configurePlatformLogging() result:");
            ConfigurePlatformLoggingOptions configurePlatformLoggingOptions = new ConfigurePlatformLoggingOptions.Builder().instanceGuid("dc0e9889-eab2-4t9e-9441-566209499546").enable(true).build();
            response2 = ibmAnalyticsEngineApiService.configurePlatformLogging(configurePlatformLoggingOptions).execute();
            loggingConfigurationResponse = (LoggingConfigurationResponse)response2.getResult();
            System.out.println(loggingConfigurationResponse);
        }
        catch (ServiceResponseException e) {
            logger.error(String.format("Service returned status code %s: %s%nError details: %s", e.getStatusCode(), e.getMessage(), e.getDebuggingInfo()), e);
        }
        try {
            System.out.println("getLoggingConfiguration() result:");
            GetLoggingConfigurationOptions getLoggingConfigurationOptions = new GetLoggingConfigurationOptions.Builder().instanceGuid("dc0e9889-eab2-4t9e-9441-566209499546").build();
            response2 = ibmAnalyticsEngineApiService.getLoggingConfiguration(getLoggingConfigurationOptions).execute();
            loggingConfigurationResponse = (LoggingConfigurationResponse)response2.getResult();
            System.out.println(loggingConfigurationResponse);
        }
        catch (ServiceResponseException e) {
            logger.error(String.format("Service returned status code %s: %s%nError details: %s", e.getStatusCode(), e.getMessage(), e.getDebuggingInfo()), e);
        }
        try {
            DeleteApplicationOptions deleteApplicationOptions = new DeleteApplicationOptions.Builder().instanceId("dc0e9889-eab2-4t9e-9441-566209499546").applicationId("db933645-0b68-4dcb-80d8-7b71a6c8e542").build();
            response2 = ibmAnalyticsEngineApiService.deleteApplication(deleteApplicationOptions).execute();
            System.out.printf("deleteApplication() response status code: %d%n", response2.getStatusCode());
        }
        catch (ServiceResponseException e) {
            logger.error(String.format("Service returned status code %s: %s%nError details: %s", e.getStatusCode(), e.getMessage(), e.getDebuggingInfo()), e);
        }
    }

    static {
        System.setProperty("IBM_CREDENTIALS_FILE", "../../ibm_analytics_engine_api_v3.env");
    }
}

