/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cloud.iaesdk.ibm_analytics_engine_api.v3;

import com.google.gson.JsonObject;
import com.google.gson.reflect.TypeToken;
import com.ibm.cloud.iaesdk.common.SdkCommon;
import com.ibm.cloud.iaesdk.ibm_analytics_engine_api.v3.model.ApplicationCollection;
import com.ibm.cloud.iaesdk.ibm_analytics_engine_api.v3.model.ApplicationGetResponse;
import com.ibm.cloud.iaesdk.ibm_analytics_engine_api.v3.model.ApplicationGetStateResponse;
import com.ibm.cloud.iaesdk.ibm_analytics_engine_api.v3.model.ApplicationResponse;
import com.ibm.cloud.iaesdk.ibm_analytics_engine_api.v3.model.ConfigurePlatformLoggingOptions;
import com.ibm.cloud.iaesdk.ibm_analytics_engine_api.v3.model.CreateApplicationOptions;
import com.ibm.cloud.iaesdk.ibm_analytics_engine_api.v3.model.CurrentResourceConsumptionResponse;
import com.ibm.cloud.iaesdk.ibm_analytics_engine_api.v3.model.DeleteApplicationOptions;
import com.ibm.cloud.iaesdk.ibm_analytics_engine_api.v3.model.GetApplicationOptions;
import com.ibm.cloud.iaesdk.ibm_analytics_engine_api.v3.model.GetApplicationStateOptions;
import com.ibm.cloud.iaesdk.ibm_analytics_engine_api.v3.model.GetCurrentResourceConsumptionOptions;
import com.ibm.cloud.iaesdk.ibm_analytics_engine_api.v3.model.GetInstanceDefaultConfigsOptions;
import com.ibm.cloud.iaesdk.ibm_analytics_engine_api.v3.model.GetInstanceDefaultRuntimeOptions;
import com.ibm.cloud.iaesdk.ibm_analytics_engine_api.v3.model.GetInstanceOptions;
import com.ibm.cloud.iaesdk.ibm_analytics_engine_api.v3.model.GetInstanceStateOptions;
import com.ibm.cloud.iaesdk.ibm_analytics_engine_api.v3.model.GetLogForwardingConfigOptions;
import com.ibm.cloud.iaesdk.ibm_analytics_engine_api.v3.model.GetLoggingConfigurationOptions;
import com.ibm.cloud.iaesdk.ibm_analytics_engine_api.v3.model.GetResourceConsumptionLimitsOptions;
import com.ibm.cloud.iaesdk.ibm_analytics_engine_api.v3.model.Instance;
import com.ibm.cloud.iaesdk.ibm_analytics_engine_api.v3.model.InstanceGetStateResponse;
import com.ibm.cloud.iaesdk.ibm_analytics_engine_api.v3.model.InstanceHomeResponse;
import com.ibm.cloud.iaesdk.ibm_analytics_engine_api.v3.model.ListApplicationsOptions;
import com.ibm.cloud.iaesdk.ibm_analytics_engine_api.v3.model.LogForwardingConfigResponse;
import com.ibm.cloud.iaesdk.ibm_analytics_engine_api.v3.model.LoggingConfigurationResponse;
import com.ibm.cloud.iaesdk.ibm_analytics_engine_api.v3.model.ReplaceInstanceDefaultConfigsOptions;
import com.ibm.cloud.iaesdk.ibm_analytics_engine_api.v3.model.ReplaceInstanceDefaultRuntimeOptions;
import com.ibm.cloud.iaesdk.ibm_analytics_engine_api.v3.model.ReplaceLogForwardingConfigOptions;
import com.ibm.cloud.iaesdk.ibm_analytics_engine_api.v3.model.ResourceConsumptionLimitsResponse;
import com.ibm.cloud.iaesdk.ibm_analytics_engine_api.v3.model.Runtime;
import com.ibm.cloud.iaesdk.ibm_analytics_engine_api.v3.model.SetInstanceHomeOptions;
import com.ibm.cloud.iaesdk.ibm_analytics_engine_api.v3.model.UpdateInstanceDefaultConfigsOptions;
import com.ibm.cloud.sdk.core.http.RequestBuilder;
import com.ibm.cloud.sdk.core.http.ResponseConverter;
import com.ibm.cloud.sdk.core.http.ServiceCall;
import com.ibm.cloud.sdk.core.security.Authenticator;
import com.ibm.cloud.sdk.core.security.ConfigBasedAuthenticatorFactory;
import com.ibm.cloud.sdk.core.service.BaseService;
import com.ibm.cloud.sdk.core.util.GsonSingleton;
import com.ibm.cloud.sdk.core.util.RequestUtils;
import com.ibm.cloud.sdk.core.util.ResponseConverterUtils;
import com.ibm.cloud.sdk.core.util.Validator;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class IbmAnalyticsEngineApi
extends BaseService {
    public static final String DEFAULT_SERVICE_NAME = "ibm_analytics_engine_api";
    public static final String DEFAULT_SERVICE_URL = "https://api.us-south.ae.cloud.ibm.com";
    private static final Map<String, String> _regionalEndpoints;

    public static String getServiceUrlForRegion(String region) {
        return _regionalEndpoints.get(region);
    }

    public static IbmAnalyticsEngineApi newInstance() {
        return IbmAnalyticsEngineApi.newInstance(DEFAULT_SERVICE_NAME);
    }

    public static IbmAnalyticsEngineApi newInstance(String serviceName) {
        Authenticator authenticator = ConfigBasedAuthenticatorFactory.getAuthenticator(serviceName);
        IbmAnalyticsEngineApi service = new IbmAnalyticsEngineApi(serviceName, authenticator);
        service.configureService(serviceName);
        return service;
    }

    public IbmAnalyticsEngineApi(String serviceName, Authenticator authenticator) {
        super(serviceName, authenticator);
        this.setServiceUrl(DEFAULT_SERVICE_URL);
    }

    public ServiceCall<Instance> getInstance(GetInstanceOptions getInstanceOptions) {
        Validator.notNull(getInstanceOptions, "getInstanceOptions cannot be null");
        HashMap<String, String> pathParamsMap = new HashMap<String, String>();
        pathParamsMap.put("instance_id", getInstanceOptions.instanceId());
        RequestBuilder builder = RequestBuilder.get(RequestBuilder.resolveRequestUrl(this.getServiceUrl(), "/v3/analytics_engines/{instance_id}", pathParamsMap));
        Map<String, String> sdkHeaders = SdkCommon.getSdkHeaders(DEFAULT_SERVICE_NAME, "v3", "getInstance");
        for (Map.Entry<String, String> header : sdkHeaders.entrySet()) {
            builder.header(header.getKey(), header.getValue());
        }
        builder.header("Accept", "application/json");
        ResponseConverter responseConverter = ResponseConverterUtils.getValue(new TypeToken<Instance>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<InstanceGetStateResponse> getInstanceState(GetInstanceStateOptions getInstanceStateOptions) {
        Validator.notNull(getInstanceStateOptions, "getInstanceStateOptions cannot be null");
        HashMap<String, String> pathParamsMap = new HashMap<String, String>();
        pathParamsMap.put("instance_id", getInstanceStateOptions.instanceId());
        RequestBuilder builder = RequestBuilder.get(RequestBuilder.resolveRequestUrl(this.getServiceUrl(), "/v3/analytics_engines/{instance_id}/state", pathParamsMap));
        Map<String, String> sdkHeaders = SdkCommon.getSdkHeaders(DEFAULT_SERVICE_NAME, "v3", "getInstanceState");
        for (Map.Entry<String, String> header : sdkHeaders.entrySet()) {
            builder.header(header.getKey(), header.getValue());
        }
        builder.header("Accept", "application/json");
        ResponseConverter responseConverter = ResponseConverterUtils.getValue(new TypeToken<InstanceGetStateResponse>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<InstanceHomeResponse> setInstanceHome(SetInstanceHomeOptions setInstanceHomeOptions) {
        Validator.notNull(setInstanceHomeOptions, "setInstanceHomeOptions cannot be null");
        HashMap<String, String> pathParamsMap = new HashMap<String, String>();
        pathParamsMap.put("instance_id", setInstanceHomeOptions.instanceId());
        RequestBuilder builder = RequestBuilder.put(RequestBuilder.resolveRequestUrl(this.getServiceUrl(), "/v3/analytics_engines/{instance_id}/instance_home", pathParamsMap));
        Map<String, String> sdkHeaders = SdkCommon.getSdkHeaders(DEFAULT_SERVICE_NAME, "v3", "setInstanceHome");
        for (Map.Entry<String, String> header : sdkHeaders.entrySet()) {
            builder.header(header.getKey(), header.getValue());
        }
        builder.header("Accept", "application/json");
        JsonObject contentJson = new JsonObject();
        if (setInstanceHomeOptions.newInstanceId() != null) {
            contentJson.addProperty("instance_id", setInstanceHomeOptions.newInstanceId());
        }
        if (setInstanceHomeOptions.newProvider() != null) {
            contentJson.addProperty("provider", setInstanceHomeOptions.newProvider());
        }
        if (setInstanceHomeOptions.newType() != null) {
            contentJson.addProperty("type", setInstanceHomeOptions.newType());
        }
        if (setInstanceHomeOptions.newRegion() != null) {
            contentJson.addProperty("region", setInstanceHomeOptions.newRegion());
        }
        if (setInstanceHomeOptions.newEndpoint() != null) {
            contentJson.addProperty("endpoint", setInstanceHomeOptions.newEndpoint());
        }
        if (setInstanceHomeOptions.newHmacAccessKey() != null) {
            contentJson.addProperty("hmac_access_key", setInstanceHomeOptions.newHmacAccessKey());
        }
        if (setInstanceHomeOptions.newHmacSecretKey() != null) {
            contentJson.addProperty("hmac_secret_key", setInstanceHomeOptions.newHmacSecretKey());
        }
        builder.bodyJson(contentJson);
        ResponseConverter responseConverter = ResponseConverterUtils.getValue(new TypeToken<InstanceHomeResponse>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<Map<String, String>> getInstanceDefaultConfigs(GetInstanceDefaultConfigsOptions getInstanceDefaultConfigsOptions) {
        Validator.notNull(getInstanceDefaultConfigsOptions, "getInstanceDefaultConfigsOptions cannot be null");
        HashMap<String, String> pathParamsMap = new HashMap<String, String>();
        pathParamsMap.put("instance_id", getInstanceDefaultConfigsOptions.instanceId());
        RequestBuilder builder = RequestBuilder.get(RequestBuilder.resolveRequestUrl(this.getServiceUrl(), "/v3/analytics_engines/{instance_id}/default_configs", pathParamsMap));
        Map<String, String> sdkHeaders = SdkCommon.getSdkHeaders(DEFAULT_SERVICE_NAME, "v3", "getInstanceDefaultConfigs");
        for (Map.Entry<String, String> header : sdkHeaders.entrySet()) {
            builder.header(header.getKey(), header.getValue());
        }
        builder.header("Accept", "application/json");
        ResponseConverter responseConverter = ResponseConverterUtils.getValue(new TypeToken<Map<String, String>>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<Map<String, String>> replaceInstanceDefaultConfigs(ReplaceInstanceDefaultConfigsOptions replaceInstanceDefaultConfigsOptions) {
        Validator.notNull(replaceInstanceDefaultConfigsOptions, "replaceInstanceDefaultConfigsOptions cannot be null");
        HashMap<String, String> pathParamsMap = new HashMap<String, String>();
        pathParamsMap.put("instance_id", replaceInstanceDefaultConfigsOptions.instanceId());
        RequestBuilder builder = RequestBuilder.put(RequestBuilder.resolveRequestUrl(this.getServiceUrl(), "/v3/analytics_engines/{instance_id}/default_configs", pathParamsMap));
        Map<String, String> sdkHeaders = SdkCommon.getSdkHeaders(DEFAULT_SERVICE_NAME, "v3", "replaceInstanceDefaultConfigs");
        for (Map.Entry<String, String> header : sdkHeaders.entrySet()) {
            builder.header(header.getKey(), header.getValue());
        }
        builder.header("Accept", "application/json");
        builder.bodyContent(GsonSingleton.getGsonWithoutPrettyPrinting().toJson(replaceInstanceDefaultConfigsOptions.body()), "application/json");
        ResponseConverter responseConverter = ResponseConverterUtils.getValue(new TypeToken<Map<String, String>>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<Map<String, String>> updateInstanceDefaultConfigs(UpdateInstanceDefaultConfigsOptions updateInstanceDefaultConfigsOptions) {
        Validator.notNull(updateInstanceDefaultConfigsOptions, "updateInstanceDefaultConfigsOptions cannot be null");
        HashMap<String, String> pathParamsMap = new HashMap<String, String>();
        pathParamsMap.put("instance_id", updateInstanceDefaultConfigsOptions.instanceId());
        RequestBuilder builder = RequestBuilder.patch(RequestBuilder.resolveRequestUrl(this.getServiceUrl(), "/v3/analytics_engines/{instance_id}/default_configs", pathParamsMap));
        Map<String, String> sdkHeaders = SdkCommon.getSdkHeaders(DEFAULT_SERVICE_NAME, "v3", "updateInstanceDefaultConfigs");
        for (Map.Entry<String, String> header : sdkHeaders.entrySet()) {
            builder.header(header.getKey(), header.getValue());
        }
        builder.header("Accept", "application/json");
        builder.bodyContent(GsonSingleton.getGsonWithoutPrettyPrinting().toJson(updateInstanceDefaultConfigsOptions.body()), "application/merge-patch+json");
        ResponseConverter responseConverter = ResponseConverterUtils.getValue(new TypeToken<Map<String, String>>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<Runtime> getInstanceDefaultRuntime(GetInstanceDefaultRuntimeOptions getInstanceDefaultRuntimeOptions) {
        Validator.notNull(getInstanceDefaultRuntimeOptions, "getInstanceDefaultRuntimeOptions cannot be null");
        HashMap<String, String> pathParamsMap = new HashMap<String, String>();
        pathParamsMap.put("instance_id", getInstanceDefaultRuntimeOptions.instanceId());
        RequestBuilder builder = RequestBuilder.get(RequestBuilder.resolveRequestUrl(this.getServiceUrl(), "/v3/analytics_engines/{instance_id}/default_runtime", pathParamsMap));
        Map<String, String> sdkHeaders = SdkCommon.getSdkHeaders(DEFAULT_SERVICE_NAME, "v3", "getInstanceDefaultRuntime");
        for (Map.Entry<String, String> header : sdkHeaders.entrySet()) {
            builder.header(header.getKey(), header.getValue());
        }
        builder.header("Accept", "application/json");
        ResponseConverter responseConverter = ResponseConverterUtils.getValue(new TypeToken<Runtime>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<Runtime> replaceInstanceDefaultRuntime(ReplaceInstanceDefaultRuntimeOptions replaceInstanceDefaultRuntimeOptions) {
        Validator.notNull(replaceInstanceDefaultRuntimeOptions, "replaceInstanceDefaultRuntimeOptions cannot be null");
        HashMap<String, String> pathParamsMap = new HashMap<String, String>();
        pathParamsMap.put("instance_id", replaceInstanceDefaultRuntimeOptions.instanceId());
        RequestBuilder builder = RequestBuilder.put(RequestBuilder.resolveRequestUrl(this.getServiceUrl(), "/v3/analytics_engines/{instance_id}/default_runtime", pathParamsMap));
        Map<String, String> sdkHeaders = SdkCommon.getSdkHeaders(DEFAULT_SERVICE_NAME, "v3", "replaceInstanceDefaultRuntime");
        for (Map.Entry<String, String> header : sdkHeaders.entrySet()) {
            builder.header(header.getKey(), header.getValue());
        }
        builder.header("Accept", "application/json");
        JsonObject contentJson = new JsonObject();
        if (replaceInstanceDefaultRuntimeOptions.sparkVersion() != null) {
            contentJson.addProperty("spark_version", replaceInstanceDefaultRuntimeOptions.sparkVersion());
        }
        builder.bodyJson(contentJson);
        ResponseConverter responseConverter = ResponseConverterUtils.getValue(new TypeToken<Runtime>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<ApplicationResponse> createApplication(CreateApplicationOptions createApplicationOptions) {
        Validator.notNull(createApplicationOptions, "createApplicationOptions cannot be null");
        HashMap<String, String> pathParamsMap = new HashMap<String, String>();
        pathParamsMap.put("instance_id", createApplicationOptions.instanceId());
        RequestBuilder builder = RequestBuilder.post(RequestBuilder.resolveRequestUrl(this.getServiceUrl(), "/v3/analytics_engines/{instance_id}/spark_applications", pathParamsMap));
        Map<String, String> sdkHeaders = SdkCommon.getSdkHeaders(DEFAULT_SERVICE_NAME, "v3", "createApplication");
        for (Map.Entry<String, String> header : sdkHeaders.entrySet()) {
            builder.header(header.getKey(), header.getValue());
        }
        builder.header("Accept", "application/json");
        JsonObject contentJson = new JsonObject();
        if (createApplicationOptions.applicationDetails() != null) {
            contentJson.add("application_details", GsonSingleton.getGson().toJsonTree(createApplicationOptions.applicationDetails()));
        }
        builder.bodyJson(contentJson);
        ResponseConverter responseConverter = ResponseConverterUtils.getValue(new TypeToken<ApplicationResponse>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<ApplicationCollection> listApplications(ListApplicationsOptions listApplicationsOptions) {
        Validator.notNull(listApplicationsOptions, "listApplicationsOptions cannot be null");
        HashMap<String, String> pathParamsMap = new HashMap<String, String>();
        pathParamsMap.put("instance_id", listApplicationsOptions.instanceId());
        RequestBuilder builder = RequestBuilder.get(RequestBuilder.resolveRequestUrl(this.getServiceUrl(), "/v3/analytics_engines/{instance_id}/spark_applications", pathParamsMap));
        Map<String, String> sdkHeaders = SdkCommon.getSdkHeaders(DEFAULT_SERVICE_NAME, "v3", "listApplications");
        for (Map.Entry<String, String> header : sdkHeaders.entrySet()) {
            builder.header(header.getKey(), header.getValue());
        }
        builder.header("Accept", "application/json");
        if (listApplicationsOptions.state() != null) {
            builder.query("state", RequestUtils.join(listApplicationsOptions.state(), ","));
        }
        ResponseConverter responseConverter = ResponseConverterUtils.getValue(new TypeToken<ApplicationCollection>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<ApplicationGetResponse> getApplication(GetApplicationOptions getApplicationOptions) {
        Validator.notNull(getApplicationOptions, "getApplicationOptions cannot be null");
        HashMap<String, String> pathParamsMap = new HashMap<String, String>();
        pathParamsMap.put("instance_id", getApplicationOptions.instanceId());
        pathParamsMap.put("application_id", getApplicationOptions.applicationId());
        RequestBuilder builder = RequestBuilder.get(RequestBuilder.resolveRequestUrl(this.getServiceUrl(), "/v3/analytics_engines/{instance_id}/spark_applications/{application_id}", pathParamsMap));
        Map<String, String> sdkHeaders = SdkCommon.getSdkHeaders(DEFAULT_SERVICE_NAME, "v3", "getApplication");
        for (Map.Entry<String, String> header : sdkHeaders.entrySet()) {
            builder.header(header.getKey(), header.getValue());
        }
        builder.header("Accept", "application/json");
        ResponseConverter responseConverter = ResponseConverterUtils.getValue(new TypeToken<ApplicationGetResponse>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<Void> deleteApplication(DeleteApplicationOptions deleteApplicationOptions) {
        Validator.notNull(deleteApplicationOptions, "deleteApplicationOptions cannot be null");
        HashMap<String, String> pathParamsMap = new HashMap<String, String>();
        pathParamsMap.put("instance_id", deleteApplicationOptions.instanceId());
        pathParamsMap.put("application_id", deleteApplicationOptions.applicationId());
        RequestBuilder builder = RequestBuilder.delete(RequestBuilder.resolveRequestUrl(this.getServiceUrl(), "/v3/analytics_engines/{instance_id}/spark_applications/{application_id}", pathParamsMap));
        Map<String, String> sdkHeaders = SdkCommon.getSdkHeaders(DEFAULT_SERVICE_NAME, "v3", "deleteApplication");
        for (Map.Entry<String, String> header : sdkHeaders.entrySet()) {
            builder.header(header.getKey(), header.getValue());
        }
        ResponseConverter<Void> responseConverter = ResponseConverterUtils.getVoid();
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<ApplicationGetStateResponse> getApplicationState(GetApplicationStateOptions getApplicationStateOptions) {
        Validator.notNull(getApplicationStateOptions, "getApplicationStateOptions cannot be null");
        HashMap<String, String> pathParamsMap = new HashMap<String, String>();
        pathParamsMap.put("instance_id", getApplicationStateOptions.instanceId());
        pathParamsMap.put("application_id", getApplicationStateOptions.applicationId());
        RequestBuilder builder = RequestBuilder.get(RequestBuilder.resolveRequestUrl(this.getServiceUrl(), "/v3/analytics_engines/{instance_id}/spark_applications/{application_id}/state", pathParamsMap));
        Map<String, String> sdkHeaders = SdkCommon.getSdkHeaders(DEFAULT_SERVICE_NAME, "v3", "getApplicationState");
        for (Map.Entry<String, String> header : sdkHeaders.entrySet()) {
            builder.header(header.getKey(), header.getValue());
        }
        builder.header("Accept", "application/json");
        ResponseConverter responseConverter = ResponseConverterUtils.getValue(new TypeToken<ApplicationGetStateResponse>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<CurrentResourceConsumptionResponse> getCurrentResourceConsumption(GetCurrentResourceConsumptionOptions getCurrentResourceConsumptionOptions) {
        Validator.notNull(getCurrentResourceConsumptionOptions, "getCurrentResourceConsumptionOptions cannot be null");
        HashMap<String, String> pathParamsMap = new HashMap<String, String>();
        pathParamsMap.put("instance_id", getCurrentResourceConsumptionOptions.instanceId());
        RequestBuilder builder = RequestBuilder.get(RequestBuilder.resolveRequestUrl(this.getServiceUrl(), "/v3/analytics_engines/{instance_id}/current_resource_consumption", pathParamsMap));
        Map<String, String> sdkHeaders = SdkCommon.getSdkHeaders(DEFAULT_SERVICE_NAME, "v3", "getCurrentResourceConsumption");
        for (Map.Entry<String, String> header : sdkHeaders.entrySet()) {
            builder.header(header.getKey(), header.getValue());
        }
        builder.header("Accept", "application/json");
        ResponseConverter responseConverter = ResponseConverterUtils.getValue(new TypeToken<CurrentResourceConsumptionResponse>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<ResourceConsumptionLimitsResponse> getResourceConsumptionLimits(GetResourceConsumptionLimitsOptions getResourceConsumptionLimitsOptions) {
        Validator.notNull(getResourceConsumptionLimitsOptions, "getResourceConsumptionLimitsOptions cannot be null");
        HashMap<String, String> pathParamsMap = new HashMap<String, String>();
        pathParamsMap.put("instance_id", getResourceConsumptionLimitsOptions.instanceId());
        RequestBuilder builder = RequestBuilder.get(RequestBuilder.resolveRequestUrl(this.getServiceUrl(), "/v3/analytics_engines/{instance_id}/resource_consumption_limits", pathParamsMap));
        Map<String, String> sdkHeaders = SdkCommon.getSdkHeaders(DEFAULT_SERVICE_NAME, "v3", "getResourceConsumptionLimits");
        for (Map.Entry<String, String> header : sdkHeaders.entrySet()) {
            builder.header(header.getKey(), header.getValue());
        }
        builder.header("Accept", "application/json");
        ResponseConverter responseConverter = ResponseConverterUtils.getValue(new TypeToken<ResourceConsumptionLimitsResponse>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<LogForwardingConfigResponse> replaceLogForwardingConfig(ReplaceLogForwardingConfigOptions replaceLogForwardingConfigOptions) {
        Validator.notNull(replaceLogForwardingConfigOptions, "replaceLogForwardingConfigOptions cannot be null");
        HashMap<String, String> pathParamsMap = new HashMap<String, String>();
        pathParamsMap.put("instance_id", replaceLogForwardingConfigOptions.instanceId());
        RequestBuilder builder = RequestBuilder.put(RequestBuilder.resolveRequestUrl(this.getServiceUrl(), "/v3/analytics_engines/{instance_id}/log_forwarding_config", pathParamsMap));
        Map<String, String> sdkHeaders = SdkCommon.getSdkHeaders(DEFAULT_SERVICE_NAME, "v3", "replaceLogForwardingConfig");
        for (Map.Entry<String, String> header : sdkHeaders.entrySet()) {
            builder.header(header.getKey(), header.getValue());
        }
        builder.header("Accept", "application/json");
        JsonObject contentJson = new JsonObject();
        if (replaceLogForwardingConfigOptions.enabled() != null) {
            contentJson.addProperty("enabled", replaceLogForwardingConfigOptions.enabled());
        }
        if (replaceLogForwardingConfigOptions.sources() != null) {
            contentJson.add("sources", GsonSingleton.getGson().toJsonTree(replaceLogForwardingConfigOptions.sources()));
        }
        if (replaceLogForwardingConfigOptions.tags() != null) {
            contentJson.add("tags", GsonSingleton.getGson().toJsonTree(replaceLogForwardingConfigOptions.tags()));
        }
        builder.bodyJson(contentJson);
        ResponseConverter responseConverter = ResponseConverterUtils.getValue(new TypeToken<LogForwardingConfigResponse>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<LogForwardingConfigResponse> getLogForwardingConfig(GetLogForwardingConfigOptions getLogForwardingConfigOptions) {
        Validator.notNull(getLogForwardingConfigOptions, "getLogForwardingConfigOptions cannot be null");
        HashMap<String, String> pathParamsMap = new HashMap<String, String>();
        pathParamsMap.put("instance_id", getLogForwardingConfigOptions.instanceId());
        RequestBuilder builder = RequestBuilder.get(RequestBuilder.resolveRequestUrl(this.getServiceUrl(), "/v3/analytics_engines/{instance_id}/log_forwarding_config", pathParamsMap));
        Map<String, String> sdkHeaders = SdkCommon.getSdkHeaders(DEFAULT_SERVICE_NAME, "v3", "getLogForwardingConfig");
        for (Map.Entry<String, String> header : sdkHeaders.entrySet()) {
            builder.header(header.getKey(), header.getValue());
        }
        builder.header("Accept", "application/json");
        ResponseConverter responseConverter = ResponseConverterUtils.getValue(new TypeToken<LogForwardingConfigResponse>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<LoggingConfigurationResponse> configurePlatformLogging(ConfigurePlatformLoggingOptions configurePlatformLoggingOptions) {
        Validator.notNull(configurePlatformLoggingOptions, "configurePlatformLoggingOptions cannot be null");
        HashMap<String, String> pathParamsMap = new HashMap<String, String>();
        pathParamsMap.put("instance_guid", configurePlatformLoggingOptions.instanceGuid());
        RequestBuilder builder = RequestBuilder.put(RequestBuilder.resolveRequestUrl(this.getServiceUrl(), "/v3/analytics_engines/{instance_guid}/logging", pathParamsMap));
        Map<String, String> sdkHeaders = SdkCommon.getSdkHeaders(DEFAULT_SERVICE_NAME, "v3", "configurePlatformLogging");
        for (Map.Entry<String, String> header : sdkHeaders.entrySet()) {
            builder.header(header.getKey(), header.getValue());
        }
        builder.header("Accept", "application/json");
        JsonObject contentJson = new JsonObject();
        if (configurePlatformLoggingOptions.enable() != null) {
            contentJson.addProperty("enable", configurePlatformLoggingOptions.enable());
        }
        builder.bodyJson(contentJson);
        ResponseConverter responseConverter = ResponseConverterUtils.getValue(new TypeToken<LoggingConfigurationResponse>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<LoggingConfigurationResponse> getLoggingConfiguration(GetLoggingConfigurationOptions getLoggingConfigurationOptions) {
        Validator.notNull(getLoggingConfigurationOptions, "getLoggingConfigurationOptions cannot be null");
        HashMap<String, String> pathParamsMap = new HashMap<String, String>();
        pathParamsMap.put("instance_guid", getLoggingConfigurationOptions.instanceGuid());
        RequestBuilder builder = RequestBuilder.get(RequestBuilder.resolveRequestUrl(this.getServiceUrl(), "/v3/analytics_engines/{instance_guid}/logging", pathParamsMap));
        Map<String, String> sdkHeaders = SdkCommon.getSdkHeaders(DEFAULT_SERVICE_NAME, "v3", "getLoggingConfiguration");
        for (Map.Entry<String, String> header : sdkHeaders.entrySet()) {
            builder.header(header.getKey(), header.getValue());
        }
        builder.header("Accept", "application/json");
        ResponseConverter responseConverter = ResponseConverterUtils.getValue(new TypeToken<LoggingConfigurationResponse>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    static {
        HashMap<String, String> m = new HashMap<String, String>();
        m.put("us-south", DEFAULT_SERVICE_URL);
        m.put("eu-de", "https://api.eu-de.ae.cloud.ibm.com");
        _regionalEndpoints = Collections.unmodifiableMap(m);
    }
}

