/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cloud.iaesdk.ibm_analytics_engine_api.v2.model;

import com.ibm.cloud.iaesdk.ibm_analytics_engine_api.v2.model.AnalyticsEngineCustomAction;
import com.ibm.cloud.sdk.core.service.model.GenericModel;
import com.ibm.cloud.sdk.core.util.Validator;
import java.util.ArrayList;
import java.util.List;

public class CreateCustomizationRequestOptions
extends GenericModel {
    protected String instanceGuid;
    protected String target;
    protected List<AnalyticsEngineCustomAction> customActions;

    protected CreateCustomizationRequestOptions(Builder builder) {
        Validator.notEmpty(builder.instanceGuid, "instanceGuid cannot be empty");
        Validator.notNull(builder.target, "target cannot be null");
        Validator.notNull(builder.customActions, "customActions cannot be null");
        this.instanceGuid = builder.instanceGuid;
        this.target = builder.target;
        this.customActions = builder.customActions;
    }

    public Builder newBuilder() {
        return new Builder(this);
    }

    public String instanceGuid() {
        return this.instanceGuid;
    }

    public String target() {
        return this.target;
    }

    public List<AnalyticsEngineCustomAction> customActions() {
        return this.customActions;
    }

    public static class Builder {
        private String instanceGuid;
        private String target;
        private List<AnalyticsEngineCustomAction> customActions;

        private Builder(CreateCustomizationRequestOptions createCustomizationRequestOptions) {
            this.instanceGuid = createCustomizationRequestOptions.instanceGuid;
            this.target = createCustomizationRequestOptions.target;
            this.customActions = createCustomizationRequestOptions.customActions;
        }

        public Builder() {
        }

        public Builder(String instanceGuid, String target, List<AnalyticsEngineCustomAction> customActions) {
            this.instanceGuid = instanceGuid;
            this.target = target;
            this.customActions = customActions;
        }

        public CreateCustomizationRequestOptions build() {
            return new CreateCustomizationRequestOptions(this);
        }

        public Builder addCustomActions(AnalyticsEngineCustomAction customActions) {
            Validator.notNull(customActions, "customActions cannot be null");
            if (this.customActions == null) {
                this.customActions = new ArrayList<AnalyticsEngineCustomAction>();
            }
            this.customActions.add(customActions);
            return this;
        }

        public Builder instanceGuid(String instanceGuid) {
            this.instanceGuid = instanceGuid;
            return this;
        }

        public Builder target(String target) {
            this.target = target;
            return this;
        }

        public Builder customActions(List<AnalyticsEngineCustomAction> customActions) {
            this.customActions = customActions;
            return this;
        }
    }

    public static interface Target {
        public static final String ALL = "all";
        public static final String MASTER_MANAGEMENT = "master-management";
        public static final String DATA = "data";
        public static final String TASK = "task";
    }
}

