/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cloud.iaesdk.ibm_analytics_engine_api.v2.model;

import com.ibm.cloud.iaesdk.ibm_analytics_engine_api.v2.model.AnalyticsEngineLoggingNodeSpec;
import com.ibm.cloud.iaesdk.ibm_analytics_engine_api.v2.model.AnalyticsEngineLoggingServer;
import com.ibm.cloud.sdk.core.service.model.GenericModel;
import com.ibm.cloud.sdk.core.util.Validator;
import java.util.ArrayList;
import java.util.List;

public class ConfigureLoggingOptions
extends GenericModel {
    protected String instanceGuid;
    protected List<AnalyticsEngineLoggingNodeSpec> logSpecs;
    protected AnalyticsEngineLoggingServer logServer;

    protected ConfigureLoggingOptions(Builder builder) {
        Validator.notEmpty(builder.instanceGuid, "instanceGuid cannot be empty");
        Validator.notNull(builder.logSpecs, "logSpecs cannot be null");
        Validator.notNull(builder.logServer, "logServer cannot be null");
        this.instanceGuid = builder.instanceGuid;
        this.logSpecs = builder.logSpecs;
        this.logServer = builder.logServer;
    }

    public Builder newBuilder() {
        return new Builder(this);
    }

    public String instanceGuid() {
        return this.instanceGuid;
    }

    public List<AnalyticsEngineLoggingNodeSpec> logSpecs() {
        return this.logSpecs;
    }

    public AnalyticsEngineLoggingServer logServer() {
        return this.logServer;
    }

    public static class Builder {
        private String instanceGuid;
        private List<AnalyticsEngineLoggingNodeSpec> logSpecs;
        private AnalyticsEngineLoggingServer logServer;

        private Builder(ConfigureLoggingOptions configureLoggingOptions) {
            this.instanceGuid = configureLoggingOptions.instanceGuid;
            this.logSpecs = configureLoggingOptions.logSpecs;
            this.logServer = configureLoggingOptions.logServer;
        }

        public Builder() {
        }

        public Builder(String instanceGuid, List<AnalyticsEngineLoggingNodeSpec> logSpecs, AnalyticsEngineLoggingServer logServer) {
            this.instanceGuid = instanceGuid;
            this.logSpecs = logSpecs;
            this.logServer = logServer;
        }

        public ConfigureLoggingOptions build() {
            return new ConfigureLoggingOptions(this);
        }

        public Builder addLogSpecs(AnalyticsEngineLoggingNodeSpec logSpecs) {
            Validator.notNull(logSpecs, "logSpecs cannot be null");
            if (this.logSpecs == null) {
                this.logSpecs = new ArrayList<AnalyticsEngineLoggingNodeSpec>();
            }
            this.logSpecs.add(logSpecs);
            return this;
        }

        public Builder instanceGuid(String instanceGuid) {
            this.instanceGuid = instanceGuid;
            return this;
        }

        public Builder logSpecs(List<AnalyticsEngineLoggingNodeSpec> logSpecs) {
            this.logSpecs = logSpecs;
            return this;
        }

        public Builder logServer(AnalyticsEngineLoggingServer logServer) {
            this.logServer = logServer;
            return this;
        }
    }
}

