/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cloud.iaesdk.ibm_analytics_engine_api.v2.model;

import com.google.gson.annotations.SerializedName;
import com.ibm.cloud.sdk.core.service.model.GenericModel;
import com.ibm.cloud.sdk.core.util.Validator;
import java.util.ArrayList;
import java.util.List;

public class AnalyticsEngineLoggingNodeSpec
extends GenericModel {
    @SerializedName(value="node_type")
    protected String nodeType;
    protected List<String> components;

    protected AnalyticsEngineLoggingNodeSpec(Builder builder) {
        Validator.notNull(builder.nodeType, "nodeType cannot be null");
        Validator.notNull(builder.components, "components cannot be null");
        this.nodeType = builder.nodeType;
        this.components = builder.components;
    }

    public Builder newBuilder() {
        return new Builder(this);
    }

    public String nodeType() {
        return this.nodeType;
    }

    public List<String> components() {
        return this.components;
    }

    public static class Builder {
        private String nodeType;
        private List<String> components;

        private Builder(AnalyticsEngineLoggingNodeSpec analyticsEngineLoggingNodeSpec) {
            this.nodeType = analyticsEngineLoggingNodeSpec.nodeType;
            this.components = analyticsEngineLoggingNodeSpec.components;
        }

        public Builder() {
        }

        public Builder(String nodeType, List<String> components) {
            this.nodeType = nodeType;
            this.components = components;
        }

        public AnalyticsEngineLoggingNodeSpec build() {
            return new AnalyticsEngineLoggingNodeSpec(this);
        }

        public Builder addComponents(String components) {
            Validator.notNull(components, "components cannot be null");
            if (this.components == null) {
                this.components = new ArrayList<String>();
            }
            this.components.add(components);
            return this;
        }

        public Builder nodeType(String nodeType) {
            this.nodeType = nodeType;
            return this;
        }

        public Builder components(List<String> components) {
            this.components = components;
            return this;
        }
    }

    public static interface Components {
        public static final String AMBARI_SERVER = "ambari-server";
        public static final String HADOOP_MAPREDUCE = "hadoop-mapreduce";
        public static final String HADOOP_YARN = "hadoop-yarn";
        public static final String HBASE = "hbase";
        public static final String HDFS = "hdfs";
        public static final String HDFS_AUDIT = "hdfs-audit";
        public static final String HIVE = "hive";
        public static final String JNBG = "jnbg";
        public static final String KNOX = "knox";
        public static final String KNOX_AUDIT = "knox-audit";
        public static final String LIVY2 = "livy2";
        public static final String SPARK2 = "spark2";
        public static final String YARN_APPS = "yarn-apps";
    }

    public static interface NodeType {
        public static final String MANAGEMENT = "management";
        public static final String DATA = "data";
        public static final String TASK = "task";
    }
}

