/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cloud.iaesdk.ibm_analytics_engine_api.v2.model;

import com.google.gson.annotations.SerializedName;
import com.ibm.cloud.iaesdk.ibm_analytics_engine_api.v2.model.AnalyticsEngineCustomActionScript;
import com.ibm.cloud.sdk.core.service.model.GenericModel;
import com.ibm.cloud.sdk.core.util.Validator;
import java.util.ArrayList;
import java.util.List;

public class AnalyticsEngineCustomAction
extends GenericModel {
    protected String name;
    protected String type;
    protected AnalyticsEngineCustomActionScript script;
    @SerializedName(value="script_params")
    protected List<String> scriptParams;

    protected AnalyticsEngineCustomAction(Builder builder) {
        Validator.notNull(builder.name, "name cannot be null");
        this.name = builder.name;
        this.type = builder.type;
        this.script = builder.script;
        this.scriptParams = builder.scriptParams;
    }

    public Builder newBuilder() {
        return new Builder(this);
    }

    public String name() {
        return this.name;
    }

    public String type() {
        return this.type;
    }

    public AnalyticsEngineCustomActionScript script() {
        return this.script;
    }

    public List<String> scriptParams() {
        return this.scriptParams;
    }

    public static class Builder {
        private String name;
        private String type;
        private AnalyticsEngineCustomActionScript script;
        private List<String> scriptParams;

        private Builder(AnalyticsEngineCustomAction analyticsEngineCustomAction) {
            this.name = analyticsEngineCustomAction.name;
            this.type = analyticsEngineCustomAction.type;
            this.script = analyticsEngineCustomAction.script;
            this.scriptParams = analyticsEngineCustomAction.scriptParams;
        }

        public Builder() {
        }

        public Builder(String name) {
            this.name = name;
        }

        public AnalyticsEngineCustomAction build() {
            return new AnalyticsEngineCustomAction(this);
        }

        public Builder addScriptParams(String scriptParams) {
            Validator.notNull(scriptParams, "scriptParams cannot be null");
            if (this.scriptParams == null) {
                this.scriptParams = new ArrayList<String>();
            }
            this.scriptParams.add(scriptParams);
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder type(String type) {
            this.type = type;
            return this;
        }

        public Builder script(AnalyticsEngineCustomActionScript script) {
            this.script = script;
            return this;
        }

        public Builder scriptParams(List<String> scriptParams) {
            this.scriptParams = scriptParams;
            return this;
        }
    }

    public static interface Type {
        public static final String BOOTSTRAP = "bootstrap";
    }
}

