/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cloud.iaesdk.ibm_analytics_engine_api.v2;

import com.ibm.cloud.iaesdk.ibm_analytics_engine_api.v2.IbmAnalyticsEngineApi;
import com.ibm.cloud.iaesdk.ibm_analytics_engine_api.v2.model.AnalyticsEngine;
import com.ibm.cloud.iaesdk.ibm_analytics_engine_api.v2.model.AnalyticsEngineCreateCustomizationResponse;
import com.ibm.cloud.iaesdk.ibm_analytics_engine_api.v2.model.AnalyticsEngineCustomAction;
import com.ibm.cloud.iaesdk.ibm_analytics_engine_api.v2.model.AnalyticsEngineLoggingConfigDetails;
import com.ibm.cloud.iaesdk.ibm_analytics_engine_api.v2.model.AnalyticsEngineLoggingNodeSpec;
import com.ibm.cloud.iaesdk.ibm_analytics_engine_api.v2.model.AnalyticsEngineLoggingServer;
import com.ibm.cloud.iaesdk.ibm_analytics_engine_api.v2.model.AnalyticsEngineResetClusterPasswordResponse;
import com.ibm.cloud.iaesdk.ibm_analytics_engine_api.v2.model.AnalyticsEngineResizeClusterResponse;
import com.ibm.cloud.iaesdk.ibm_analytics_engine_api.v2.model.AnalyticsEngineState;
import com.ibm.cloud.iaesdk.ibm_analytics_engine_api.v2.model.AnalyticsEngineWhitelistResponse;
import com.ibm.cloud.iaesdk.ibm_analytics_engine_api.v2.model.ConfigureLoggingOptions;
import com.ibm.cloud.iaesdk.ibm_analytics_engine_api.v2.model.CreateCustomizationRequestOptions;
import com.ibm.cloud.iaesdk.ibm_analytics_engine_api.v2.model.DeleteLoggingConfigOptions;
import com.ibm.cloud.iaesdk.ibm_analytics_engine_api.v2.model.GetAllAnalyticsEnginesOptions;
import com.ibm.cloud.iaesdk.ibm_analytics_engine_api.v2.model.GetAllCustomizationRequestsOptions;
import com.ibm.cloud.iaesdk.ibm_analytics_engine_api.v2.model.GetAnalyticsEngineByIdOptions;
import com.ibm.cloud.iaesdk.ibm_analytics_engine_api.v2.model.GetAnalyticsEngineStateByIdOptions;
import com.ibm.cloud.iaesdk.ibm_analytics_engine_api.v2.model.GetLoggingConfigOptions;
import com.ibm.cloud.iaesdk.ibm_analytics_engine_api.v2.model.ResetClusterPasswordOptions;
import com.ibm.cloud.iaesdk.ibm_analytics_engine_api.v2.model.ResizeClusterOptions;
import com.ibm.cloud.iaesdk.ibm_analytics_engine_api.v2.model.ResizeClusterRequestAnalyticsEngineResizeClusterByComputeNodesRequest;
import com.ibm.cloud.iaesdk.ibm_analytics_engine_api.v2.model.UpdatePrivateEndpointWhitelistOptions;
import com.ibm.cloud.sdk.core.http.Response;
import com.ibm.cloud.sdk.core.service.exception.ServiceResponseException;
import com.ibm.cloud.sdk.core.util.CredentialUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IbmAnalyticsEngineApiExamples {
    private static final Logger logger = LoggerFactory.getLogger(IbmAnalyticsEngineApiExamples.class);

    protected IbmAnalyticsEngineApiExamples() {
    }

    public static void main(String[] args2) throws Exception {
        Response<AnalyticsEngineResizeClusterResponse> response;
        Response<Object> response2;
        IbmAnalyticsEngineApi ibmAnalyticsEngineApiService = IbmAnalyticsEngineApi.newInstance();
        Map<String, String> config = CredentialUtils.getServiceProperties("ibm_analytics_engine_api");
        try {
            GetAllAnalyticsEnginesOptions getAllAnalyticsEnginesOptions = new GetAllAnalyticsEnginesOptions();
            response2 = ibmAnalyticsEngineApiService.getAllAnalyticsEngines(getAllAnalyticsEnginesOptions).execute();
            System.out.printf("getAllAnalyticsEngines() response status code: %d%n", response2.getStatusCode());
        }
        catch (ServiceResponseException e) {
            logger.error(String.format("Service returned status code %s: %s%nError details: %s", e.getStatusCode(), e.getMessage(), e.getDebuggingInfo()), e);
        }
        try {
            System.out.println("getAnalyticsEngineById() result:");
            GetAnalyticsEngineByIdOptions getAnalyticsEngineByIdOptions = new GetAnalyticsEngineByIdOptions.Builder().instanceGuid("testString").build();
            response2 = ibmAnalyticsEngineApiService.getAnalyticsEngineById(getAnalyticsEngineByIdOptions).execute();
            AnalyticsEngine analyticsEngine = (AnalyticsEngine)response2.getResult();
        }
        catch (ServiceResponseException e) {
            logger.error(String.format("Service returned status code %s: %s%nError details: %s", e.getStatusCode(), e.getMessage(), e.getDebuggingInfo()), e);
        }
        try {
            System.out.println("getAnalyticsEngineStateById() result:");
            GetAnalyticsEngineStateByIdOptions getAnalyticsEngineStateByIdOptions = new GetAnalyticsEngineStateByIdOptions.Builder().instanceGuid("testString").build();
            response2 = ibmAnalyticsEngineApiService.getAnalyticsEngineStateById(getAnalyticsEngineStateByIdOptions).execute();
            AnalyticsEngineState analyticsEngineState = (AnalyticsEngineState)response2.getResult();
            System.out.println(analyticsEngineState);
        }
        catch (ServiceResponseException e) {
            logger.error(String.format("Service returned status code %s: %s%nError details: %s", e.getStatusCode(), e.getMessage(), e.getDebuggingInfo()), e);
        }
        try {
            System.out.println("createCustomizationRequest() result:");
            AnalyticsEngineCustomAction analyticsEngineCustomActionModel = new AnalyticsEngineCustomAction.Builder().name("testString").build();
            CreateCustomizationRequestOptions createCustomizationRequestOptions = new CreateCustomizationRequestOptions.Builder().instanceGuid("testString").target("all").customActions(new ArrayList<AnalyticsEngineCustomAction>(Arrays.asList(analyticsEngineCustomActionModel))).build();
            response = ibmAnalyticsEngineApiService.createCustomizationRequest(createCustomizationRequestOptions).execute();
            AnalyticsEngineCreateCustomizationResponse analyticsEngineCreateCustomizationResponse = response.getResult();
            System.out.println(analyticsEngineCreateCustomizationResponse);
        }
        catch (ServiceResponseException e) {
            logger.error(String.format("Service returned status code %s: %s%nError details: %s", e.getStatusCode(), e.getMessage(), e.getDebuggingInfo()), e);
        }
        try {
            System.out.println("getAllCustomizationRequests() result:");
            GetAllCustomizationRequestsOptions getAllCustomizationRequestsOptions = new GetAllCustomizationRequestsOptions.Builder().instanceGuid("testString").build();
            response2 = ibmAnalyticsEngineApiService.getAllCustomizationRequests(getAllCustomizationRequestsOptions).execute();
            response = (List)response2.getResult();
        }
        catch (ServiceResponseException e) {
            logger.error(String.format("Service returned status code %s: %s%nError details: %s", e.getStatusCode(), e.getMessage(), e.getDebuggingInfo()), e);
        }
        try {
            System.out.println("resizeCluster() result:");
            ResizeClusterRequestAnalyticsEngineResizeClusterByComputeNodesRequest resizeClusterRequestModel = new ResizeClusterRequestAnalyticsEngineResizeClusterByComputeNodesRequest.Builder().build();
            ResizeClusterOptions resizeClusterOptions = new ResizeClusterOptions.Builder().instanceGuid("testString").body(resizeClusterRequestModel).build();
            response = ibmAnalyticsEngineApiService.resizeCluster(resizeClusterOptions).execute();
            AnalyticsEngineResizeClusterResponse analyticsEngineResizeClusterResponse = response.getResult();
            System.out.println(analyticsEngineResizeClusterResponse);
        }
        catch (ServiceResponseException e) {
            logger.error(String.format("Service returned status code %s: %s%nError details: %s", e.getStatusCode(), e.getMessage(), e.getDebuggingInfo()), e);
        }
        try {
            System.out.println("resetClusterPassword() result:");
            ResetClusterPasswordOptions resetClusterPasswordOptions = new ResetClusterPasswordOptions.Builder().instanceGuid("testString").build();
            response2 = ibmAnalyticsEngineApiService.resetClusterPassword(resetClusterPasswordOptions).execute();
            AnalyticsEngineResetClusterPasswordResponse analyticsEngineResetClusterPasswordResponse = (AnalyticsEngineResetClusterPasswordResponse)response2.getResult();
            System.out.println(analyticsEngineResetClusterPasswordResponse);
        }
        catch (ServiceResponseException e) {
            logger.error(String.format("Service returned status code %s: %s%nError details: %s", e.getStatusCode(), e.getMessage(), e.getDebuggingInfo()), e);
        }
        try {
            AnalyticsEngineLoggingNodeSpec analyticsEngineLoggingNodeSpecModel = new AnalyticsEngineLoggingNodeSpec.Builder().nodeType("management").components(new ArrayList<String>(Arrays.asList("ambari-server"))).build();
            AnalyticsEngineLoggingServer analyticsEngineLoggingServerModel = new AnalyticsEngineLoggingServer.Builder().type("logdna").credential("testString").apiHost("testString").logHost("testString").build();
            ConfigureLoggingOptions configureLoggingOptions = new ConfigureLoggingOptions.Builder().instanceGuid("testString").logSpecs(new ArrayList<AnalyticsEngineLoggingNodeSpec>(Arrays.asList(analyticsEngineLoggingNodeSpecModel))).logServer(analyticsEngineLoggingServerModel).build();
            Response<Void> response3 = ibmAnalyticsEngineApiService.configureLogging(configureLoggingOptions).execute();
            System.out.printf("configureLogging() response status code: %d%n", response3.getStatusCode());
        }
        catch (ServiceResponseException e) {
            logger.error(String.format("Service returned status code %s: %s%nError details: %s", e.getStatusCode(), e.getMessage(), e.getDebuggingInfo()), e);
        }
        try {
            System.out.println("getLoggingConfig() result:");
            GetLoggingConfigOptions getLoggingConfigOptions = new GetLoggingConfigOptions.Builder().instanceGuid("testString").build();
            response2 = ibmAnalyticsEngineApiService.getLoggingConfig(getLoggingConfigOptions).execute();
            AnalyticsEngineLoggingConfigDetails analyticsEngineLoggingConfigDetails = (AnalyticsEngineLoggingConfigDetails)response2.getResult();
            System.out.println(analyticsEngineLoggingConfigDetails);
        }
        catch (ServiceResponseException e) {
            logger.error(String.format("Service returned status code %s: %s%nError details: %s", e.getStatusCode(), e.getMessage(), e.getDebuggingInfo()), e);
        }
        try {
            System.out.println("updatePrivateEndpointWhitelist() result:");
            UpdatePrivateEndpointWhitelistOptions updatePrivateEndpointWhitelistOptions = new UpdatePrivateEndpointWhitelistOptions.Builder().instanceGuid("testString").ipRanges(new ArrayList<String>(Arrays.asList("testString"))).action("add").build();
            response2 = ibmAnalyticsEngineApiService.updatePrivateEndpointWhitelist(updatePrivateEndpointWhitelistOptions).execute();
            AnalyticsEngineWhitelistResponse analyticsEngineWhitelistResponse = (AnalyticsEngineWhitelistResponse)response2.getResult();
            System.out.println(analyticsEngineWhitelistResponse);
        }
        catch (ServiceResponseException e) {
            logger.error(String.format("Service returned status code %s: %s%nError details: %s", e.getStatusCode(), e.getMessage(), e.getDebuggingInfo()), e);
        }
        try {
            DeleteLoggingConfigOptions deleteLoggingConfigOptions = new DeleteLoggingConfigOptions.Builder().instanceGuid("testString").build();
            response2 = ibmAnalyticsEngineApiService.deleteLoggingConfig(deleteLoggingConfigOptions).execute();
            System.out.printf("deleteLoggingConfig() response status code: %d%n", response2.getStatusCode());
        }
        catch (ServiceResponseException e) {
            logger.error(String.format("Service returned status code %s: %s%nError details: %s", e.getStatusCode(), e.getMessage(), e.getDebuggingInfo()), e);
        }
    }
}

