/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cloud.iaesdk.ibm_analytics_engine_api.v2;

import com.google.gson.JsonObject;
import com.google.gson.reflect.TypeToken;
import com.ibm.cloud.iaesdk.common.SdkCommon;
import com.ibm.cloud.iaesdk.ibm_analytics_engine_api.v2.model.AnalyticsEngine;
import com.ibm.cloud.iaesdk.ibm_analytics_engine_api.v2.model.AnalyticsEngineCreateCustomizationResponse;
import com.ibm.cloud.iaesdk.ibm_analytics_engine_api.v2.model.AnalyticsEngineCustomizationRequestCollectionItem;
import com.ibm.cloud.iaesdk.ibm_analytics_engine_api.v2.model.AnalyticsEngineCustomizationRunDetails;
import com.ibm.cloud.iaesdk.ibm_analytics_engine_api.v2.model.AnalyticsEngineLoggingConfigDetails;
import com.ibm.cloud.iaesdk.ibm_analytics_engine_api.v2.model.AnalyticsEngineResetClusterPasswordResponse;
import com.ibm.cloud.iaesdk.ibm_analytics_engine_api.v2.model.AnalyticsEngineResizeClusterResponse;
import com.ibm.cloud.iaesdk.ibm_analytics_engine_api.v2.model.AnalyticsEngineState;
import com.ibm.cloud.iaesdk.ibm_analytics_engine_api.v2.model.AnalyticsEngineWhitelistResponse;
import com.ibm.cloud.iaesdk.ibm_analytics_engine_api.v2.model.ConfigureLoggingOptions;
import com.ibm.cloud.iaesdk.ibm_analytics_engine_api.v2.model.CreateCustomizationRequestOptions;
import com.ibm.cloud.iaesdk.ibm_analytics_engine_api.v2.model.DeleteLoggingConfigOptions;
import com.ibm.cloud.iaesdk.ibm_analytics_engine_api.v2.model.GetAllAnalyticsEnginesOptions;
import com.ibm.cloud.iaesdk.ibm_analytics_engine_api.v2.model.GetAllCustomizationRequestsOptions;
import com.ibm.cloud.iaesdk.ibm_analytics_engine_api.v2.model.GetAnalyticsEngineByIdOptions;
import com.ibm.cloud.iaesdk.ibm_analytics_engine_api.v2.model.GetAnalyticsEngineStateByIdOptions;
import com.ibm.cloud.iaesdk.ibm_analytics_engine_api.v2.model.GetCustomizationRequestByIdOptions;
import com.ibm.cloud.iaesdk.ibm_analytics_engine_api.v2.model.GetLoggingConfigOptions;
import com.ibm.cloud.iaesdk.ibm_analytics_engine_api.v2.model.ResetClusterPasswordOptions;
import com.ibm.cloud.iaesdk.ibm_analytics_engine_api.v2.model.ResizeClusterOptions;
import com.ibm.cloud.iaesdk.ibm_analytics_engine_api.v2.model.UpdatePrivateEndpointWhitelistOptions;
import com.ibm.cloud.sdk.core.http.RequestBuilder;
import com.ibm.cloud.sdk.core.http.ResponseConverter;
import com.ibm.cloud.sdk.core.http.ServiceCall;
import com.ibm.cloud.sdk.core.security.Authenticator;
import com.ibm.cloud.sdk.core.security.ConfigBasedAuthenticatorFactory;
import com.ibm.cloud.sdk.core.service.BaseService;
import com.ibm.cloud.sdk.core.util.GsonSingleton;
import com.ibm.cloud.sdk.core.util.ResponseConverterUtils;
import com.ibm.cloud.sdk.core.util.Validator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class IbmAnalyticsEngineApi
extends BaseService {
    public static final String DEFAULT_SERVICE_NAME = "ibm_analytics_engine_api";
    public static final String DEFAULT_SERVICE_URL = "https://ibm-analytics-engine-api.cloud.ibm.com";

    public static IbmAnalyticsEngineApi newInstance() {
        return IbmAnalyticsEngineApi.newInstance(DEFAULT_SERVICE_NAME);
    }

    public static IbmAnalyticsEngineApi newInstance(String serviceName) {
        Authenticator authenticator = ConfigBasedAuthenticatorFactory.getAuthenticator(serviceName);
        IbmAnalyticsEngineApi service = new IbmAnalyticsEngineApi(serviceName, authenticator);
        service.configureService(serviceName);
        return service;
    }

    public IbmAnalyticsEngineApi(String serviceName, Authenticator authenticator) {
        super(serviceName, authenticator);
        this.setServiceUrl(DEFAULT_SERVICE_URL);
    }

    public ServiceCall<Void> getAllAnalyticsEngines(GetAllAnalyticsEnginesOptions getAllAnalyticsEnginesOptions) {
        RequestBuilder builder = RequestBuilder.get(RequestBuilder.resolveRequestUrl(this.getServiceUrl(), "/v2/analytics_engines"));
        Map<String, String> sdkHeaders = SdkCommon.getSdkHeaders(DEFAULT_SERVICE_NAME, "v2", "getAllAnalyticsEngines");
        for (Map.Entry<String, String> header : sdkHeaders.entrySet()) {
            builder.header(header.getKey(), header.getValue());
        }
        ResponseConverter<Void> responseConverter = ResponseConverterUtils.getVoid();
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<Void> getAllAnalyticsEngines() {
        return this.getAllAnalyticsEngines(null);
    }

    public ServiceCall<AnalyticsEngine> getAnalyticsEngineById(GetAnalyticsEngineByIdOptions getAnalyticsEngineByIdOptions) {
        Validator.notNull(getAnalyticsEngineByIdOptions, "getAnalyticsEngineByIdOptions cannot be null");
        HashMap<String, String> pathParamsMap = new HashMap<String, String>();
        pathParamsMap.put("instance_guid", getAnalyticsEngineByIdOptions.instanceGuid());
        RequestBuilder builder = RequestBuilder.get(RequestBuilder.resolveRequestUrl(this.getServiceUrl(), "/v2/analytics_engines/{instance_guid}", pathParamsMap));
        Map<String, String> sdkHeaders = SdkCommon.getSdkHeaders(DEFAULT_SERVICE_NAME, "v2", "getAnalyticsEngineById");
        for (Map.Entry<String, String> header : sdkHeaders.entrySet()) {
            builder.header(header.getKey(), header.getValue());
        }
        builder.header("Accept", "application/json");
        ResponseConverter responseConverter = ResponseConverterUtils.getValue(new TypeToken<AnalyticsEngine>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<AnalyticsEngineState> getAnalyticsEngineStateById(GetAnalyticsEngineStateByIdOptions getAnalyticsEngineStateByIdOptions) {
        Validator.notNull(getAnalyticsEngineStateByIdOptions, "getAnalyticsEngineStateByIdOptions cannot be null");
        HashMap<String, String> pathParamsMap = new HashMap<String, String>();
        pathParamsMap.put("instance_guid", getAnalyticsEngineStateByIdOptions.instanceGuid());
        RequestBuilder builder = RequestBuilder.get(RequestBuilder.resolveRequestUrl(this.getServiceUrl(), "/v2/analytics_engines/{instance_guid}/state", pathParamsMap));
        Map<String, String> sdkHeaders = SdkCommon.getSdkHeaders(DEFAULT_SERVICE_NAME, "v2", "getAnalyticsEngineStateById");
        for (Map.Entry<String, String> header : sdkHeaders.entrySet()) {
            builder.header(header.getKey(), header.getValue());
        }
        builder.header("Accept", "application/json");
        ResponseConverter responseConverter = ResponseConverterUtils.getValue(new TypeToken<AnalyticsEngineState>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<AnalyticsEngineCreateCustomizationResponse> createCustomizationRequest(CreateCustomizationRequestOptions createCustomizationRequestOptions) {
        Validator.notNull(createCustomizationRequestOptions, "createCustomizationRequestOptions cannot be null");
        HashMap<String, String> pathParamsMap = new HashMap<String, String>();
        pathParamsMap.put("instance_guid", createCustomizationRequestOptions.instanceGuid());
        RequestBuilder builder = RequestBuilder.post(RequestBuilder.resolveRequestUrl(this.getServiceUrl(), "/v2/analytics_engines/{instance_guid}/customization_requests", pathParamsMap));
        Map<String, String> sdkHeaders = SdkCommon.getSdkHeaders(DEFAULT_SERVICE_NAME, "v2", "createCustomizationRequest");
        for (Map.Entry<String, String> header : sdkHeaders.entrySet()) {
            builder.header(header.getKey(), header.getValue());
        }
        builder.header("Accept", "application/json");
        JsonObject contentJson = new JsonObject();
        contentJson.addProperty("target", createCustomizationRequestOptions.target());
        contentJson.add("custom_actions", GsonSingleton.getGson().toJsonTree(createCustomizationRequestOptions.customActions()));
        builder.bodyJson(contentJson);
        ResponseConverter responseConverter = ResponseConverterUtils.getValue(new TypeToken<AnalyticsEngineCreateCustomizationResponse>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<List<AnalyticsEngineCustomizationRequestCollectionItem>> getAllCustomizationRequests(GetAllCustomizationRequestsOptions getAllCustomizationRequestsOptions) {
        Validator.notNull(getAllCustomizationRequestsOptions, "getAllCustomizationRequestsOptions cannot be null");
        HashMap<String, String> pathParamsMap = new HashMap<String, String>();
        pathParamsMap.put("instance_guid", getAllCustomizationRequestsOptions.instanceGuid());
        RequestBuilder builder = RequestBuilder.get(RequestBuilder.resolveRequestUrl(this.getServiceUrl(), "/v2/analytics_engines/{instance_guid}/customization_requests", pathParamsMap));
        Map<String, String> sdkHeaders = SdkCommon.getSdkHeaders(DEFAULT_SERVICE_NAME, "v2", "getAllCustomizationRequests");
        for (Map.Entry<String, String> header : sdkHeaders.entrySet()) {
            builder.header(header.getKey(), header.getValue());
        }
        builder.header("Accept", "application/json");
        ResponseConverter responseConverter = ResponseConverterUtils.getValue(new TypeToken<List<AnalyticsEngineCustomizationRequestCollectionItem>>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<AnalyticsEngineCustomizationRunDetails> getCustomizationRequestById(GetCustomizationRequestByIdOptions getCustomizationRequestByIdOptions) {
        Validator.notNull(getCustomizationRequestByIdOptions, "getCustomizationRequestByIdOptions cannot be null");
        HashMap<String, String> pathParamsMap = new HashMap<String, String>();
        pathParamsMap.put("instance_guid", getCustomizationRequestByIdOptions.instanceGuid());
        pathParamsMap.put("request_id", getCustomizationRequestByIdOptions.requestId());
        RequestBuilder builder = RequestBuilder.get(RequestBuilder.resolveRequestUrl(this.getServiceUrl(), "/v2/analytics_engines/{instance_guid}/customization_requests/{request_id}", pathParamsMap));
        Map<String, String> sdkHeaders = SdkCommon.getSdkHeaders(DEFAULT_SERVICE_NAME, "v2", "getCustomizationRequestById");
        for (Map.Entry<String, String> header : sdkHeaders.entrySet()) {
            builder.header(header.getKey(), header.getValue());
        }
        builder.header("Accept", "application/json");
        ResponseConverter responseConverter = ResponseConverterUtils.getValue(new TypeToken<AnalyticsEngineCustomizationRunDetails>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<AnalyticsEngineResizeClusterResponse> resizeCluster(ResizeClusterOptions resizeClusterOptions) {
        Validator.notNull(resizeClusterOptions, "resizeClusterOptions cannot be null");
        HashMap<String, String> pathParamsMap = new HashMap<String, String>();
        pathParamsMap.put("instance_guid", resizeClusterOptions.instanceGuid());
        RequestBuilder builder = RequestBuilder.post(RequestBuilder.resolveRequestUrl(this.getServiceUrl(), "/v2/analytics_engines/{instance_guid}/resize", pathParamsMap));
        Map<String, String> sdkHeaders = SdkCommon.getSdkHeaders(DEFAULT_SERVICE_NAME, "v2", "resizeCluster");
        for (Map.Entry<String, String> header : sdkHeaders.entrySet()) {
            builder.header(header.getKey(), header.getValue());
        }
        builder.header("Accept", "application/json");
        builder.bodyContent(GsonSingleton.getGsonWithoutPrettyPrinting().toJson(resizeClusterOptions.body()), "application/json");
        ResponseConverter responseConverter = ResponseConverterUtils.getValue(new TypeToken<AnalyticsEngineResizeClusterResponse>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<AnalyticsEngineResetClusterPasswordResponse> resetClusterPassword(ResetClusterPasswordOptions resetClusterPasswordOptions) {
        Validator.notNull(resetClusterPasswordOptions, "resetClusterPasswordOptions cannot be null");
        HashMap<String, String> pathParamsMap = new HashMap<String, String>();
        pathParamsMap.put("instance_guid", resetClusterPasswordOptions.instanceGuid());
        RequestBuilder builder = RequestBuilder.post(RequestBuilder.resolveRequestUrl(this.getServiceUrl(), "/v2/analytics_engines/{instance_guid}/reset_password", pathParamsMap));
        Map<String, String> sdkHeaders = SdkCommon.getSdkHeaders(DEFAULT_SERVICE_NAME, "v2", "resetClusterPassword");
        for (Map.Entry<String, String> header : sdkHeaders.entrySet()) {
            builder.header(header.getKey(), header.getValue());
        }
        builder.header("Accept", "application/json");
        ResponseConverter responseConverter = ResponseConverterUtils.getValue(new TypeToken<AnalyticsEngineResetClusterPasswordResponse>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<Void> configureLogging(ConfigureLoggingOptions configureLoggingOptions) {
        Validator.notNull(configureLoggingOptions, "configureLoggingOptions cannot be null");
        HashMap<String, String> pathParamsMap = new HashMap<String, String>();
        pathParamsMap.put("instance_guid", configureLoggingOptions.instanceGuid());
        RequestBuilder builder = RequestBuilder.put(RequestBuilder.resolveRequestUrl(this.getServiceUrl(), "/v2/analytics_engines/{instance_guid}/log_config", pathParamsMap));
        Map<String, String> sdkHeaders = SdkCommon.getSdkHeaders(DEFAULT_SERVICE_NAME, "v2", "configureLogging");
        for (Map.Entry<String, String> header : sdkHeaders.entrySet()) {
            builder.header(header.getKey(), header.getValue());
        }
        JsonObject contentJson = new JsonObject();
        contentJson.add("log_specs", GsonSingleton.getGson().toJsonTree(configureLoggingOptions.logSpecs()));
        contentJson.add("log_server", GsonSingleton.getGson().toJsonTree(configureLoggingOptions.logServer()));
        builder.bodyJson(contentJson);
        ResponseConverter<Void> responseConverter = ResponseConverterUtils.getVoid();
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<AnalyticsEngineLoggingConfigDetails> getLoggingConfig(GetLoggingConfigOptions getLoggingConfigOptions) {
        Validator.notNull(getLoggingConfigOptions, "getLoggingConfigOptions cannot be null");
        HashMap<String, String> pathParamsMap = new HashMap<String, String>();
        pathParamsMap.put("instance_guid", getLoggingConfigOptions.instanceGuid());
        RequestBuilder builder = RequestBuilder.get(RequestBuilder.resolveRequestUrl(this.getServiceUrl(), "/v2/analytics_engines/{instance_guid}/log_config", pathParamsMap));
        Map<String, String> sdkHeaders = SdkCommon.getSdkHeaders(DEFAULT_SERVICE_NAME, "v2", "getLoggingConfig");
        for (Map.Entry<String, String> header : sdkHeaders.entrySet()) {
            builder.header(header.getKey(), header.getValue());
        }
        builder.header("Accept", "application/json");
        ResponseConverter responseConverter = ResponseConverterUtils.getValue(new TypeToken<AnalyticsEngineLoggingConfigDetails>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<Void> deleteLoggingConfig(DeleteLoggingConfigOptions deleteLoggingConfigOptions) {
        Validator.notNull(deleteLoggingConfigOptions, "deleteLoggingConfigOptions cannot be null");
        HashMap<String, String> pathParamsMap = new HashMap<String, String>();
        pathParamsMap.put("instance_guid", deleteLoggingConfigOptions.instanceGuid());
        RequestBuilder builder = RequestBuilder.delete(RequestBuilder.resolveRequestUrl(this.getServiceUrl(), "/v2/analytics_engines/{instance_guid}/log_config", pathParamsMap));
        Map<String, String> sdkHeaders = SdkCommon.getSdkHeaders(DEFAULT_SERVICE_NAME, "v2", "deleteLoggingConfig");
        for (Map.Entry<String, String> header : sdkHeaders.entrySet()) {
            builder.header(header.getKey(), header.getValue());
        }
        ResponseConverter<Void> responseConverter = ResponseConverterUtils.getVoid();
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<AnalyticsEngineWhitelistResponse> updatePrivateEndpointWhitelist(UpdatePrivateEndpointWhitelistOptions updatePrivateEndpointWhitelistOptions) {
        Validator.notNull(updatePrivateEndpointWhitelistOptions, "updatePrivateEndpointWhitelistOptions cannot be null");
        HashMap<String, String> pathParamsMap = new HashMap<String, String>();
        pathParamsMap.put("instance_guid", updatePrivateEndpointWhitelistOptions.instanceGuid());
        RequestBuilder builder = RequestBuilder.patch(RequestBuilder.resolveRequestUrl(this.getServiceUrl(), "/v2/analytics_engines/{instance_guid}/private_endpoint_whitelist", pathParamsMap));
        Map<String, String> sdkHeaders = SdkCommon.getSdkHeaders(DEFAULT_SERVICE_NAME, "v2", "updatePrivateEndpointWhitelist");
        for (Map.Entry<String, String> header : sdkHeaders.entrySet()) {
            builder.header(header.getKey(), header.getValue());
        }
        builder.header("Accept", "application/json");
        JsonObject contentJson = new JsonObject();
        contentJson.add("ip_ranges", GsonSingleton.getGson().toJsonTree(updatePrivateEndpointWhitelistOptions.ipRanges()));
        contentJson.addProperty("action", updatePrivateEndpointWhitelistOptions.action());
        builder.bodyJson(contentJson);
        ResponseConverter responseConverter = ResponseConverterUtils.getValue(new TypeToken<AnalyticsEngineWhitelistResponse>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }
}

