/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cloud.platform_services.context_based_restrictions.v1.model;

import com.ibm.cloud.platform_services.context_based_restrictions.v1.model.ResourceAttribute;
import com.ibm.cloud.platform_services.context_based_restrictions.v1.model.ResourceTagAttribute;
import com.ibm.cloud.sdk.core.service.model.GenericModel;
import com.ibm.cloud.sdk.core.util.Validator;
import java.util.ArrayList;
import java.util.List;

public class Resource
extends GenericModel {
    protected List<ResourceAttribute> attributes;
    protected List<ResourceTagAttribute> tags;

    protected Resource() {
    }

    protected Resource(Builder builder) {
        Validator.notNull((Object)builder.attributes, (String)"attributes cannot be null");
        this.attributes = builder.attributes;
        this.tags = builder.tags;
    }

    public Builder newBuilder() {
        return new Builder(this);
    }

    public List<ResourceAttribute> attributes() {
        return this.attributes;
    }

    public List<ResourceTagAttribute> tags() {
        return this.tags;
    }

    public static class Builder {
        private List<ResourceAttribute> attributes;
        private List<ResourceTagAttribute> tags;

        private Builder(Resource resource) {
            this.attributes = resource.attributes;
            this.tags = resource.tags;
        }

        public Builder() {
        }

        public Builder(List<ResourceAttribute> attributes) {
            this.attributes = attributes;
        }

        public Resource build() {
            return new Resource(this);
        }

        public Builder addAttributes(ResourceAttribute attributes) {
            Validator.notNull((Object)((Object)attributes), (String)"attributes cannot be null");
            if (this.attributes == null) {
                this.attributes = new ArrayList<ResourceAttribute>();
            }
            this.attributes.add(attributes);
            return this;
        }

        public Builder addTags(ResourceTagAttribute tags) {
            Validator.notNull((Object)((Object)tags), (String)"tags cannot be null");
            if (this.tags == null) {
                this.tags = new ArrayList<ResourceTagAttribute>();
            }
            this.tags.add(tags);
            return this;
        }

        public Builder attributes(List<ResourceAttribute> attributes) {
            this.attributes = attributes;
            return this;
        }

        public Builder tags(List<ResourceTagAttribute> tags) {
            this.tags = tags;
            return this;
        }
    }
}

