/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cloud.platform_services.context_based_restrictions.v1.model;

import com.ibm.cloud.platform_services.context_based_restrictions.v1.model.Address;
import com.ibm.cloud.sdk.core.service.model.GenericModel;
import com.ibm.cloud.sdk.core.util.Validator;
import java.util.ArrayList;
import java.util.List;

public class ReplaceZoneOptions
extends GenericModel {
    protected String zoneId;
    protected String ifMatch;
    protected String name;
    protected String accountId;
    protected String description;
    protected List<Address> addresses;
    protected List<Address> excluded;
    protected String xCorrelationId;
    protected String transactionId;

    protected ReplaceZoneOptions() {
    }

    protected ReplaceZoneOptions(Builder builder) {
        Validator.notEmpty((String)builder.zoneId, (String)"zoneId cannot be empty");
        Validator.notNull((Object)builder.ifMatch, (String)"ifMatch cannot be null");
        this.zoneId = builder.zoneId;
        this.ifMatch = builder.ifMatch;
        this.name = builder.name;
        this.accountId = builder.accountId;
        this.description = builder.description;
        this.addresses = builder.addresses;
        this.excluded = builder.excluded;
        this.xCorrelationId = builder.xCorrelationId;
        this.transactionId = builder.transactionId;
    }

    public Builder newBuilder() {
        return new Builder(this);
    }

    public String zoneId() {
        return this.zoneId;
    }

    public String ifMatch() {
        return this.ifMatch;
    }

    public String name() {
        return this.name;
    }

    public String accountId() {
        return this.accountId;
    }

    public String description() {
        return this.description;
    }

    public List<Address> addresses() {
        return this.addresses;
    }

    public List<Address> excluded() {
        return this.excluded;
    }

    public String xCorrelationId() {
        return this.xCorrelationId;
    }

    public String transactionId() {
        return this.transactionId;
    }

    public static class Builder {
        private String zoneId;
        private String ifMatch;
        private String name;
        private String accountId;
        private String description;
        private List<Address> addresses;
        private List<Address> excluded;
        private String xCorrelationId;
        private String transactionId;

        private Builder(ReplaceZoneOptions replaceZoneOptions) {
            this.zoneId = replaceZoneOptions.zoneId;
            this.ifMatch = replaceZoneOptions.ifMatch;
            this.name = replaceZoneOptions.name;
            this.accountId = replaceZoneOptions.accountId;
            this.description = replaceZoneOptions.description;
            this.addresses = replaceZoneOptions.addresses;
            this.excluded = replaceZoneOptions.excluded;
            this.xCorrelationId = replaceZoneOptions.xCorrelationId;
            this.transactionId = replaceZoneOptions.transactionId;
        }

        public Builder() {
        }

        public Builder(String zoneId, String ifMatch) {
            this.zoneId = zoneId;
            this.ifMatch = ifMatch;
        }

        public ReplaceZoneOptions build() {
            return new ReplaceZoneOptions(this);
        }

        public Builder addAddresses(Address addresses) {
            Validator.notNull((Object)((Object)addresses), (String)"addresses cannot be null");
            if (this.addresses == null) {
                this.addresses = new ArrayList<Address>();
            }
            this.addresses.add(addresses);
            return this;
        }

        public Builder addExcluded(Address excluded) {
            Validator.notNull((Object)((Object)excluded), (String)"excluded cannot be null");
            if (this.excluded == null) {
                this.excluded = new ArrayList<Address>();
            }
            this.excluded.add(excluded);
            return this;
        }

        public Builder zoneId(String zoneId) {
            this.zoneId = zoneId;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder accountId(String accountId) {
            this.accountId = accountId;
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            return this;
        }

        public Builder addresses(List<Address> addresses) {
            this.addresses = addresses;
            return this;
        }

        public Builder excluded(List<Address> excluded) {
            this.excluded = excluded;
            return this;
        }

        public Builder xCorrelationId(String xCorrelationId) {
            this.xCorrelationId = xCorrelationId;
            return this;
        }

        public Builder transactionId(String transactionId) {
            this.transactionId = transactionId;
            return this;
        }
    }
}

