/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cloud.platform_services.context_based_restrictions.v1.model;

import com.ibm.cloud.platform_services.context_based_restrictions.v1.model.NewRuleOperations;
import com.ibm.cloud.platform_services.context_based_restrictions.v1.model.Resource;
import com.ibm.cloud.platform_services.context_based_restrictions.v1.model.RuleContext;
import com.ibm.cloud.sdk.core.service.model.GenericModel;
import com.ibm.cloud.sdk.core.util.Validator;
import java.util.ArrayList;
import java.util.List;

public class ReplaceRuleOptions
extends GenericModel {
    protected String ruleId;
    protected String ifMatch;
    protected String description;
    protected List<RuleContext> contexts;
    protected List<Resource> resources;
    protected NewRuleOperations operations;
    protected String enforcementMode;
    protected String xCorrelationId;
    protected String transactionId;

    protected ReplaceRuleOptions() {
    }

    protected ReplaceRuleOptions(Builder builder) {
        Validator.notEmpty((String)builder.ruleId, (String)"ruleId cannot be empty");
        Validator.notNull((Object)builder.ifMatch, (String)"ifMatch cannot be null");
        this.ruleId = builder.ruleId;
        this.ifMatch = builder.ifMatch;
        this.description = builder.description;
        this.contexts = builder.contexts;
        this.resources = builder.resources;
        this.operations = builder.operations;
        this.enforcementMode = builder.enforcementMode;
        this.xCorrelationId = builder.xCorrelationId;
        this.transactionId = builder.transactionId;
    }

    public Builder newBuilder() {
        return new Builder(this);
    }

    public String ruleId() {
        return this.ruleId;
    }

    public String ifMatch() {
        return this.ifMatch;
    }

    public String description() {
        return this.description;
    }

    public List<RuleContext> contexts() {
        return this.contexts;
    }

    public List<Resource> resources() {
        return this.resources;
    }

    public NewRuleOperations operations() {
        return this.operations;
    }

    public String enforcementMode() {
        return this.enforcementMode;
    }

    public String xCorrelationId() {
        return this.xCorrelationId;
    }

    public String transactionId() {
        return this.transactionId;
    }

    public static class Builder {
        private String ruleId;
        private String ifMatch;
        private String description;
        private List<RuleContext> contexts;
        private List<Resource> resources;
        private NewRuleOperations operations;
        private String enforcementMode;
        private String xCorrelationId;
        private String transactionId;

        private Builder(ReplaceRuleOptions replaceRuleOptions) {
            this.ruleId = replaceRuleOptions.ruleId;
            this.ifMatch = replaceRuleOptions.ifMatch;
            this.description = replaceRuleOptions.description;
            this.contexts = replaceRuleOptions.contexts;
            this.resources = replaceRuleOptions.resources;
            this.operations = replaceRuleOptions.operations;
            this.enforcementMode = replaceRuleOptions.enforcementMode;
            this.xCorrelationId = replaceRuleOptions.xCorrelationId;
            this.transactionId = replaceRuleOptions.transactionId;
        }

        public Builder() {
        }

        public Builder(String ruleId, String ifMatch) {
            this.ruleId = ruleId;
            this.ifMatch = ifMatch;
        }

        public ReplaceRuleOptions build() {
            return new ReplaceRuleOptions(this);
        }

        public Builder addContexts(RuleContext contexts) {
            Validator.notNull((Object)((Object)contexts), (String)"contexts cannot be null");
            if (this.contexts == null) {
                this.contexts = new ArrayList<RuleContext>();
            }
            this.contexts.add(contexts);
            return this;
        }

        public Builder addResources(Resource resources) {
            Validator.notNull((Object)((Object)resources), (String)"resources cannot be null");
            if (this.resources == null) {
                this.resources = new ArrayList<Resource>();
            }
            this.resources.add(resources);
            return this;
        }

        public Builder ruleId(String ruleId) {
            this.ruleId = ruleId;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            return this;
        }

        public Builder contexts(List<RuleContext> contexts) {
            this.contexts = contexts;
            return this;
        }

        public Builder resources(List<Resource> resources) {
            this.resources = resources;
            return this;
        }

        public Builder operations(NewRuleOperations operations) {
            this.operations = operations;
            return this;
        }

        public Builder enforcementMode(String enforcementMode) {
            this.enforcementMode = enforcementMode;
            return this;
        }

        public Builder xCorrelationId(String xCorrelationId) {
            this.xCorrelationId = xCorrelationId;
            return this;
        }

        public Builder transactionId(String transactionId) {
            this.transactionId = transactionId;
            return this;
        }
    }

    public static interface EnforcementMode {
        public static final String ENABLED = "enabled";
        public static final String DISABLED = "disabled";
        public static final String REPORT = "report";
    }
}

