/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cloud.platform_services.context_based_restrictions.v1.model;

import com.ibm.cloud.platform_services.context_based_restrictions.v1.model.Address;
import com.ibm.cloud.sdk.core.service.model.GenericModel;
import com.ibm.cloud.sdk.core.util.Validator;
import java.util.ArrayList;
import java.util.List;

public class CreateZoneOptions
extends GenericModel {
    protected String name;
    protected String accountId;
    protected String description;
    protected List<Address> addresses;
    protected List<Address> excluded;
    protected String xCorrelationId;
    protected String transactionId;

    protected CreateZoneOptions() {
    }

    protected CreateZoneOptions(Builder builder) {
        this.name = builder.name;
        this.accountId = builder.accountId;
        this.description = builder.description;
        this.addresses = builder.addresses;
        this.excluded = builder.excluded;
        this.xCorrelationId = builder.xCorrelationId;
        this.transactionId = builder.transactionId;
    }

    public Builder newBuilder() {
        return new Builder(this);
    }

    public String name() {
        return this.name;
    }

    public String accountId() {
        return this.accountId;
    }

    public String description() {
        return this.description;
    }

    public List<Address> addresses() {
        return this.addresses;
    }

    public List<Address> excluded() {
        return this.excluded;
    }

    public String xCorrelationId() {
        return this.xCorrelationId;
    }

    public String transactionId() {
        return this.transactionId;
    }

    public static class Builder {
        private String name;
        private String accountId;
        private String description;
        private List<Address> addresses;
        private List<Address> excluded;
        private String xCorrelationId;
        private String transactionId;

        private Builder(CreateZoneOptions createZoneOptions) {
            this.name = createZoneOptions.name;
            this.accountId = createZoneOptions.accountId;
            this.description = createZoneOptions.description;
            this.addresses = createZoneOptions.addresses;
            this.excluded = createZoneOptions.excluded;
            this.xCorrelationId = createZoneOptions.xCorrelationId;
            this.transactionId = createZoneOptions.transactionId;
        }

        public Builder() {
        }

        public CreateZoneOptions build() {
            return new CreateZoneOptions(this);
        }

        public Builder addAddresses(Address addresses) {
            Validator.notNull((Object)((Object)addresses), (String)"addresses cannot be null");
            if (this.addresses == null) {
                this.addresses = new ArrayList<Address>();
            }
            this.addresses.add(addresses);
            return this;
        }

        public Builder addExcluded(Address excluded) {
            Validator.notNull((Object)((Object)excluded), (String)"excluded cannot be null");
            if (this.excluded == null) {
                this.excluded = new ArrayList<Address>();
            }
            this.excluded.add(excluded);
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder accountId(String accountId) {
            this.accountId = accountId;
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            return this;
        }

        public Builder addresses(List<Address> addresses) {
            this.addresses = addresses;
            return this;
        }

        public Builder excluded(List<Address> excluded) {
            this.excluded = excluded;
            return this;
        }

        public Builder xCorrelationId(String xCorrelationId) {
            this.xCorrelationId = xCorrelationId;
            return this;
        }

        public Builder transactionId(String transactionId) {
            this.transactionId = transactionId;
            return this;
        }
    }
}

