/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cloud.platform_services.context_based_restrictions.v1;

import com.google.gson.JsonObject;
import com.google.gson.reflect.TypeToken;
import com.ibm.cloud.platform_services.common.SdkCommon;
import com.ibm.cloud.platform_services.context_based_restrictions.v1.model.AccountSettings;
import com.ibm.cloud.platform_services.context_based_restrictions.v1.model.CreateRuleOptions;
import com.ibm.cloud.platform_services.context_based_restrictions.v1.model.CreateZoneOptions;
import com.ibm.cloud.platform_services.context_based_restrictions.v1.model.DeleteRuleOptions;
import com.ibm.cloud.platform_services.context_based_restrictions.v1.model.DeleteZoneOptions;
import com.ibm.cloud.platform_services.context_based_restrictions.v1.model.GetAccountSettingsOptions;
import com.ibm.cloud.platform_services.context_based_restrictions.v1.model.GetRuleOptions;
import com.ibm.cloud.platform_services.context_based_restrictions.v1.model.GetZoneOptions;
import com.ibm.cloud.platform_services.context_based_restrictions.v1.model.ListAvailableServiceOperationsOptions;
import com.ibm.cloud.platform_services.context_based_restrictions.v1.model.ListAvailableServicerefTargetsOptions;
import com.ibm.cloud.platform_services.context_based_restrictions.v1.model.ListRulesOptions;
import com.ibm.cloud.platform_services.context_based_restrictions.v1.model.ListZonesOptions;
import com.ibm.cloud.platform_services.context_based_restrictions.v1.model.OperationsList;
import com.ibm.cloud.platform_services.context_based_restrictions.v1.model.ReplaceRuleOptions;
import com.ibm.cloud.platform_services.context_based_restrictions.v1.model.ReplaceZoneOptions;
import com.ibm.cloud.platform_services.context_based_restrictions.v1.model.Rule;
import com.ibm.cloud.platform_services.context_based_restrictions.v1.model.RuleList;
import com.ibm.cloud.platform_services.context_based_restrictions.v1.model.ServiceRefTargetList;
import com.ibm.cloud.platform_services.context_based_restrictions.v1.model.Zone;
import com.ibm.cloud.platform_services.context_based_restrictions.v1.model.ZoneList;
import com.ibm.cloud.sdk.core.http.RequestBuilder;
import com.ibm.cloud.sdk.core.http.ResponseConverter;
import com.ibm.cloud.sdk.core.http.ServiceCall;
import com.ibm.cloud.sdk.core.security.Authenticator;
import com.ibm.cloud.sdk.core.security.ConfigBasedAuthenticatorFactory;
import com.ibm.cloud.sdk.core.service.BaseService;
import com.ibm.cloud.sdk.core.util.GsonSingleton;
import com.ibm.cloud.sdk.core.util.ResponseConverterUtils;
import com.ibm.cloud.sdk.core.util.Validator;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;
import okhttp3.HttpUrl;

public class ContextBasedRestrictions
extends BaseService {
    public static final String DEFAULT_SERVICE_NAME = "context_based_restrictions";
    public static final String DEFAULT_SERVICE_URL = "https://cbr.cloud.ibm.com";

    public static ContextBasedRestrictions newInstance() {
        return ContextBasedRestrictions.newInstance(DEFAULT_SERVICE_NAME);
    }

    public static ContextBasedRestrictions newInstance(String serviceName) {
        Authenticator authenticator = ConfigBasedAuthenticatorFactory.getAuthenticator((String)serviceName);
        ContextBasedRestrictions service = new ContextBasedRestrictions(serviceName, authenticator);
        service.configureService(serviceName);
        return service;
    }

    public ContextBasedRestrictions(String serviceName, Authenticator authenticator) {
        super(serviceName, authenticator);
        this.setServiceUrl(DEFAULT_SERVICE_URL);
    }

    public ServiceCall<Zone> createZone(CreateZoneOptions createZoneOptions) {
        boolean skipBody = false;
        if (createZoneOptions == null) {
            createZoneOptions = new CreateZoneOptions.Builder().build();
            skipBody = true;
        }
        RequestBuilder builder = RequestBuilder.post((HttpUrl)RequestBuilder.resolveRequestUrl((String)this.getServiceUrl(), (String)"/v1/zones"));
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)DEFAULT_SERVICE_NAME, (String)"v1", (String)"createZone");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        builder.header(new Object[]{"Accept", "application/json"});
        if (createZoneOptions.xCorrelationId() != null) {
            builder.header(new Object[]{"X-Correlation-Id", createZoneOptions.xCorrelationId()});
        }
        if (createZoneOptions.transactionId() != null) {
            builder.header(new Object[]{"Transaction-Id", createZoneOptions.transactionId()});
        }
        if (!skipBody) {
            JsonObject contentJson = new JsonObject();
            if (createZoneOptions.name() != null) {
                contentJson.addProperty("name", createZoneOptions.name());
            }
            if (createZoneOptions.accountId() != null) {
                contentJson.addProperty("account_id", createZoneOptions.accountId());
            }
            if (createZoneOptions.description() != null) {
                contentJson.addProperty("description", createZoneOptions.description());
            }
            if (createZoneOptions.addresses() != null) {
                contentJson.add("addresses", GsonSingleton.getGson().toJsonTree(createZoneOptions.addresses()));
            }
            if (createZoneOptions.excluded() != null) {
                contentJson.add("excluded", GsonSingleton.getGson().toJsonTree(createZoneOptions.excluded()));
            }
            builder.bodyJson(contentJson);
        }
        ResponseConverter responseConverter = ResponseConverterUtils.getValue((Type)new TypeToken<Zone>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<Zone> createZone() {
        return this.createZone(null);
    }

    public ServiceCall<ZoneList> listZones(ListZonesOptions listZonesOptions) {
        Validator.notNull((Object)((Object)listZonesOptions), (String)"listZonesOptions cannot be null");
        RequestBuilder builder = RequestBuilder.get((HttpUrl)RequestBuilder.resolveRequestUrl((String)this.getServiceUrl(), (String)"/v1/zones"));
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)DEFAULT_SERVICE_NAME, (String)"v1", (String)"listZones");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        builder.header(new Object[]{"Accept", "application/json"});
        if (listZonesOptions.xCorrelationId() != null) {
            builder.header(new Object[]{"X-Correlation-Id", listZonesOptions.xCorrelationId()});
        }
        if (listZonesOptions.transactionId() != null) {
            builder.header(new Object[]{"Transaction-Id", listZonesOptions.transactionId()});
        }
        builder.query(new Object[]{"account_id", String.valueOf(listZonesOptions.accountId())});
        if (listZonesOptions.name() != null) {
            builder.query(new Object[]{"name", String.valueOf(listZonesOptions.name())});
        }
        if (listZonesOptions.sort() != null) {
            builder.query(new Object[]{"sort", String.valueOf(listZonesOptions.sort())});
        }
        ResponseConverter responseConverter = ResponseConverterUtils.getValue((Type)new TypeToken<ZoneList>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<Zone> getZone(GetZoneOptions getZoneOptions) {
        Validator.notNull((Object)((Object)getZoneOptions), (String)"getZoneOptions cannot be null");
        HashMap<String, String> pathParamsMap = new HashMap<String, String>();
        pathParamsMap.put("zone_id", getZoneOptions.zoneId());
        RequestBuilder builder = RequestBuilder.get((HttpUrl)RequestBuilder.resolveRequestUrl((String)this.getServiceUrl(), (String)"/v1/zones/{zone_id}", pathParamsMap));
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)DEFAULT_SERVICE_NAME, (String)"v1", (String)"getZone");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        builder.header(new Object[]{"Accept", "application/json"});
        if (getZoneOptions.xCorrelationId() != null) {
            builder.header(new Object[]{"X-Correlation-Id", getZoneOptions.xCorrelationId()});
        }
        if (getZoneOptions.transactionId() != null) {
            builder.header(new Object[]{"Transaction-Id", getZoneOptions.transactionId()});
        }
        ResponseConverter responseConverter = ResponseConverterUtils.getValue((Type)new TypeToken<Zone>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<Zone> replaceZone(ReplaceZoneOptions replaceZoneOptions) {
        Validator.notNull((Object)((Object)replaceZoneOptions), (String)"replaceZoneOptions cannot be null");
        HashMap<String, String> pathParamsMap = new HashMap<String, String>();
        pathParamsMap.put("zone_id", replaceZoneOptions.zoneId());
        RequestBuilder builder = RequestBuilder.put((HttpUrl)RequestBuilder.resolveRequestUrl((String)this.getServiceUrl(), (String)"/v1/zones/{zone_id}", pathParamsMap));
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)DEFAULT_SERVICE_NAME, (String)"v1", (String)"replaceZone");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        builder.header(new Object[]{"Accept", "application/json"});
        builder.header(new Object[]{"If-Match", replaceZoneOptions.ifMatch()});
        if (replaceZoneOptions.xCorrelationId() != null) {
            builder.header(new Object[]{"X-Correlation-Id", replaceZoneOptions.xCorrelationId()});
        }
        if (replaceZoneOptions.transactionId() != null) {
            builder.header(new Object[]{"Transaction-Id", replaceZoneOptions.transactionId()});
        }
        JsonObject contentJson = new JsonObject();
        if (replaceZoneOptions.name() != null) {
            contentJson.addProperty("name", replaceZoneOptions.name());
        }
        if (replaceZoneOptions.accountId() != null) {
            contentJson.addProperty("account_id", replaceZoneOptions.accountId());
        }
        if (replaceZoneOptions.description() != null) {
            contentJson.addProperty("description", replaceZoneOptions.description());
        }
        if (replaceZoneOptions.addresses() != null) {
            contentJson.add("addresses", GsonSingleton.getGson().toJsonTree(replaceZoneOptions.addresses()));
        }
        if (replaceZoneOptions.excluded() != null) {
            contentJson.add("excluded", GsonSingleton.getGson().toJsonTree(replaceZoneOptions.excluded()));
        }
        builder.bodyJson(contentJson);
        ResponseConverter responseConverter = ResponseConverterUtils.getValue((Type)new TypeToken<Zone>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<Void> deleteZone(DeleteZoneOptions deleteZoneOptions) {
        Validator.notNull((Object)((Object)deleteZoneOptions), (String)"deleteZoneOptions cannot be null");
        HashMap<String, String> pathParamsMap = new HashMap<String, String>();
        pathParamsMap.put("zone_id", deleteZoneOptions.zoneId());
        RequestBuilder builder = RequestBuilder.delete((HttpUrl)RequestBuilder.resolveRequestUrl((String)this.getServiceUrl(), (String)"/v1/zones/{zone_id}", pathParamsMap));
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)DEFAULT_SERVICE_NAME, (String)"v1", (String)"deleteZone");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        if (deleteZoneOptions.xCorrelationId() != null) {
            builder.header(new Object[]{"X-Correlation-Id", deleteZoneOptions.xCorrelationId()});
        }
        if (deleteZoneOptions.transactionId() != null) {
            builder.header(new Object[]{"Transaction-Id", deleteZoneOptions.transactionId()});
        }
        ResponseConverter responseConverter = ResponseConverterUtils.getVoid();
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<ServiceRefTargetList> listAvailableServicerefTargets(ListAvailableServicerefTargetsOptions listAvailableServicerefTargetsOptions) {
        if (listAvailableServicerefTargetsOptions == null) {
            listAvailableServicerefTargetsOptions = new ListAvailableServicerefTargetsOptions.Builder().build();
        }
        RequestBuilder builder = RequestBuilder.get((HttpUrl)RequestBuilder.resolveRequestUrl((String)this.getServiceUrl(), (String)"/v1/zones/serviceref_targets"));
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)DEFAULT_SERVICE_NAME, (String)"v1", (String)"listAvailableServicerefTargets");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        builder.header(new Object[]{"Accept", "application/json"});
        if (listAvailableServicerefTargetsOptions.xCorrelationId() != null) {
            builder.header(new Object[]{"X-Correlation-Id", listAvailableServicerefTargetsOptions.xCorrelationId()});
        }
        if (listAvailableServicerefTargetsOptions.transactionId() != null) {
            builder.header(new Object[]{"Transaction-Id", listAvailableServicerefTargetsOptions.transactionId()});
        }
        if (listAvailableServicerefTargetsOptions.type() != null) {
            builder.query(new Object[]{"type", String.valueOf(listAvailableServicerefTargetsOptions.type())});
        }
        ResponseConverter responseConverter = ResponseConverterUtils.getValue((Type)new TypeToken<ServiceRefTargetList>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<ServiceRefTargetList> listAvailableServicerefTargets() {
        return this.listAvailableServicerefTargets(null);
    }

    public ServiceCall<Rule> createRule(CreateRuleOptions createRuleOptions) {
        boolean skipBody = false;
        if (createRuleOptions == null) {
            createRuleOptions = new CreateRuleOptions.Builder().build();
            skipBody = true;
        }
        RequestBuilder builder = RequestBuilder.post((HttpUrl)RequestBuilder.resolveRequestUrl((String)this.getServiceUrl(), (String)"/v1/rules"));
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)DEFAULT_SERVICE_NAME, (String)"v1", (String)"createRule");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        builder.header(new Object[]{"Accept", "application/json"});
        if (createRuleOptions.xCorrelationId() != null) {
            builder.header(new Object[]{"X-Correlation-Id", createRuleOptions.xCorrelationId()});
        }
        if (createRuleOptions.transactionId() != null) {
            builder.header(new Object[]{"Transaction-Id", createRuleOptions.transactionId()});
        }
        if (!skipBody) {
            JsonObject contentJson = new JsonObject();
            if (createRuleOptions.description() != null) {
                contentJson.addProperty("description", createRuleOptions.description());
            }
            if (createRuleOptions.contexts() != null) {
                contentJson.add("contexts", GsonSingleton.getGson().toJsonTree(createRuleOptions.contexts()));
            }
            if (createRuleOptions.resources() != null) {
                contentJson.add("resources", GsonSingleton.getGson().toJsonTree(createRuleOptions.resources()));
            }
            if (createRuleOptions.operations() != null) {
                contentJson.add("operations", GsonSingleton.getGson().toJsonTree((Object)createRuleOptions.operations()));
            }
            if (createRuleOptions.enforcementMode() != null) {
                contentJson.addProperty("enforcement_mode", createRuleOptions.enforcementMode());
            }
            builder.bodyJson(contentJson);
        }
        ResponseConverter responseConverter = ResponseConverterUtils.getValue((Type)new TypeToken<Rule>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<Rule> createRule() {
        return this.createRule(null);
    }

    public ServiceCall<RuleList> listRules(ListRulesOptions listRulesOptions) {
        Validator.notNull((Object)((Object)listRulesOptions), (String)"listRulesOptions cannot be null");
        RequestBuilder builder = RequestBuilder.get((HttpUrl)RequestBuilder.resolveRequestUrl((String)this.getServiceUrl(), (String)"/v1/rules"));
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)DEFAULT_SERVICE_NAME, (String)"v1", (String)"listRules");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        builder.header(new Object[]{"Accept", "application/json"});
        if (listRulesOptions.xCorrelationId() != null) {
            builder.header(new Object[]{"X-Correlation-Id", listRulesOptions.xCorrelationId()});
        }
        if (listRulesOptions.transactionId() != null) {
            builder.header(new Object[]{"Transaction-Id", listRulesOptions.transactionId()});
        }
        builder.query(new Object[]{"account_id", String.valueOf(listRulesOptions.accountId())});
        if (listRulesOptions.region() != null) {
            builder.query(new Object[]{"region", String.valueOf(listRulesOptions.region())});
        }
        if (listRulesOptions.resource() != null) {
            builder.query(new Object[]{"resource", String.valueOf(listRulesOptions.resource())});
        }
        if (listRulesOptions.resourceType() != null) {
            builder.query(new Object[]{"resource_type", String.valueOf(listRulesOptions.resourceType())});
        }
        if (listRulesOptions.serviceInstance() != null) {
            builder.query(new Object[]{"service_instance", String.valueOf(listRulesOptions.serviceInstance())});
        }
        if (listRulesOptions.serviceName() != null) {
            builder.query(new Object[]{"service_name", String.valueOf(listRulesOptions.serviceName())});
        }
        if (listRulesOptions.serviceType() != null) {
            builder.query(new Object[]{"service_type", String.valueOf(listRulesOptions.serviceType())});
        }
        if (listRulesOptions.serviceGroupId() != null) {
            builder.query(new Object[]{"service_group_id", String.valueOf(listRulesOptions.serviceGroupId())});
        }
        if (listRulesOptions.zoneId() != null) {
            builder.query(new Object[]{"zone_id", String.valueOf(listRulesOptions.zoneId())});
        }
        if (listRulesOptions.sort() != null) {
            builder.query(new Object[]{"sort", String.valueOf(listRulesOptions.sort())});
        }
        if (listRulesOptions.enforcementMode() != null) {
            builder.query(new Object[]{"enforcement_mode", String.valueOf(listRulesOptions.enforcementMode())});
        }
        ResponseConverter responseConverter = ResponseConverterUtils.getValue((Type)new TypeToken<RuleList>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<Rule> getRule(GetRuleOptions getRuleOptions) {
        Validator.notNull((Object)((Object)getRuleOptions), (String)"getRuleOptions cannot be null");
        HashMap<String, String> pathParamsMap = new HashMap<String, String>();
        pathParamsMap.put("rule_id", getRuleOptions.ruleId());
        RequestBuilder builder = RequestBuilder.get((HttpUrl)RequestBuilder.resolveRequestUrl((String)this.getServiceUrl(), (String)"/v1/rules/{rule_id}", pathParamsMap));
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)DEFAULT_SERVICE_NAME, (String)"v1", (String)"getRule");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        builder.header(new Object[]{"Accept", "application/json"});
        if (getRuleOptions.xCorrelationId() != null) {
            builder.header(new Object[]{"X-Correlation-Id", getRuleOptions.xCorrelationId()});
        }
        if (getRuleOptions.transactionId() != null) {
            builder.header(new Object[]{"Transaction-Id", getRuleOptions.transactionId()});
        }
        ResponseConverter responseConverter = ResponseConverterUtils.getValue((Type)new TypeToken<Rule>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<Rule> replaceRule(ReplaceRuleOptions replaceRuleOptions) {
        Validator.notNull((Object)((Object)replaceRuleOptions), (String)"replaceRuleOptions cannot be null");
        HashMap<String, String> pathParamsMap = new HashMap<String, String>();
        pathParamsMap.put("rule_id", replaceRuleOptions.ruleId());
        RequestBuilder builder = RequestBuilder.put((HttpUrl)RequestBuilder.resolveRequestUrl((String)this.getServiceUrl(), (String)"/v1/rules/{rule_id}", pathParamsMap));
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)DEFAULT_SERVICE_NAME, (String)"v1", (String)"replaceRule");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        builder.header(new Object[]{"Accept", "application/json"});
        builder.header(new Object[]{"If-Match", replaceRuleOptions.ifMatch()});
        if (replaceRuleOptions.xCorrelationId() != null) {
            builder.header(new Object[]{"X-Correlation-Id", replaceRuleOptions.xCorrelationId()});
        }
        if (replaceRuleOptions.transactionId() != null) {
            builder.header(new Object[]{"Transaction-Id", replaceRuleOptions.transactionId()});
        }
        JsonObject contentJson = new JsonObject();
        if (replaceRuleOptions.description() != null) {
            contentJson.addProperty("description", replaceRuleOptions.description());
        }
        if (replaceRuleOptions.contexts() != null) {
            contentJson.add("contexts", GsonSingleton.getGson().toJsonTree(replaceRuleOptions.contexts()));
        }
        if (replaceRuleOptions.resources() != null) {
            contentJson.add("resources", GsonSingleton.getGson().toJsonTree(replaceRuleOptions.resources()));
        }
        if (replaceRuleOptions.operations() != null) {
            contentJson.add("operations", GsonSingleton.getGson().toJsonTree((Object)replaceRuleOptions.operations()));
        }
        if (replaceRuleOptions.enforcementMode() != null) {
            contentJson.addProperty("enforcement_mode", replaceRuleOptions.enforcementMode());
        }
        builder.bodyJson(contentJson);
        ResponseConverter responseConverter = ResponseConverterUtils.getValue((Type)new TypeToken<Rule>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<Void> deleteRule(DeleteRuleOptions deleteRuleOptions) {
        Validator.notNull((Object)((Object)deleteRuleOptions), (String)"deleteRuleOptions cannot be null");
        HashMap<String, String> pathParamsMap = new HashMap<String, String>();
        pathParamsMap.put("rule_id", deleteRuleOptions.ruleId());
        RequestBuilder builder = RequestBuilder.delete((HttpUrl)RequestBuilder.resolveRequestUrl((String)this.getServiceUrl(), (String)"/v1/rules/{rule_id}", pathParamsMap));
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)DEFAULT_SERVICE_NAME, (String)"v1", (String)"deleteRule");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        if (deleteRuleOptions.xCorrelationId() != null) {
            builder.header(new Object[]{"X-Correlation-Id", deleteRuleOptions.xCorrelationId()});
        }
        if (deleteRuleOptions.transactionId() != null) {
            builder.header(new Object[]{"Transaction-Id", deleteRuleOptions.transactionId()});
        }
        ResponseConverter responseConverter = ResponseConverterUtils.getVoid();
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<AccountSettings> getAccountSettings(GetAccountSettingsOptions getAccountSettingsOptions) {
        Validator.notNull((Object)((Object)getAccountSettingsOptions), (String)"getAccountSettingsOptions cannot be null");
        HashMap<String, String> pathParamsMap = new HashMap<String, String>();
        pathParamsMap.put("account_id", getAccountSettingsOptions.accountId());
        RequestBuilder builder = RequestBuilder.get((HttpUrl)RequestBuilder.resolveRequestUrl((String)this.getServiceUrl(), (String)"/v1/account_settings/{account_id}", pathParamsMap));
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)DEFAULT_SERVICE_NAME, (String)"v1", (String)"getAccountSettings");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        builder.header(new Object[]{"Accept", "application/json"});
        if (getAccountSettingsOptions.xCorrelationId() != null) {
            builder.header(new Object[]{"X-Correlation-Id", getAccountSettingsOptions.xCorrelationId()});
        }
        if (getAccountSettingsOptions.transactionId() != null) {
            builder.header(new Object[]{"Transaction-Id", getAccountSettingsOptions.transactionId()});
        }
        ResponseConverter responseConverter = ResponseConverterUtils.getValue((Type)new TypeToken<AccountSettings>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<OperationsList> listAvailableServiceOperations(ListAvailableServiceOperationsOptions listAvailableServiceOperationsOptions) {
        Validator.notNull((Object)((Object)listAvailableServiceOperationsOptions), (String)"listAvailableServiceOperationsOptions cannot be null");
        RequestBuilder builder = RequestBuilder.get((HttpUrl)RequestBuilder.resolveRequestUrl((String)this.getServiceUrl(), (String)"/v1/operations"));
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)DEFAULT_SERVICE_NAME, (String)"v1", (String)"listAvailableServiceOperations");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        builder.header(new Object[]{"Accept", "application/json"});
        if (listAvailableServiceOperationsOptions.xCorrelationId() != null) {
            builder.header(new Object[]{"X-Correlation-Id", listAvailableServiceOperationsOptions.xCorrelationId()});
        }
        if (listAvailableServiceOperationsOptions.transactionId() != null) {
            builder.header(new Object[]{"Transaction-Id", listAvailableServiceOperationsOptions.transactionId()});
        }
        builder.query(new Object[]{"service_name", String.valueOf(listAvailableServiceOperationsOptions.serviceName())});
        ResponseConverter responseConverter = ResponseConverterUtils.getValue((Type)new TypeToken<OperationsList>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }
}

