/*
 * (C) Copyright IBM Corp. 2020.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License is distributed on
 * an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the License for the
 * specific language governing permissions and limitations under the License.
 */
package com.ibm.cloud.networking.caching_api.v1.model;

import com.ibm.cloud.sdk.core.service.model.GenericModel;

/**
 * The updateBrowserCacheTtl options.
 */
public class UpdateBrowserCacheTtlOptions extends GenericModel {

  protected Long value;

  /**
   * Builder.
   */
  public static class Builder {
    private Long value;

    private Builder(UpdateBrowserCacheTtlOptions updateBrowserCacheTtlOptions) {
      this.value = updateBrowserCacheTtlOptions.value;
    }

    /**
     * Instantiates a new builder.
     */
    public Builder() {
    }

    /**
     * Builds a UpdateBrowserCacheTtlOptions.
     *
     * @return the new UpdateBrowserCacheTtlOptions instance
     */
    public UpdateBrowserCacheTtlOptions build() {
      return new UpdateBrowserCacheTtlOptions(this);
    }

    /**
     * Set the value.
     *
     * @param value the value
     * @return the UpdateBrowserCacheTtlOptions builder
     */
    public Builder value(long value) {
      this.value = value;
      return this;
    }
  }

  protected UpdateBrowserCacheTtlOptions(Builder builder) {
    value = builder.value;
  }

  /**
   * New builder.
   *
   * @return a UpdateBrowserCacheTtlOptions builder
   */
  public Builder newBuilder() {
    return new Builder(this);
  }

  /**
   * Gets the value.
   *
   * ttl value.
   *
   * @return the value
   */
  public Long value() {
    return value;
  }
}

