/*
 * (C) Copyright IBM Corp. 2020.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License is distributed on
 * an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the License for the
 * specific language governing permissions and limitations under the License.
 */
package com.ibm.cloud.networking.caching_api.v1.model;

import com.google.gson.annotations.SerializedName;
import com.ibm.cloud.sdk.core.service.model.GenericModel;

/**
 * result object.
 */
public class DeveopmentModeResponseResult extends GenericModel {

  protected String id;
  protected String value;
  protected Boolean editable;
  @SerializedName("modified_on")
  protected String modifiedOn;

  /**
   * Gets the id.
   *
   * object id.
   *
   * @return the id
   */
  public String getId() {
    return id;
  }

  /**
   * Gets the value.
   *
   * on/off value.
   *
   * @return the value
   */
  public String getValue() {
    return value;
  }

  /**
   * Gets the editable.
   *
   * editable value.
   *
   * @return the editable
   */
  public Boolean isEditable() {
    return editable;
  }

  /**
   * Gets the modifiedOn.
   *
   * modified date.
   *
   * @return the modifiedOn
   */
  public String getModifiedOn() {
    return modifiedOn;
  }
}

