/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cloud.networking.caching_api.v1;

import com.google.gson.JsonObject;
import com.google.gson.reflect.TypeToken;
import com.ibm.cloud.networking.caching_api.v1.model.BrowserTTLResponse;
import com.ibm.cloud.networking.caching_api.v1.model.CacheLevelResponse;
import com.ibm.cloud.networking.caching_api.v1.model.DeveopmentModeResponse;
import com.ibm.cloud.networking.caching_api.v1.model.EnableQueryStringSortResponse;
import com.ibm.cloud.networking.caching_api.v1.model.GetBrowserCacheTtlOptions;
import com.ibm.cloud.networking.caching_api.v1.model.GetCacheLevelOptions;
import com.ibm.cloud.networking.caching_api.v1.model.GetDevelopmentModeOptions;
import com.ibm.cloud.networking.caching_api.v1.model.GetQueryStringSortOptions;
import com.ibm.cloud.networking.caching_api.v1.model.PurgeAllOptions;
import com.ibm.cloud.networking.caching_api.v1.model.PurgeAllResponse;
import com.ibm.cloud.networking.caching_api.v1.model.PurgeByCacheTagsOptions;
import com.ibm.cloud.networking.caching_api.v1.model.PurgeByHostsOptions;
import com.ibm.cloud.networking.caching_api.v1.model.PurgeByUrlsOptions;
import com.ibm.cloud.networking.caching_api.v1.model.UpdateBrowserCacheTtlOptions;
import com.ibm.cloud.networking.caching_api.v1.model.UpdateCacheLevelOptions;
import com.ibm.cloud.networking.caching_api.v1.model.UpdateDevelopmentModeOptions;
import com.ibm.cloud.networking.caching_api.v1.model.UpdateQueryStringSortOptions;
import com.ibm.cloud.networking.common.SdkCommon;
import com.ibm.cloud.sdk.core.http.RequestBuilder;
import com.ibm.cloud.sdk.core.http.ResponseConverter;
import com.ibm.cloud.sdk.core.http.ServiceCall;
import com.ibm.cloud.sdk.core.security.Authenticator;
import com.ibm.cloud.sdk.core.security.ConfigBasedAuthenticatorFactory;
import com.ibm.cloud.sdk.core.service.BaseService;
import com.ibm.cloud.sdk.core.util.GsonSingleton;
import com.ibm.cloud.sdk.core.util.ResponseConverterUtils;
import com.ibm.cloud.sdk.core.util.Validator;
import java.lang.reflect.Type;
import java.util.Map;
import okhttp3.HttpUrl;

public class CachingApi
extends BaseService {
    public static final String DEFAULT_SERVICE_NAME = "caching_api";
    public static final String DEFAULT_SERVICE_URL = "https://api.cis.cloud.ibm.com";
    private String crn;
    private String zoneId;

    public static CachingApi newInstance(String crn, String zoneId) {
        return CachingApi.newInstance(crn, zoneId, DEFAULT_SERVICE_NAME);
    }

    public static CachingApi newInstance(String crn, String zoneId, String serviceName) {
        Authenticator authenticator = ConfigBasedAuthenticatorFactory.getAuthenticator((String)serviceName);
        CachingApi service = new CachingApi(crn, zoneId, serviceName, authenticator);
        service.configureService(serviceName);
        return service;
    }

    public CachingApi(String crn, String zoneId, String serviceName, Authenticator authenticator) {
        super(serviceName, authenticator);
        this.setServiceUrl(DEFAULT_SERVICE_URL);
        this.setCrn(crn);
        this.setZoneId(zoneId);
    }

    public String getCrn() {
        return this.crn;
    }

    public void setCrn(String crn) {
        Validator.notEmpty((String)crn, (String)"crn cannot be empty.");
        this.crn = crn;
    }

    public String getZoneId() {
        return this.zoneId;
    }

    public void setZoneId(String zoneId) {
        Validator.notEmpty((String)zoneId, (String)"zoneId cannot be empty.");
        this.zoneId = zoneId;
    }

    public ServiceCall<PurgeAllResponse> purgeAll(PurgeAllOptions purgeAllOptions) {
        String[] pathSegments = new String[]{"v1", "zones", "purge_cache/purge_all"};
        String[] pathParameters = new String[]{this.crn, this.zoneId};
        RequestBuilder builder = RequestBuilder.put((HttpUrl)RequestBuilder.constructHttpUrl((String)this.getServiceUrl(), (String[])pathSegments, (String[])pathParameters));
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)DEFAULT_SERVICE_NAME, (String)"v1", (String)"purgeAll");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        builder.header(new Object[]{"Accept", "application/json"});
        ResponseConverter responseConverter = ResponseConverterUtils.getValue((Type)new TypeToken<PurgeAllResponse>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<PurgeAllResponse> purgeAll() {
        return this.purgeAll(null);
    }

    public ServiceCall<PurgeAllResponse> purgeByUrls(PurgeByUrlsOptions purgeByUrlsOptions) {
        boolean skipBody = false;
        if (purgeByUrlsOptions == null) {
            purgeByUrlsOptions = new PurgeByUrlsOptions.Builder().build();
            skipBody = true;
        }
        String[] pathSegments = new String[]{"v1", "zones", "purge_cache/purge_by_urls"};
        String[] pathParameters = new String[]{this.crn, this.zoneId};
        RequestBuilder builder = RequestBuilder.put((HttpUrl)RequestBuilder.constructHttpUrl((String)this.getServiceUrl(), (String[])pathSegments, (String[])pathParameters));
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)DEFAULT_SERVICE_NAME, (String)"v1", (String)"purgeByUrls");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        builder.header(new Object[]{"Accept", "application/json"});
        if (!skipBody) {
            JsonObject contentJson = new JsonObject();
            if (purgeByUrlsOptions.files() != null) {
                contentJson.add("files", GsonSingleton.getGson().toJsonTree(purgeByUrlsOptions.files()));
            }
            builder.bodyJson(contentJson);
        }
        ResponseConverter responseConverter = ResponseConverterUtils.getValue((Type)new TypeToken<PurgeAllResponse>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<PurgeAllResponse> purgeByUrls() {
        return this.purgeByUrls(null);
    }

    public ServiceCall<PurgeAllResponse> purgeByCacheTags(PurgeByCacheTagsOptions purgeByCacheTagsOptions) {
        boolean skipBody = false;
        if (purgeByCacheTagsOptions == null) {
            purgeByCacheTagsOptions = new PurgeByCacheTagsOptions.Builder().build();
            skipBody = true;
        }
        String[] pathSegments = new String[]{"v1", "zones", "purge_cache/purge_by_cache_tags"};
        String[] pathParameters = new String[]{this.crn, this.zoneId};
        RequestBuilder builder = RequestBuilder.put((HttpUrl)RequestBuilder.constructHttpUrl((String)this.getServiceUrl(), (String[])pathSegments, (String[])pathParameters));
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)DEFAULT_SERVICE_NAME, (String)"v1", (String)"purgeByCacheTags");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        builder.header(new Object[]{"Accept", "application/json"});
        if (!skipBody) {
            JsonObject contentJson = new JsonObject();
            if (purgeByCacheTagsOptions.tags() != null) {
                contentJson.add("tags", GsonSingleton.getGson().toJsonTree(purgeByCacheTagsOptions.tags()));
            }
            builder.bodyJson(contentJson);
        }
        ResponseConverter responseConverter = ResponseConverterUtils.getValue((Type)new TypeToken<PurgeAllResponse>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<PurgeAllResponse> purgeByCacheTags() {
        return this.purgeByCacheTags(null);
    }

    public ServiceCall<PurgeAllResponse> purgeByHosts(PurgeByHostsOptions purgeByHostsOptions) {
        boolean skipBody = false;
        if (purgeByHostsOptions == null) {
            purgeByHostsOptions = new PurgeByHostsOptions.Builder().build();
            skipBody = true;
        }
        String[] pathSegments = new String[]{"v1", "zones", "purge_cache/purge_by_hosts"};
        String[] pathParameters = new String[]{this.crn, this.zoneId};
        RequestBuilder builder = RequestBuilder.put((HttpUrl)RequestBuilder.constructHttpUrl((String)this.getServiceUrl(), (String[])pathSegments, (String[])pathParameters));
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)DEFAULT_SERVICE_NAME, (String)"v1", (String)"purgeByHosts");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        builder.header(new Object[]{"Accept", "application/json"});
        if (!skipBody) {
            JsonObject contentJson = new JsonObject();
            if (purgeByHostsOptions.hosts() != null) {
                contentJson.add("hosts", GsonSingleton.getGson().toJsonTree(purgeByHostsOptions.hosts()));
            }
            builder.bodyJson(contentJson);
        }
        ResponseConverter responseConverter = ResponseConverterUtils.getValue((Type)new TypeToken<PurgeAllResponse>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<PurgeAllResponse> purgeByHosts() {
        return this.purgeByHosts(null);
    }

    public ServiceCall<BrowserTTLResponse> getBrowserCacheTtl(GetBrowserCacheTtlOptions getBrowserCacheTtlOptions) {
        String[] pathSegments = new String[]{"v1", "zones", "settings/browser_cache_ttl"};
        String[] pathParameters = new String[]{this.crn, this.zoneId};
        RequestBuilder builder = RequestBuilder.get((HttpUrl)RequestBuilder.constructHttpUrl((String)this.getServiceUrl(), (String[])pathSegments, (String[])pathParameters));
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)DEFAULT_SERVICE_NAME, (String)"v1", (String)"getBrowserCacheTtl");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        builder.header(new Object[]{"Accept", "application/json"});
        ResponseConverter responseConverter = ResponseConverterUtils.getValue((Type)new TypeToken<BrowserTTLResponse>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<BrowserTTLResponse> getBrowserCacheTtl() {
        return this.getBrowserCacheTtl(null);
    }

    public ServiceCall<BrowserTTLResponse> updateBrowserCacheTtl(UpdateBrowserCacheTtlOptions updateBrowserCacheTtlOptions) {
        boolean skipBody = false;
        if (updateBrowserCacheTtlOptions == null) {
            updateBrowserCacheTtlOptions = new UpdateBrowserCacheTtlOptions.Builder().build();
            skipBody = true;
        }
        String[] pathSegments = new String[]{"v1", "zones", "settings/browser_cache_ttl"};
        String[] pathParameters = new String[]{this.crn, this.zoneId};
        RequestBuilder builder = RequestBuilder.patch((HttpUrl)RequestBuilder.constructHttpUrl((String)this.getServiceUrl(), (String[])pathSegments, (String[])pathParameters));
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)DEFAULT_SERVICE_NAME, (String)"v1", (String)"updateBrowserCacheTtl");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        builder.header(new Object[]{"Accept", "application/json"});
        if (!skipBody) {
            JsonObject contentJson = new JsonObject();
            if (updateBrowserCacheTtlOptions.value() != null) {
                contentJson.addProperty("value", (Number)updateBrowserCacheTtlOptions.value());
            }
            builder.bodyJson(contentJson);
        }
        ResponseConverter responseConverter = ResponseConverterUtils.getValue((Type)new TypeToken<BrowserTTLResponse>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<BrowserTTLResponse> updateBrowserCacheTtl() {
        return this.updateBrowserCacheTtl(null);
    }

    public ServiceCall<DeveopmentModeResponse> getDevelopmentMode(GetDevelopmentModeOptions getDevelopmentModeOptions) {
        String[] pathSegments = new String[]{"v1", "zones", "settings/development_mode"};
        String[] pathParameters = new String[]{this.crn, this.zoneId};
        RequestBuilder builder = RequestBuilder.get((HttpUrl)RequestBuilder.constructHttpUrl((String)this.getServiceUrl(), (String[])pathSegments, (String[])pathParameters));
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)DEFAULT_SERVICE_NAME, (String)"v1", (String)"getDevelopmentMode");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        builder.header(new Object[]{"Accept", "application/json"});
        ResponseConverter responseConverter = ResponseConverterUtils.getValue((Type)new TypeToken<DeveopmentModeResponse>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<DeveopmentModeResponse> getDevelopmentMode() {
        return this.getDevelopmentMode(null);
    }

    public ServiceCall<DeveopmentModeResponse> updateDevelopmentMode(UpdateDevelopmentModeOptions updateDevelopmentModeOptions) {
        boolean skipBody = false;
        if (updateDevelopmentModeOptions == null) {
            updateDevelopmentModeOptions = new UpdateDevelopmentModeOptions.Builder().build();
            skipBody = true;
        }
        String[] pathSegments = new String[]{"v1", "zones", "settings/development_mode"};
        String[] pathParameters = new String[]{this.crn, this.zoneId};
        RequestBuilder builder = RequestBuilder.patch((HttpUrl)RequestBuilder.constructHttpUrl((String)this.getServiceUrl(), (String[])pathSegments, (String[])pathParameters));
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)DEFAULT_SERVICE_NAME, (String)"v1", (String)"updateDevelopmentMode");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        builder.header(new Object[]{"Accept", "application/json"});
        if (!skipBody) {
            JsonObject contentJson = new JsonObject();
            if (updateDevelopmentModeOptions.value() != null) {
                contentJson.addProperty("value", updateDevelopmentModeOptions.value());
            }
            builder.bodyJson(contentJson);
        }
        ResponseConverter responseConverter = ResponseConverterUtils.getValue((Type)new TypeToken<DeveopmentModeResponse>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<DeveopmentModeResponse> updateDevelopmentMode() {
        return this.updateDevelopmentMode(null);
    }

    public ServiceCall<EnableQueryStringSortResponse> getQueryStringSort(GetQueryStringSortOptions getQueryStringSortOptions) {
        String[] pathSegments = new String[]{"v1", "zones", "settings/sort_query_string_for_cache"};
        String[] pathParameters = new String[]{this.crn, this.zoneId};
        RequestBuilder builder = RequestBuilder.get((HttpUrl)RequestBuilder.constructHttpUrl((String)this.getServiceUrl(), (String[])pathSegments, (String[])pathParameters));
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)DEFAULT_SERVICE_NAME, (String)"v1", (String)"getQueryStringSort");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        builder.header(new Object[]{"Accept", "application/json"});
        ResponseConverter responseConverter = ResponseConverterUtils.getValue((Type)new TypeToken<EnableQueryStringSortResponse>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<EnableQueryStringSortResponse> getQueryStringSort() {
        return this.getQueryStringSort(null);
    }

    public ServiceCall<EnableQueryStringSortResponse> updateQueryStringSort(UpdateQueryStringSortOptions updateQueryStringSortOptions) {
        boolean skipBody = false;
        if (updateQueryStringSortOptions == null) {
            updateQueryStringSortOptions = new UpdateQueryStringSortOptions.Builder().build();
            skipBody = true;
        }
        String[] pathSegments = new String[]{"v1", "zones", "settings/sort_query_string_for_cache"};
        String[] pathParameters = new String[]{this.crn, this.zoneId};
        RequestBuilder builder = RequestBuilder.patch((HttpUrl)RequestBuilder.constructHttpUrl((String)this.getServiceUrl(), (String[])pathSegments, (String[])pathParameters));
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)DEFAULT_SERVICE_NAME, (String)"v1", (String)"updateQueryStringSort");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        builder.header(new Object[]{"Accept", "application/json"});
        if (!skipBody) {
            JsonObject contentJson = new JsonObject();
            if (updateQueryStringSortOptions.value() != null) {
                contentJson.addProperty("value", updateQueryStringSortOptions.value());
            }
            builder.bodyJson(contentJson);
        }
        ResponseConverter responseConverter = ResponseConverterUtils.getValue((Type)new TypeToken<EnableQueryStringSortResponse>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<EnableQueryStringSortResponse> updateQueryStringSort() {
        return this.updateQueryStringSort(null);
    }

    public ServiceCall<CacheLevelResponse> getCacheLevel(GetCacheLevelOptions getCacheLevelOptions) {
        String[] pathSegments = new String[]{"v1", "zones", "settings/cache_level"};
        String[] pathParameters = new String[]{this.crn, this.zoneId};
        RequestBuilder builder = RequestBuilder.get((HttpUrl)RequestBuilder.constructHttpUrl((String)this.getServiceUrl(), (String[])pathSegments, (String[])pathParameters));
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)DEFAULT_SERVICE_NAME, (String)"v1", (String)"getCacheLevel");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        builder.header(new Object[]{"Accept", "application/json"});
        ResponseConverter responseConverter = ResponseConverterUtils.getValue((Type)new TypeToken<CacheLevelResponse>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<CacheLevelResponse> getCacheLevel() {
        return this.getCacheLevel(null);
    }

    public ServiceCall<CacheLevelResponse> updateCacheLevel(UpdateCacheLevelOptions updateCacheLevelOptions) {
        boolean skipBody = false;
        if (updateCacheLevelOptions == null) {
            updateCacheLevelOptions = new UpdateCacheLevelOptions.Builder().build();
            skipBody = true;
        }
        String[] pathSegments = new String[]{"v1", "zones", "settings/cache_level"};
        String[] pathParameters = new String[]{this.crn, this.zoneId};
        RequestBuilder builder = RequestBuilder.patch((HttpUrl)RequestBuilder.constructHttpUrl((String)this.getServiceUrl(), (String[])pathSegments, (String[])pathParameters));
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)DEFAULT_SERVICE_NAME, (String)"v1", (String)"updateCacheLevel");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        builder.header(new Object[]{"Accept", "application/json"});
        if (!skipBody) {
            JsonObject contentJson = new JsonObject();
            if (updateCacheLevelOptions.value() != null) {
                contentJson.addProperty("value", updateCacheLevelOptions.value());
            }
            builder.bodyJson(contentJson);
        }
        ResponseConverter responseConverter = ResponseConverterUtils.getValue((Type)new TypeToken<CacheLevelResponse>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<CacheLevelResponse> updateCacheLevel() {
        return this.updateCacheLevel(null);
    }
}

