/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cfenv.spring.boot.eventstreams;

import io.pivotal.cfenv.core.CfCredentials;
import io.pivotal.cfenv.core.CfService;
import io.pivotal.cfenv.spring.boot.CfEnvProcessor;
import io.pivotal.cfenv.spring.boot.CfEnvProcessorProperties;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import java.util.stream.Collectors;

public class EventStreamsCfEnvProcessor
implements CfEnvProcessor {
    private static final Logger LOG = Logger.getLogger(EventStreamsCfEnvProcessor.class.getName());

    public boolean accept(CfService service) {
        boolean match = service.existsByLabelStartsWith("messagehub");
        LOG.info("Match [" + match + "] to service " + service.toString());
        return match;
    }

    public void process(CfCredentials cfCredentials, Map<String, Object> properties) {
        List kafka_brokers_sasl = (List)cfCredentials.getMap().get("kafka_brokers_sasl");
        String brokers = kafka_brokers_sasl.stream().collect(Collectors.joining(","));
        String password = cfCredentials.getPassword();
        properties.put("ibm.spring.event-streams.password", password);
        properties.put("spring.kafka.bootstrap-servers", brokers);
    }

    public CfEnvProcessorProperties getProperties() {
        return CfEnvProcessorProperties.builder().serviceName("event-streams").propertyPrefixes("ibm.spring.event-streams,spring.kafka").build();
    }
}

