/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cfenv.spring.boot.amqp;

import com.ibm.beancustomizer.config.BeanCustomizer;
import com.rabbitmq.client.ConnectionFactory;
import java.util.HashMap;
import java.util.Map;
import javax.net.ssl.SSLContext;
import org.springframework.amqp.rabbit.connection.CachingConnectionFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class AmqpSSLContextBeanCustomizer
implements BeanCustomizer<CachingConnectionFactory> {
    private final Map<String, SSLContext> sslContexts;

    @Autowired(required=false)
    public AmqpSSLContextBeanCustomizer(Map<String, SSLContext> sslContexts) {
        this.sslContexts = sslContexts == null ? new HashMap<String, SSLContext>() : sslContexts;
    }

    public CachingConnectionFactory postProcessBeforeInit(CachingConnectionFactory cachingConnectionFactory) {
        SSLContext sslContext = this.sslContexts.get("amqp");
        if (sslContext != null) {
            ConnectionFactory connectionFactory = cachingConnectionFactory.getRabbitConnectionFactory();
            connectionFactory.useSslProtocol(sslContext);
            connectionFactory.enableHostnameVerification();
        }
        return cachingConnectionFactory;
    }

    public CachingConnectionFactory postProcessAfterInit(CachingConnectionFactory original) {
        return original;
    }

    public boolean accepts(Object bean, String beanName) {
        return bean instanceof CachingConnectionFactory;
    }
}

