/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cfenv.spring.boot.amqp;

import io.pivotal.cfenv.core.CfCredentials;
import io.pivotal.cfenv.core.CfService;
import io.pivotal.cfenv.spring.boot.CfEnvProcessor;
import io.pivotal.cfenv.spring.boot.CfEnvProcessorProperties;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AmqpCfEnvProcessor
implements CfEnvProcessor {
    private static final Logger logger = LoggerFactory.getLogger(AmqpCfEnvProcessor.class);

    public boolean accept(CfService service) {
        return service.existsByLabelStartsWith("messages-for-rabbitmq");
    }

    public void process(CfCredentials cfCredentials, Map<String, Object> properties) {
        Map credentialsData = cfCredentials.getMap();
        Map connection = (Map)credentialsData.get("connection");
        Map amqps = (Map)connection.get("amqps");
        List hosts = (List)amqps.get("hosts");
        Map host = (Map)hosts.get(0);
        String hostname = (String)host.get("hostname");
        int port = (Integer)host.get("port");
        properties.put("spring.rabbitmq.host", hostname);
        properties.put("spring.rabbitmq.port", port);
        Map authentication = (Map)amqps.get("authentication");
        String password = (String)authentication.get("password");
        String username = (String)authentication.get("username");
        properties.put("spring.rabbitmq.password", password);
        properties.put("spring.rabbitmq.username", username);
        Map certificate = (Map)amqps.get("certificate");
        String certificate_base64 = (String)certificate.get("certificate_base64");
        if (certificate_base64 == null) {
            logger.error("Base64 cert cannot be null amqps = [{}]", (Object)amqps);
            throw new IllegalStateException("Base64 cert cannot be null");
        }
        properties.put("sslcontext.contexts.amqp.trustedcert", certificate_base64);
    }

    public CfEnvProcessorProperties getProperties() {
        return CfEnvProcessorProperties.builder().propertyPrefixes("sslcontext,spring.rabbitmq").serviceName("rabbitMQ").build();
    }
}

