/*
 * Decompiled with CFR 0.152.
 */
package jsr352.tck.specialized;

import java.util.ArrayList;
import javax.batch.annotation.BatchProperty;
import javax.batch.annotation.CheckpointInfo;
import javax.batch.annotation.Close;
import javax.batch.annotation.ItemWriter;
import javax.batch.annotation.Open;
import javax.batch.annotation.WriteItems;
import javax.inject.Named;
import jsr352.tck.chunktypes.ArrayIndexCheckpointData;
import jsr352.tck.chunktypes.ReadRecord;
import jsr352.tck.reusable.MyParentException;

@ItemWriter(value="SkipWriter")
@Named(value="SkipWriter")
public class SkipWriter {
    private int[] writerDataArray = new int[30];
    private int idx = 0;
    private int chkArraySize;
    int chunkWriteIteration = 0;
    @BatchProperty(name="app.arraysize")
    String appArraySizeString;
    @BatchProperty(name="writerecord.fail")
    String writeRecordFailNumberString = null;
    int arraysize;
    int[] failnum;
    int[] writePoints;

    @Open
    public void openWriter(ArrayIndexCheckpointData checkpointData) throws Exception {
        System.out.println("openWriter");
        this.arraysize = Integer.parseInt(this.appArraySizeString);
        if (!this.writeRecordFailNumberString.equals("null")) {
            String[] writeFailPointsStrArr = this.writeRecordFailNumberString.split(",");
            this.failnum = new int[writeFailPointsStrArr.length];
            for (int i = 0; i < writeFailPointsStrArr.length; ++i) {
                this.failnum[i] = Integer.parseInt(writeFailPointsStrArr[i]);
            }
        } else {
            this.failnum = new int[1];
            this.failnum[0] = -1;
        }
        if (checkpointData == null) {
            this.idx = 0;
            System.out.println("WRITE: chkpt data = null, so idx = " + this.idx);
        } else {
            this.idx = checkpointData.getCurrentIndex();
            System.out.println("WRITE: chkpt data was valid, so idx = " + this.idx);
            System.out.println("WRITE: chunkWriteIteration = " + this.chunkWriteIteration);
        }
        for (int i = 0; i < this.arraysize; ++i) {
            this.writerDataArray[i] = 0;
        }
    }

    @Close
    public void closeWriter() throws Exception {
        for (int i = 0; i < this.arraysize; ++i) {
            System.out.println("WRITE: writerDataArray[" + i + "] = " + this.writerDataArray[i]);
        }
    }

    @WriteItems
    public void writeMyData(ArrayList<ReadRecord> myData) throws Exception {
        int i;
        System.out.println("writeMyData receives chunk size=" + myData.size());
        System.out.println("WRITE: before writing, idx = " + this.idx);
        System.out.println("WRITE: before writing, chunkWriteIteration = " + this.chunkWriteIteration);
        ++this.chunkWriteIteration;
        for (i = 0; i < myData.size(); ++i) {
            if (this.isFailnum(i)) {
                System.out.println("WRITE: got the fail num..." + this.failnum);
                throw new MyParentException("fail on purpose on idx = " + this.failnum);
            }
            this.writerDataArray[this.idx] = myData.get(i).getCount();
            ++this.idx;
        }
        for (i = 0; i < this.arraysize; ++i) {
            System.out.println("WRITE: writerDataArray[" + i + "] = " + this.writerDataArray[i]);
        }
        System.out.println("WRITE: idx = " + this.idx + " and i = " + i);
        System.out.println("WRITE: chunkWriteIteration= " + this.chunkWriteIteration);
    }

    @CheckpointInfo
    public ArrayIndexCheckpointData getCPD() throws Exception {
        ArrayIndexCheckpointData _chkptData = new ArrayIndexCheckpointData();
        _chkptData.setCurrentIndex(this.idx);
        return _chkptData;
    }

    private boolean isFailnum(int idxIn) {
        boolean ans = false;
        for (int i = 0; i < this.failnum.length; ++i) {
            if (idxIn != this.failnum[i]) continue;
            ans = true;
        }
        return ans;
    }
}

