/*
 * Decompiled with CFR 0.152.
 */
package jsr352.tck.specialized;

import java.io.Externalizable;
import java.util.Date;
import java.util.logging.Logger;
import javax.batch.annotation.AfterCheckpoint;
import javax.batch.annotation.BatchContext;
import javax.batch.annotation.BatchProperty;
import javax.batch.annotation.BeforeCheckpoint;
import javax.batch.annotation.CheckpointListener;
import javax.batch.runtime.context.StepContext;
import javax.inject.Named;
import jsr352.tck.specialized.MyCustomCheckpointListener;

@CheckpointListener(value="MyTimeCheckpointListener")
@Named(value="MyTimeCheckpointListener")
public class MyTimeCheckpointListener {
    private static final String sourceClass = MyCustomCheckpointListener.class.getName();
    private static final Logger logger = Logger.getLogger(sourceClass);
    Date date = new Date();
    long ts = this.date.getTime();
    int timeinterval;
    @BatchProperty(name="timeinterval")
    String timeintervalString;
    @BatchContext
    StepContext<Integer, Externalizable> stepCtx;

    public MyTimeCheckpointListener() {
        System.out.println("TIMECHKPTLISTENER: in ctor, ts = " + this.ts);
    }

    @BeforeCheckpoint
    public void before() {
        System.out.println("TIMECHKPTLISTENER: beforeCheckpoint");
        this.timeinterval = Integer.parseInt(this.timeintervalString);
        System.out.println("TIMECHKPTLISTENER: got the timeinterval: " + this.timeinterval);
        Date curDate = new Date();
        long curts = curDate.getTime();
        long curdiff = curts - this.ts;
        int diff = (int)curdiff / 1000;
        if (diff <= this.timeinterval + 1 || diff >= this.timeinterval - 1) {
            System.out.println("TIMECHKPTLISTENER: the chunk write is occuring at the correct time -> " + diff + " which is: " + this.timeinterval + " +/- 1 second");
        } else {
            System.out.println("TIMECHKPTLISTENER: we have an issue! throw exception here");
        }
    }

    @AfterCheckpoint
    public void after() {
        System.out.println("CHKPTLISTENER: afterCheckpoint");
        this.date = new Date();
        this.ts = this.date.getTime();
    }
}

