/*
 * Decompiled with CFR 0.152.
 */
package jsr352.tck.specialized;

import java.util.logging.Logger;
import javax.batch.annotation.BatchContext;
import javax.batch.annotation.OnSkipProcessItem;
import javax.batch.annotation.OnSkipReadItem;
import javax.batch.annotation.OnSkipWriteItem;
import javax.batch.annotation.SkipListener;
import javax.batch.runtime.context.JobContext;
import javax.batch.runtime.context.StepContext;
import javax.inject.Named;
import jsr352.tck.chunktypes.ReadRecord;
import jsr352.tck.reusable.MyParentException;
import jsr352.tck.specialized.MySkipAndStepListener;

@SkipListener(value="MySkipListener")
@Named(value="MySkipListener")
public class MySkipListener {
    @BatchContext
    JobContext jobCtx;
    @BatchContext
    StepContext stepCtx;
    private static final String sourceClass = MySkipAndStepListener.class.getName();
    private static final Logger logger = Logger.getLogger(sourceClass);
    public static final String GOOD_EXIT_STATUS = "GOOD STATUS";
    public static final String BAD_EXIT_STATUS = "BAD STATUS";

    @OnSkipReadItem
    public void onSkipRead(Exception e) {
        logger.fine("In onSkipRead()" + e);
        if (e instanceof MyParentException) {
            logger.finer("SKIPLISTENER: onSkipRead, exception is an instance of: MyParentException");
            this.jobCtx.setExitStatus(GOOD_EXIT_STATUS);
            logger.fine("SKIPLISTENER: onSkipRead, exception is an instance of: MyParentException");
        } else {
            System.out.println("SKIPLISTENER: onSkipRead, exception is NOT an instance of: MyParentException");
            logger.fine("SKIPLISTENER: onSkipRead, exception is NOT an instance of: MyParentException");
        }
    }

    @OnSkipProcessItem
    public void onSkipProcess(Exception e, ReadRecord rec) {
        logger.fine("In onSkipProcess()" + e + "input=" + rec.getCount());
        if (e instanceof MyParentException) {
            logger.fine("SKIPLISTENER: onSkipProcess, exception is an instance of: MyParentException");
        } else {
            logger.fine("SKIPLISTENER: onSkipProcess, exception is NOT an instance of: MyParentException");
        }
    }

    @OnSkipWriteItem
    public void onSkipWrite(Exception e, ReadRecord rec) {
        logger.fine("In onSkipWrite()" + e + "input=" + rec.getCount());
        if (e instanceof MyParentException) {
            logger.fine("SKIPLISTENER: onSkipWrite, exception is an instance of: MyParentException");
        } else {
            logger.fine("SKIPLISTENER: onSkipWrite, exception is NOT an instance of: MyParentException");
        }
    }
}

