/*
 * Decompiled with CFR 0.152.
 */
package jsr352.tck.specialized;

import java.util.Random;
import java.util.logging.Logger;
import javax.batch.annotation.BatchContext;
import javax.batch.annotation.BatchProperty;
import javax.batch.annotation.Batchlet;
import javax.batch.annotation.Process;
import javax.batch.annotation.Stop;
import javax.batch.runtime.context.JobContext;
import javax.inject.Named;

@Batchlet(value="MyLongRunningBatchlet")
@Named(value="MyLongRunningBatchlet")
public class MyLongRunningBatchletImpl {
    @BatchContext
    JobContext<?> jobCtx;
    @BatchProperty(name="run.indefinitely")
    private String runIndefinitelyString = null;
    private boolean runIndefinitely = false;
    @BatchProperty(name="throw.exc.on.number.3")
    private String throwExcOnThreeString = null;
    private boolean throwExcOnThree = false;
    @BatchProperty(name="run.time")
    private String runTimeString;
    private static final String sourceClass = MyLongRunningBatchletImpl.class.getName();
    private static final Logger logger = Logger.getLogger(sourceClass);
    private volatile boolean stopped = false;

    private void begin() throws Exception {
        logger.fine("MyLongRunningBatchletImpl.begin()");
        if ("true".equalsIgnoreCase(this.runIndefinitelyString)) {
            this.runIndefinitely = true;
        }
        if ("true".equalsIgnoreCase(this.throwExcOnThreeString)) {
            this.throwExcOnThree = true;
        }
    }

    @Process
    public String process() throws Exception {
        logger.fine("MyLongRunningBatchLetImpl.process(); current ExitStatus = " + this.jobCtx.getExitStatus());
        this.begin();
        int i = 0;
        int numTimesToRun = 20;
        boolean maxTimesReached = false;
        while (!this.stopped) {
            logger.fine("i=" + i++);
            if (i == 3 && this.throwExcOnThree) {
                logger.fine("Throwing exception to confirm fail+restart handling on unchecked exceptions.");
                throw new RuntimeException("Throwing exception to confirm fail+restart handling on unchecked exceptions.");
            }
            for (int k = 0; k < 100; ++k) {
                Random r = new Random(k);
                r.nextInt();
            }
            if (this.runIndefinitely || i < numTimesToRun) continue;
            maxTimesReached = true;
            break;
        }
        if (maxTimesReached) {
            String currentExitStatus = this.jobCtx.getExitStatus();
            if (currentExitStatus != null) {
                this.jobCtx.setExitStatus("GOOD.STEP." + currentExitStatus);
            } else {
                this.jobCtx.setExitStatus("GOOD.STEP");
            }
            return "BATCHLET RAN TO COMPLETION";
        }
        this.jobCtx.setExitStatus("BATCHLET CANCELED BEFORE COMPLETION");
        return "BATCHLET CANCELED BEFORE COMPLETION";
    }

    @Stop
    public void cancel() throws Exception {
        logger.fine("MyLongRunningBatchLetImpl.cancel()");
        this.stopped = true;
    }
}

