/*
 * Decompiled with CFR 0.152.
 */
package jsr352.tck.specialized;

import java.util.Date;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.batch.annotation.BatchProperty;
import javax.batch.annotation.CheckpointAlgorithm;
import javax.batch.annotation.IsReadyToCheckpoint;
import javax.inject.Named;

@CheckpointAlgorithm(value="MyCustomCheckpointAlgorithm")
@Named(value="MyCustomCheckpointAlgorithm")
public class MyCustomCheckpointAlgorithm {
    private static final String className = MyCustomCheckpointAlgorithm.class.getName();
    private static Logger logger = Logger.getLogger(MyCustomCheckpointAlgorithm.class.getPackage().getName());
    boolean inCheckpoint = false;
    int checkpointIterations = 1;
    int threshold;
    long timeStarted = 0L;
    int requests;
    @BatchProperty(name="writepoints")
    String writePointsString;
    int[] writePoints;
    boolean init = false;

    public void init() {
        String[] writePointsStrArr = this.writePointsString.split(",");
        this.writePoints = new int[this.writePointsString.length()];
        for (int i = 0; i < writePointsStrArr.length; ++i) {
            this.writePoints[i] = Integer.parseInt(writePointsStrArr[i]);
            System.out.println("CUSTOMCHKPT: writePoints[" + i + "] = " + this.writePoints[i]);
        }
        this.threshold = this.writePoints[this.checkpointIterations];
        this.requests = this.writePoints[0];
        this.init = true;
    }

    @IsReadyToCheckpoint
    public boolean isReadyToCheckpoint() throws Exception {
        boolean ready;
        String method = "isReadyToCheckpoint";
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(className, method);
        }
        if (!this.init) {
            String[] writePointsStrArr = this.writePointsString.split(",");
            this.writePoints = new int[this.writePointsString.length()];
            for (int i = 0; i < writePointsStrArr.length; ++i) {
                System.out.println("CUSTOMCHKPT: writePointsStrArr[" + i + "] = " + writePointsStrArr[i]);
                this.writePoints[i] = Integer.parseInt(writePointsStrArr[i]);
                System.out.println("CUSTOMCHKPT: writePoints[" + i + "] = " + this.writePoints[i]);
            }
            this.threshold = this.writePoints[this.checkpointIterations];
            this.requests = this.writePoints[0];
            this.init = true;
        }
        ++this.requests;
        boolean bl = ready = this.requests >= this.threshold;
        if (ready) {
            ++this.checkpointIterations;
            this.threshold = this.writePoints[this.checkpointIterations];
            long millis = new Date().getTime() - this.timeStarted;
            if (millis > 0L) {
                String rate = Integer.valueOf(Long.valueOf((long)(this.requests * 1000) / millis).intValue()).toString();
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine(" - true [requests/second " + rate + "]");
                }
            } else if (logger.isLoggable(Level.FINE)) {
                logger.fine(" - true [requests " + this.requests + "]");
            }
        }
        return ready;
    }
}

