/*
 * Decompiled with CFR 0.152.
 */
package jsr352.tck.specialized;

import java.util.logging.Logger;
import javax.batch.annotation.AfterStep;
import javax.batch.annotation.BatchContext;
import javax.batch.annotation.BatchProperty;
import javax.batch.annotation.BeforeStep;
import javax.batch.annotation.StepListener;
import javax.batch.runtime.Metric;
import javax.batch.runtime.context.JobContext;
import javax.batch.runtime.context.StepContext;
import javax.inject.Named;
import jsr352.tck.specialized.MySkipAndStepListener;

@StepListener(value="MetricsStepListener")
@Named(value="MetricsStepListener")
public class MetricsStepListener {
    @BatchContext
    StepContext stepCtx;
    @BatchContext
    JobContext JobCtx;
    @BatchProperty(name="numberOfSkips")
    String skipNumberString;
    @BatchProperty(name="ReadProcessWrite")
    String RPWString;
    private static final String sourceClass = MySkipAndStepListener.class.getName();
    private static final Logger logger = Logger.getLogger(sourceClass);
    public static final String GOOD_EXIT_STATUS_READ = "GOOD READ METRICS RESULT";
    public static final String GOOD_EXIT_STATUS_PROCESS = "GOOD PROCESS METRICS RESULT";
    public static final String GOOD_EXIT_STATUS_WRITE = "GOOD PROCESS METRICS RESULT";
    public static final String GOOD_EXIT_STATUS = "GOOD METRICS RESULT";
    public static final String BAD_EXIT_STATUS = "BAD RESULT";
    int skipNum;

    @BeforeStep
    public void before() {
        logger.finer("In before()");
        this.skipNum = Integer.parseInt(this.skipNumberString);
    }

    @AfterStep
    public void after() {
        logger.finer("In after()");
        Metric[] metrics = this.stepCtx.getMetrics();
        for (int i = 0; i < metrics.length; ++i) {
            if (this.RPWString.equals("READ")) {
                if (!metrics[i].getName().equals("readCount")) continue;
                if (metrics[i].getValue() == 30L) {
                    this.JobCtx.setExitStatus(GOOD_EXIT_STATUS_READ);
                    continue;
                }
                this.JobCtx.setExitStatus(BAD_EXIT_STATUS);
                continue;
            }
            if (this.RPWString.equals("READ_SKIP")) {
                if (!metrics[i].getName().equals("readCount")) continue;
                if (metrics[i].getValue() == (long)(30 - this.skipNum)) {
                    this.JobCtx.setExitStatus(GOOD_EXIT_STATUS_READ);
                    continue;
                }
                this.JobCtx.setExitStatus(BAD_EXIT_STATUS);
                continue;
            }
            if (this.RPWString.equals("PROCESS")) {
                if (!metrics[i].getName().equals("processSkipCount")) continue;
                if (metrics[i].getValue() == (long)this.skipNum) {
                    this.JobCtx.setExitStatus("GOOD PROCESS METRICS RESULT");
                    continue;
                }
                this.JobCtx.setExitStatus(BAD_EXIT_STATUS);
                continue;
            }
            if (!this.RPWString.equals("WRITE") || !metrics[i].getName().equals("writeCount")) continue;
            if (metrics[i].getValue() == (long)(30 - this.skipNum)) {
                this.JobCtx.setExitStatus(GOOD_EXIT_STATUS);
                continue;
            }
            this.JobCtx.setExitStatus(BAD_EXIT_STATUS);
        }
    }
}

