/*
 * Decompiled with CFR 0.152.
 */
package jsr352.tck.specialized;

import java.util.ArrayList;
import javax.batch.annotation.BatchProperty;
import javax.batch.annotation.CheckpointInfo;
import javax.batch.annotation.Close;
import javax.batch.annotation.ItemWriter;
import javax.batch.annotation.Open;
import javax.batch.annotation.WriteItems;
import javax.inject.Named;
import jsr352.tck.chunktypes.ArrayIndexCheckpointData;
import jsr352.tck.chunktypes.ReadRecord;

@ItemWriter(value="DoSomethingSimpleArrayWriter")
@Named(value="DoSomethingSimpleArrayWriter")
public class DoSomethingSimpleArrayWriter {
    private int[] writerDataArray = new int[30];
    private int idx = 0;
    private int chkArraySize;
    int chunkWriteIteration = 0;
    @BatchProperty(name="app.arraysize")
    String appArraySizeString;
    @BatchProperty(name="app.writepoints")
    String writePointsString;
    int arraysize;
    int[] writePoints;

    @Open
    public void openWriter(ArrayIndexCheckpointData checkpointData) throws Exception {
        int i;
        System.out.println("openWriter");
        this.arraysize = Integer.parseInt(this.appArraySizeString);
        String[] writePointsStrArr = this.writePointsString.split(",");
        this.writePoints = new int[this.writePointsString.length()];
        System.out.println("AJM: writePointsStrArr.length() = " + writePointsStrArr.length);
        for (i = 0; i < writePointsStrArr.length; ++i) {
            System.out.println("AJM: writePointsStrArr[" + i + "] = " + writePointsStrArr[i]);
            this.writePoints[i] = Integer.parseInt(writePointsStrArr[i]);
            System.out.println("AJM: writePoints[" + i + "] = " + this.writePoints[i]);
        }
        if (checkpointData == null) {
            this.idx = 0;
            System.out.println("WRITE: chkpt data = null, so idx = " + this.idx);
        } else {
            this.idx = checkpointData.getCurrentIndex();
            System.out.println("WRITE: chkpt data was valid, so idx = " + this.idx);
            System.out.println("WRITE: chunkWriteIteration = " + this.chunkWriteIteration);
        }
        for (i = 0; i < this.arraysize; ++i) {
            this.writerDataArray[i] = 0;
        }
    }

    @Close
    public void closeWriter() throws Exception {
        for (int i = 0; i < this.arraysize; ++i) {
            System.out.println("WRITE: writerDataArray[" + i + "] = " + this.writerDataArray[i]);
        }
    }

    @WriteItems
    public void writeMyData(ArrayList<ReadRecord> myData) throws Exception {
        int i;
        System.out.println("writeMyData receives chunk size=" + myData.size());
        System.out.println("WRITE: before writing, idx = " + this.idx);
        System.out.println("WRITE: before writing, chunkWriteIteration = " + this.chunkWriteIteration);
        if (this.writePoints[this.chunkWriteIteration] != this.idx) {
            System.out.println("WRITE: we have an issue! throw exception here");
            throw new Exception("WRITE: the chunk write did not at the correct boundry (idx) ->" + this.idx);
        }
        System.out.println("WRITE: the chunk write is occuring at the correct boundry (idx) ->" + this.idx);
        ++this.chunkWriteIteration;
        for (i = 0; i < myData.size(); ++i) {
            this.writerDataArray[this.idx] = myData.get(i).getCount();
            ++this.idx;
        }
        for (i = 0; i < this.arraysize; ++i) {
            System.out.println("WRITE: writerDataArray[" + i + "] = " + this.writerDataArray[i]);
        }
        System.out.println("WRITE: idx = " + this.idx + " and i = " + i);
        System.out.println("WRITE: chunkWriteIteration= " + this.chunkWriteIteration);
        System.out.println("WRITE: size of writePoints->" + this.writePoints.length);
    }

    @CheckpointInfo
    public ArrayIndexCheckpointData getCPD() throws Exception {
        ArrayIndexCheckpointData _chkptData = new ArrayIndexCheckpointData();
        _chkptData.setCurrentIndex(this.idx);
        return _chkptData;
    }
}

