/*
 * Decompiled with CFR 0.152.
 */
package jsr352.tck.specialized;

import java.util.ArrayList;
import javax.batch.annotation.BatchProperty;
import javax.batch.annotation.CheckpointInfo;
import javax.batch.annotation.Close;
import javax.batch.annotation.ItemWriter;
import javax.batch.annotation.Open;
import javax.batch.annotation.WriteItems;
import javax.inject.Named;
import jsr352.tck.chunktypes.ArrayIndexCheckpointData;
import jsr352.tck.chunktypes.ReadRecord;

@ItemWriter(value="DoSomethingArrayItemWriter")
@Named(value="DoSomethingArrayItemWriter")
public class DoSomethingArrayItemWriterImpl {
    private int[] writerDataArray = new int[30];
    private int[] checkArray;
    private int idx = 0;
    private int chkArraySize;
    int chunkWriteIteration = 0;
    @BatchProperty(name="app.arraysize")
    String appArraySizeString;
    @BatchProperty(name="app.chunksize")
    String chunkSizeString;
    @BatchProperty(name="app.commitinterval")
    String commitintervalString;
    int arraysize;
    int chunksize;
    int commitinterval;

    @Open
    public void openWriter(ArrayIndexCheckpointData checkpointData) throws Exception {
        int i;
        System.out.println("openWriter");
        this.arraysize = Integer.parseInt(this.appArraySizeString);
        this.chunksize = Integer.parseInt(this.chunkSizeString);
        this.commitinterval = Integer.parseInt(this.commitintervalString);
        if (checkpointData == null) {
            this.idx = 0;
            System.out.println("WRITE: chkpt data = null, so idx = " + this.idx);
        } else {
            this.idx = checkpointData.getCurrentIndex();
            System.out.println("WRITE: chkpt data was valid, so idx = " + this.idx);
            System.out.println("WRITE: idx % chunksize =" + this.idx % this.chunksize);
            if (this.idx % this.chunksize == 0) {
                System.out.println("WRITE: the previous checkpoint was correct");
            }
        }
        if (this.commitinterval % this.chunksize == 0) {
            this.chkArraySize = this.idx == 0 ? this.round(this.arraysize, this.chunksize) + 1 : this.round(this.arraysize - this.idx, this.chunksize) + 1;
        } else if (this.commitinterval > this.chunksize) {
            if (this.idx == 0) {
                this.chkArraySize = this.round(this.arraysize, this.chunksize) + this.round(this.arraysize, this.commitinterval) + 1;
            } else {
                System.out.println("AJM: figuring out nthe array size, idx = " + this.idx);
                this.chkArraySize = this.round(this.arraysize - this.idx, this.chunksize) + this.round(this.arraysize - this.idx, this.commitinterval);
            }
        } else {
            this.chkArraySize = this.round(this.arraysize, this.commitinterval % this.chunksize) + 1;
        }
        this.checkArray = new int[this.chkArraySize];
        System.out.println("WRITE: check array size = " + this.chkArraySize);
        int checkerIdx = 0;
        boolean init = true;
        for (i = this.idx; i <= this.arraysize; ++i) {
            if (this.chunksize < this.commitinterval && this.commitinterval % this.chunksize != 0) {
                if (init) {
                    if (this.idx == 0) {
                        this.checkArray[checkerIdx] = this.idx;
                        this.checkArray[++checkerIdx] = this.chunksize;
                        ++checkerIdx;
                        init = false;
                        continue;
                    }
                    this.checkArray[checkerIdx] = this.idx;
                    ++checkerIdx;
                    if (this.idx % this.commitinterval == 0) {
                        this.checkArray[checkerIdx] = this.idx + this.chunksize;
                        ++checkerIdx;
                    }
                    init = false;
                    continue;
                }
                if (i % this.commitinterval != 0) continue;
                this.checkArray[checkerIdx] = i;
                if (i == this.arraysize) continue;
                this.checkArray[++checkerIdx] = i + this.chunksize;
                ++checkerIdx;
                continue;
            }
            if (this.commitinterval < this.chunksize) {
                if (i % this.commitinterval != 0) continue;
                this.checkArray[checkerIdx] = i;
                ++checkerIdx;
                continue;
            }
            if (i % this.chunksize == 0) {
                this.checkArray[checkerIdx] = i;
                ++checkerIdx;
                continue;
            }
            if (i % this.commitinterval != 0) continue;
            this.checkArray[checkerIdx] = i;
            ++checkerIdx;
        }
        for (int n = 0; n < this.chkArraySize; ++n) {
            System.out.println("WRITE: chunk write point[" + n + " ]: " + this.checkArray[n]);
        }
        for (i = 0; i < this.arraysize; ++i) {
            this.writerDataArray[i] = 0;
        }
    }

    private int round(int i1, int i2) {
        return (i1 + i2 - 1) / i2;
    }

    @Close
    public void closeWriter() throws Exception {
        for (int i = 0; i < this.arraysize; ++i) {
            System.out.println("WRITE: writerDataArray[" + i + "] = " + this.writerDataArray[i]);
        }
    }

    @WriteItems
    public void writeMyData(ArrayList<ReadRecord> myData) throws Exception {
        int i;
        System.out.println("writeMyData receives chunk size=" + myData.size());
        System.out.println("WRITE: before writing, idx = " + this.idx);
        if (this.checkArray[this.chunkWriteIteration] == this.idx) {
            System.out.println("WRITE: the chunk write is occuring at the correct boundry (idx) ->" + this.idx);
        } else if (this.checkArray[this.chunkWriteIteration] == (this.chunkWriteIteration + 1) * (this.commitinterval % this.chunksize)) {
            System.out.println("WRITE: the chunk write is occuring at the correct boundry ->" + this.checkArray[this.chunkWriteIteration]);
        } else {
            System.out.println("WRITE: we have an issue! throw exception here");
            throw new Exception("WRITE: the chunk write did not at the correct boundry (idx) ->" + this.idx);
        }
        ++this.chunkWriteIteration;
        for (i = 0; i < myData.size(); ++i) {
            this.writerDataArray[this.idx] = myData.get(i).getCount();
            ++this.idx;
        }
        for (i = 0; i < this.arraysize; ++i) {
            System.out.println("WRITE: writerDataArray[" + i + "] = " + this.writerDataArray[i]);
        }
        System.out.println("WRITE: idx = " + this.idx + " and i = " + i);
        System.out.println("WRITE: chunkWriteIteration= " + this.chunkWriteIteration);
        System.out.println("WRITE: size of checkArray->" + this.checkArray.length);
    }

    @CheckpointInfo
    public ArrayIndexCheckpointData getCPD() throws Exception {
        ArrayIndexCheckpointData _chkptData = new ArrayIndexCheckpointData();
        _chkptData.setCurrentIndex(this.idx);
        return _chkptData;
    }
}

