/*
 * Decompiled with CFR 0.152.
 */
package jsr352.tck.specialized;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import javax.batch.annotation.BatchContext;
import javax.batch.annotation.Batchlet;
import javax.batch.annotation.Process;
import javax.batch.annotation.Stop;
import javax.batch.runtime.context.JobContext;
import javax.batch.runtime.context.StepContext;
import javax.inject.Named;

@Batchlet(value="BatchletUsingStepContextImpl")
@Named(value="BatchletUsingStepContextImpl")
public class BatchletUsingStepContextImpl {
    @BatchContext
    private StepContext<MyTransient, MyPersistent> stepCtx = null;
    @BatchContext
    private JobContext jobCtx = null;
    private String BEGAN = "MadeItToBegin";
    private String CANCEL = "Cancelled";
    private String PROCESSED = "Processed";
    public static String GOOD_STEP_EXIT_STATUS = "VERY GOOD INVOCATION";
    public static String GOOD_JOB_EXIT_STATUS = "JOB: " + GOOD_STEP_EXIT_STATUS;

    private void begin() throws Exception {
        System.out.println("BatchletUsingStepContextImpl - @BeginStep");
        assert (this.stepCtx.getExitStatus() == null);
        this.stepCtx.setExitStatus(this.BEGAN);
    }

    @Process
    public String process() throws Exception {
        this.begin();
        System.out.println("BatchletUsingStepContextImpl - @Process");
        assert (this.stepCtx.getExitStatus().equals(this.BEGAN));
        this.stepCtx.setPersistentUserData((Object)new MyPersistent(4));
        this.stepCtx.setTransientUserData((Object)new MyTransient(3));
        this.stepCtx.setExitStatus(this.PROCESSED);
        this.end();
        return "COMPLETED";
    }

    @Stop
    public void cancel() throws Exception {
        System.out.println("BatchletUsingStepContextImpl - @Cancel");
        this.stepCtx.setExitStatus(this.CANCEL);
    }

    private void end() throws Exception {
        System.out.println("BatchletUsingStepContextImpl - formerly @EndStep");
        MyPersistent p = (MyPersistent)this.stepCtx.getPersistentUserData();
        MyTransient t = (MyTransient)this.stepCtx.getTransientUserData();
        System.out.println("MyBatchLetImpl.end() p,t = " + p.data + "," + t.data);
        assert (this.stepCtx.getExitStatus().equals(this.PROCESSED));
        this.stepCtx.setExitStatus(GOOD_STEP_EXIT_STATUS);
        this.jobCtx.setExitStatus(GOOD_JOB_EXIT_STATUS);
    }

    private class MyPersistent
    implements Externalizable {
        int data = 0;

        MyPersistent(int x) {
            this.data = x;
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
        }
    }

    private class MyTransient {
        int data = 0;

        MyTransient(int x) {
            this.data = x;
        }
    }
}

