/*
 * Decompiled with CFR 0.152.
 */
package jsr352.tck.specialized;

import java.util.logging.Logger;
import javax.batch.annotation.BatchContext;
import javax.batch.annotation.BatchProperty;
import javax.batch.annotation.Batchlet;
import javax.batch.annotation.BeginStep;
import javax.batch.annotation.EndStep;
import javax.batch.annotation.Process;
import javax.batch.annotation.Stop;
import javax.batch.runtime.context.JobContext;
import javax.batch.runtime.context.StepContext;
import javax.inject.Named;

@Batchlet(value="BatchletStopOnEndOn")
@Named(value="BatchletStopOnEndOn")
public class BatchletStopOnEndOn {
    private static final String sourceClass = BatchletStopOnEndOn.class.getName();
    private static final Logger logger = Logger.getLogger(sourceClass);
    @BatchContext
    StepContext<?, ?> stepCtx;
    @BatchContext
    JobContext<?> jobCtx;
    @BatchProperty(name="execution.number")
    String executionNumberString;

    @BeginStep
    public void begin() throws Exception {
        logger.fine(sourceClass + ".begin()");
    }

    @Process
    public String process() throws Exception {
        logger.fine(sourceClass + ".calculateExitStatus(), executionNumberString = " + this.executionNumberString);
        int execNum = Integer.parseInt(this.executionNumberString);
        String stepId = this.stepCtx.getId();
        logger.fine(sourceClass + ".calculateExitStatus(), execution # = " + execNum + ", stepId = " + stepId);
        String exitStatus = this.calculateExitStatus();
        logger.fine(sourceClass + ".process(); Exiting with exitStatus = " + exitStatus);
        return exitStatus;
    }

    private String calculateExitStatus() {
        logger.fine(sourceClass + ".calculateExitStatus(), executionNumberString = " + this.executionNumberString);
        int execNum = Integer.parseInt(this.executionNumberString);
        String stepId = this.stepCtx.getId();
        logger.fine(sourceClass + ".calculateExitStatus(), execution # = " + execNum + ", stepId = " + stepId);
        if (stepId.equals("step1")) {
            switch (execNum) {
                case 1: {
                    return "ES.STEP1";
                }
            }
            return "ILLEGAL.STATE";
        }
        if (stepId.equals("step2")) {
            switch (execNum) {
                case 2: {
                    return "ES.STEP2";
                }
            }
            return "ILLEGAL.STATE";
        }
        if (stepId.equals("step3")) {
            switch (execNum) {
                case 3: {
                    return "ES.STEP3";
                }
            }
            return "ILLEGAL.STATE";
        }
        return "ILLEGAL.STATE";
    }

    @Stop
    public void cancel() throws Exception {
        logger.fine(sourceClass + ".cancel()");
    }

    @EndStep
    public void end() throws Exception {
        logger.fine(sourceClass + ".end()");
    }
}

