/*
 * Decompiled with CFR 0.152.
 */
package jsr352.tck.specialized;

import java.util.Random;
import java.util.logging.Logger;
import javax.batch.annotation.BatchContext;
import javax.batch.annotation.BatchProperty;
import javax.batch.annotation.Batchlet;
import javax.batch.annotation.BeginStep;
import javax.batch.annotation.EndStep;
import javax.batch.annotation.Process;
import javax.batch.annotation.Stop;
import javax.batch.runtime.context.StepContext;
import javax.inject.Named;

@Batchlet(value="BatchletRestartStateMachine")
@Named(value="BatchletRestartStateMachine")
public class BatchletRestartStateMachineImpl {
    private static final String sourceClass = BatchletRestartStateMachineImpl.class.getName();
    private static final Logger logger = Logger.getLogger(sourceClass);
    @BatchContext
    StepContext<?, ?> stepCtx;
    @BatchProperty(name="execution.number")
    String executionNumberString;

    @BeginStep
    public void begin() throws Exception {
        logger.fine(sourceClass + ".begin()");
    }

    @Process
    public String process() throws Exception {
        logger.fine(sourceClass + ".process()");
        Random r = new Random();
        int x = r.nextInt();
        int y = r.nextInt();
        logger.fine(sourceClass + ".process(); Before (x,y)=(" + x + "," + y + ")");
        for (int i = 0; i < 10; ++i) {
            x = y * x % 3469;
            y = x * y % 3491;
        }
        logger.fine(sourceClass + ".process(); After (x,y)=(" + x + "," + y + ")");
        String exitStatus = this.calculateExitStatus();
        logger.fine(sourceClass + ".process(); Exiting with exitStatus = " + exitStatus);
        return exitStatus;
    }

    @Stop
    public void cancel() throws Exception {
        logger.fine(sourceClass + ".cancel()");
    }

    @EndStep
    public void end() throws Exception {
        logger.fine(sourceClass + ".end()");
    }

    private String calculateExitStatus() {
        logger.fine(sourceClass + ".calculateExitStatus(), executionNumberString = " + this.executionNumberString);
        int execNum = Integer.parseInt(this.executionNumberString);
        String stepId = this.stepCtx.getId();
        logger.fine(sourceClass + ".calculateExitStatus(), execution # = " + execNum + ", stepId = " + stepId);
        if (stepId.equals("step1")) {
            switch (execNum) {
                case 1: {
                    return "STOP.1";
                }
                case 2: {
                    return "STOP.2";
                }
                case 4: {
                    return "GO";
                }
                case 5: {
                    return "STOP.5";
                }
            }
            return "ILLEGAL.STATE";
        }
        if (stepId.equals("step2")) {
            switch (execNum) {
                case 3: {
                    return "GO";
                }
            }
            return "ILLEGAL.STATE";
        }
        if (stepId.equals("step3")) {
            switch (execNum) {
                case 3: {
                    return "STOP.3";
                }
                case 4: {
                    return "STOP.4";
                }
                case 6: {
                    return "GO";
                }
            }
            return "ILLEGAL.STATE";
        }
        if (stepId.equals("step4")) {
            switch (execNum) {
                case 6: {
                    return "GO";
                }
            }
            return "ILLEGAL.STATE";
        }
        return "ILLEGAL.STATE";
    }
}

