/*
 * Decompiled with CFR 0.152.
 */
package jsr352.tck.chunkartifacts;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.logging.Logger;
import javax.batch.annotation.AfterStep;
import javax.batch.annotation.BatchContext;
import javax.batch.annotation.StepListener;
import javax.batch.runtime.context.JobContext;
import javax.batch.runtime.context.StepContext;
import javax.inject.Named;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;
import jsr352.tck.chunkartifacts.ConnectionHelper;
import jsr352.tck.common.StatusConstants;

@StepListener(value="InventoryStepListener")
@Named(value="InventoryStepListener")
public class InventoryStepListener
implements StatusConstants {
    private static final String sourceClass = InventoryStepListener.class.getName();
    private static final Logger logger = Logger.getLogger(sourceClass);
    @BatchContext
    StepContext<?, ?> stepCtx;
    @BatchContext
    JobContext<?> jobCtx;
    protected String jndiName = "jdbc/orderDB";
    protected DataSource dataSource = null;

    private void init() throws NamingException {
        InitialContext ctx = new InitialContext();
        this.dataSource = (DataSource)ctx.lookup(this.jndiName);
    }

    private int getInventoryCount() throws Exception {
        int n;
        this.init();
        Connection connection = null;
        PreparedStatement statement = null;
        ResultSet rs = null;
        try {
            connection = ConnectionHelper.getConnection(this.dataSource);
            statement = connection.prepareStatement("select itemID, quantity from inventory where itemID = ?");
            statement.setInt(1, 1);
            rs = statement.executeQuery();
            int quantity = -1;
            while (rs.next()) {
                quantity = rs.getInt("quantity");
            }
            n = quantity;
        }
        catch (SQLException e) {
            try {
                throw e;
            }
            catch (Throwable throwable) {
                ConnectionHelper.cleanupConnection(connection, rs, statement);
                throw throwable;
            }
        }
        ConnectionHelper.cleanupConnection(connection, rs, statement);
        return n;
    }

    public void beforeStep() {
    }

    @AfterStep
    public void afterStep() throws Exception {
        logger.fine("afterStep");
        int finalInventoryCount = this.getInventoryCount();
        String initCheckpoint = this.stepCtx.getProperties().getProperty("init.checkpoint");
        String exitStatus = "Inventory=" + finalInventoryCount + " InitialCheckpoint=" + initCheckpoint;
        this.jobCtx.setExitStatus(exitStatus);
    }
}

